/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qfile.h>
#include <qstringlist.h>

#include <file.h>
#include <fileexporterbibtex.h>
#include "fileexporterdocbook5.h"

namespace BibTeX
{

    FileExporterDocBook5::FileExporterDocBook5( const QString& classPath )
            : FileExporterToolchain(), m_classPath( classPath )
    {
        bibTeXFilename = QString( workingDir ).append( "/bibtex-to-docbook5.bib" );
        outputFilename = QString( workingDir ).append( "/bibtex-to-docbook5.bib.xml" );
    }


    FileExporterDocBook5::~FileExporterDocBook5()
    {
        // nothing
    }

    bool FileExporterDocBook5::save( QIODevice* iodevice, const File* bibtexfile, QStringList *errorLog )
    {
        m_mutex.lock();
        bool result = FALSE;

        QFile bibtexFile( bibTeXFilename );
        if ( bibtexFile.open( IO_WriteOnly ) )
        {
            FileExporter * bibtexExporter = new FileExporterBibTeX();
            result = bibtexExporter->save( &bibtexFile, bibtexfile, errorLog );
            bibtexFile.close();
            delete bibtexExporter;
        }

        if ( result )
            result = runBib2Db5( iodevice, errorLog );

        m_mutex.unlock();
        return result;
    }

    bool FileExporterDocBook5::save( QIODevice* iodevice, const Element* element, QStringList *errorLog )
    {
        m_mutex.lock();
        bool result = FALSE;

        QFile bibtexFile( bibTeXFilename );
        if ( bibtexFile.open( IO_WriteOnly ) )
        {
            FileExporter * bibtexExporter = new FileExporterBibTeX();
            result = bibtexExporter->save( &bibtexFile, element, errorLog );
            bibtexFile.close();
            delete bibtexExporter;
        }

        if ( result )
            result = runBib2Db5( iodevice, errorLog );

        m_mutex.unlock();
        return result;
    }

    bool FileExporterDocBook5::runBib2Db5( QIODevice* iodevice, QStringList *errorLog )
    {
        QStringList cmdLine;
        cmdLine << "java" << "-cp" << m_classPath << "net.sf.bib2db5.DB5Converter" << "-O" << "." << "bibtex-to-docbook5.bib";

        if ( runProcess( cmdLine, errorLog ) && writeFileToIODevice( outputFilename, iodevice ) )
            return TRUE;
        else
            return FALSE;
    }

}
