/*
  Copyright (c) 2016 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef GRANTLEEVIEWFORMATTER_H
#define GRANTLEEVIEWFORMATTER_H

#include "PimCommon/GenericGrantleeFormatter"
#include "article.h"
#include "articleformatter.h"

namespace Akregator
{
class Folder;
class GrantleeViewFormatter : public PimCommon::GenericGrantleeFormatter
{
    Q_OBJECT
public:
    explicit GrantleeViewFormatter(const QString &htmlFileName, const QString &themePath, const QUrl &imageDir, int deviceDpiY, QObject *parent = Q_NULLPTR);
    ~GrantleeViewFormatter();

    QString formatArticles(const QVector<Article> &article, ArticleFormatter::IconOption icon);
    QString formatFolder(Akregator::Folder *node);
    QString formatFeed(Akregator::Feed *feed);
private:
    void addStandardObject(QVariantHash &grantleeObject);
    int pointsToPixel(int pointSize) const;
    QUrl mImageDir;
    QString mHtmlArticleFileName;
    QString mDirectionString;
    QString mGrantleeThemePath;
    int mDeviceDpiY;
};
}

#endif // GRANTLEEVIEWFORMATTER_H
