
# TODO: set correct path in call to cmake
# e.g. cmake /usr/src/lyx/lyx-devel/development/cmake -DCMAKE_INSTALL_PREFIX=/usr/local/share/lyx2.0 -Dnls=1

if(NOT(LYX_BUNDLE) AND APPLE)
        message(STATUS "Installing to ${CMAKE_INSTALL_PREFIX}, defined by CMAKE_INSTALL_PREFIX")
endif()
set(OSX_BUNDLE_FILES "")

# Install files into OS X bundle
macro(lyx_install_osx basedir files)
  if(LYX_BUNDLE_PROPERTY_MODE STREQUAL "ON")
    foreach(file ${files})
      set_source_files_properties("${file}" PROPERTIES MACOSX_PACKAGE_LOCATION "Resources/${basedir}")
    endforeach()
  else()
    list(APPEND OSX_BUNDLE_FILES "${files}")
  endif()
endmacro(lyx_install_osx)

# the macro scans the directories "_parent_src_dir/_dir/_current_dir" for *._file_type files
# and installs the files in CMAKE_INSTALL_PREFIX/_current_dir
# dir_item is on item of the remaining arguments
macro(lyx_install _parent_src_dir _gl_dir _file_type)
  #message("checking parents ${_parent_src_dir}")
  file(GLOB _dirs RELATIVE "${_parent_src_dir}" ${_parent_src_dir}/${_gl_dir})
  #cmake bug on Windows: if _gl_dir==. _dirs is empty but on linux _dirs==.
  if(NOT _dirs)
    set(_dirs .)
  endif() 
  foreach(_dir ${_dirs})
    foreach(_glob_dir ${ARGN})
      file(GLOB _dir_list ${_parent_src_dir}/${_dir}/${_glob_dir})
      if(NOT _dir_list)
        if(_glob_dir STREQUAL ".")
          set(_dir_list ${_parent_src_dir}/${_dir}/.)
        endif()
      endif()
      #message(STATUS "${_dir}/${_glob_dir} -> ${_dir_list} ")
      foreach(_current_dir ${_dir_list})
        file(GLOB _item_list ${_current_dir}/${_file_type})
        #cmake bug: globbing with * also returns directories on Windows
        set(files_list ${_item_list})
	set(program_list)
        foreach(_current_item ${_item_list})
	  if(files_list)
	    if(IS_DIRECTORY ${_current_item})
	      #message(STATUS "removing dir ${_current_item}")
              list(REMOVE_ITEM files_list "${_current_item}")
            else()
	      if(_current_item MATCHES "/\\.[^/]+$")
		#message(STATUS "removing hidden ${_current_item}")
		list(REMOVE_ITEM files_list "${_current_item}")
	      endif()
	      if(_current_item MATCHES "\\.in$")
		#message(STATUS "removing .in file ${_current_item}")
		list(REMOVE_ITEM files_list "${_current_item}")
	      endif()
	      if(_current_item MATCHES "\\.py$")
		list(REMOVE_ITEM files_list "${_current_item}")
		list(APPEND program_list "${_current_item}")
	      endif()
	    endif()
          endif()
        endforeach(_current_item)
        if(files_list)
          list(REMOVE_ITEM files_list "${_current_dir}/lyx.svg")
          list(REMOVE_ITEM files_list "${_current_dir}/Makefile.am")
          list(REMOVE_ITEM files_list "${_current_dir}/layouttranslations")
          GET_FILENAME_COMPONENT(_base_dir ${_current_dir} NAME)
          if(_glob_dir STREQUAL ".")
            set(_base_dir .)
          endif()
          #message(STATUS "install ${LYX_DATA_SUBDIR}${_dir}/${_base_dir}: ${files_list} ")
          #message(STATUS "install at ${CMAKE_INSTALL_PREFIX}/${LYX_DATA_SUBDIR}${_dir}/${_base_dir}")
	  if(APPLE)
	    lyx_install_osx("${_dir}/${_based_dir}" "${files_list}")
	  else()
	    install(FILES ${files_list} DESTINATION ${LYX_DATA_SUBDIR}${_dir}/${_base_dir})
	  endif(APPLE)
        endif()
	if(program_list)
	  if(_glob_dir STREQUAL ".")
	    set(_base_dir .)
	  endif()
	  if(APPLE)
	    lyx_install_osx("${_dir}/${_based_dir}" "${program_list}")
	  else()
	    install(PROGRAMS ${program_list} DESTINATION ${LYX_DATA_SUBDIR}${_dir}/${_base_dir})
	  endif(APPLE)
	endif()
      endforeach(_current_dir)
    endforeach(_glob_dir)
  endforeach(_dir)
endmacro(lyx_install)


# language-specific-directories (like ca, de, es ...) are now globbed as "[a-z][a-z]"
set(_all_languages "[a-z][a-z]")

lyx_install(${TOP_SRC_DIR}/lib bind         *.bind   . ${_all_languages})
lyx_install(${TOP_SRC_DIR}/lib commands     *.def    .)

# this is handled in doc/CMakeLists.txt
#lyx_install(${TOP_SRC_DIR}/lib doc          *.lyx    . ${_all_languages})
#lyx_install(${TOP_SRC_DIR}/lib doc          *.txt    . ${_all_languages})
lyx_install(${TOP_SRC_DIR}/lib doc          *      biblio clipart)

lyx_install(${TOP_SRC_DIR}/lib doc/${_all_languages} *    clipart)

lyx_install(${TOP_SRC_DIR}/lib examples     *      . ${_all_languages} springer thesis)
lyx_install(${TOP_SRC_DIR}/lib fonts        *      .)
lyx_install(${TOP_SRC_DIR}/lib images       *      . math ipa commands attic classic oxygen)
lyx_install(${TOP_SRC_DIR}/lib kbd          *      .)
lyx_install(${TOP_SRC_DIR}/lib layouts      *      .)
lyx_install(${TOP_SRC_DIR}/lib lyx2lyx      *.py   .)
lyx_install(${TOP_SRC_DIR}/lib scripts      *.py   .)
lyx_install(${TOP_SRC_DIR}/lib scripts      *.R    .)
lyx_install(${TOP_SRC_DIR}/lib templates    *      . attic)
lyx_install(${TOP_SRC_DIR}/lib tex          *      .)
lyx_install(${TOP_SRC_DIR}/lib ui           *      .)
lyx_install(${TOP_SRC_DIR}/lib .            *      .)

# Install
if(APPLE)
    lyx_install(${TOP_SRC_DIR}/development/MacOSX . *.sdef   .)
    lyx_install(${TOP_SRC_DIR}/development/MacOSX . *.icns   .)
    lyx_install(${TOP_SRC_DIR}/development/MacOSX . qt.conf   .)
endif()

install(PROGRAMS ${TOP_SRC_DIR}/lib/scripts/listerrors DESTINATION scripts)

if(UNIX)
  set(program_suffix ${PROGRAM_SUFFIX})
  configure_file(${TOP_SRC_DIR}/lib/lyx.desktop.in lyx${PROGRAM_SUFFIX}.desktop)
  install(FILES ${CMAKE_CURRENT_BINARY_DIR}/lyx${PROGRAM_SUFFIX}.desktop DESTINATION applications)
  install(FILES ${TOP_SRC_DIR}/lib/images/lyx.svg RENAME lyx${PROGRAM_SUFFIX}.svg DESTINATION images)
endif()
