------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                         Copyright (C) 2000-2003                          --
--                                ACT-Europe                                --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
------------------------------------------------------------------------------

--  A standalone Web server, with pages embedded into the executable.

with Ada.Text_IO;

with AWS.Default;
with AWS.Server;

with Res_Demo_CB;

with rdemo; -- this package is generated by AWSRes
pragma Warnings (Off, rdemo);

procedure Res_Demo is

   WS : AWS.Server.HTTP;

begin
   Ada.Text_IO.Put_Line
     ("Call me on port"
      & Positive'Image (AWS.Default.Server_Port)
      & ", I will stop in 60 seconds...");

   AWS.Server.Start (WS, "Res Demo",
                     Max_Connection => 1,
                     Callback       => Res_Demo_CB.RD_CB'Access);

   delay 60.0;

   AWS.Server.Shutdown (WS);
end Res_Demo;
