#!/bin/bash

PKG="libcitygml0"
VERSION=$1
if [ -z "${VERSION}" ]; then
	echo "Usage: $0 <VERSION>"
	exit 1
fi

SYMBOLS="debian/${PKG}.symbols"
ABI=$(echo $VERSION | sed 's/[\+\~].*$//')

# Remove old architecture symbols files
rm -f symbols.*

# Download binary packages from snapshot.debian.org
debsnap --binary ${PKG} -f

for DEB in binary-${PKG}/${PKG}_${VERSION}_*.deb
do
	export DIR=$(echo $DEB | sed 's/.deb$//')

	# Unpack binary package
	dpkg-deb -R $DEB $DIR
	
	export VERSION=$(dpkg-deb -f $DEB Version)

	export ARCH=$(dpkg-deb -f $DEB Architecture)
	export LIB=$(find $DIR -type l -name "*.so.?")
	
	# Generate symbols for the architecture
	pkgkde-gensymbols -p${PKG} -v${ABI} -Osymbols.${ARCH} -e${LIB}
done

# Create symbols file for all architectures
pkgkde-symbolshelper create -o ${SYMBOLS} -v ${ABI} symbols.*

