/* testutilities.c generated by valac 0.14.2, the Vala compiler
 * generated from testutilities.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsobasics.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MY_ENUM_TYPE (my_enum_type_get_type ())

#define TYPE_MY_ENUM_TYPE2 (my_enum_type2_get_type ())
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FooData FooData;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

typedef enum  {
	MY_ENUM_TYPE_FOO,
	MY_ENUM_TYPE_BAR,
	MY_ENUM_TYPE_BAZ
} MyEnumType;

typedef enum  {
	MY_ENUM_TYPE2_FOO,
	MY_ENUM_TYPE2_BAR,
	MY_ENUM_TYPE2_BAZ
} MyEnumType2;

struct _FooData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gint _tmp0_;
	gchar** _tmp1_;
	gchar** text;
	gint text_length1;
	gint _text_size_;
	GMainLoop* _tmp2_;
	GError * _inner_error_;
};


extern GMainLoop* loop;
GMainLoop* loop = NULL;

void test_utilities_filehandling_presence (void);
void test_utilities_filehandling_read (void);
void test_utilities_filehandling_write (void);
void test_utilities_filehandling_remove_tree (void);
void test_utilities_stringhandling_list (void);
GType my_enum_type_get_type (void) G_GNUC_CONST;
GType my_enum_type2_get_type (void) G_GNUC_CONST;
void test_utilities_stringhandling_enum (void);
void test_utilities_stringhandling_key_value_split (void);
void test_utilities_stringhandling_filter_by_allowed_characters (void);
void test_utilities_utility_program_name (void);
void test_utilities_utility_prefix_for_executable (void);
void test_utilities_utility_first_available_program (void);
void test_utilities_utility_create_backtrace (void);
void test_utilities_utility_hardware (void);
static void foo_data_free (gpointer _data);
void foo (GAsyncReadyCallback _callback_, gpointer _user_data_);
void foo_finish (GAsyncResult* _res_);
static gboolean foo_co (FooData* _data_);
static void foo_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void test_utilities_network_textForUri (void);
static gboolean __lambda0_ (void);
static gboolean ___lambda0__gsource_func (gpointer self);
void _vala_main (gchar** args, int args_length1);
static void _test_utilities_stringhandling_list_gcallback (void);
static void _test_utilities_stringhandling_enum_gcallback (void);
static void _test_utilities_stringhandling_key_value_split_gcallback (void);
static void _test_utilities_stringhandling_filter_by_allowed_characters_gcallback (void);
static void _test_utilities_utility_program_name_gcallback (void);
static void _test_utilities_utility_prefix_for_executable_gcallback (void);
static void _test_utilities_utility_first_available_program_gcallback (void);
static void _test_utilities_network_textForUri_gcallback (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void test_utilities_filehandling_presence (void) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = fso_framework_file_handling_isPresent ("this.file.not.present");
	g_assert (_tmp0_ == FALSE);
	_tmp1_ = fso_framework_file_handling_isPresent ("textfile.txt");
	g_assert (_tmp1_ == TRUE);
}


void test_utilities_filehandling_read (void) {
	gchar* _tmp0_ = NULL;
	gchar* contents;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = fso_framework_file_handling_read ("textfile.txt");
	contents = _tmp0_;
	_tmp1_ = g_str_has_prefix (contents, "GNU");
	g_assert (_tmp1_);
	_g_free0 (contents);
}


void test_utilities_filehandling_write (void) {
	gchar* _tmp0_ = NULL;
	gchar* contents;
	fso_framework_file_handling_write ("Dieser Satz kein Verb!", "nocontent.txt", FALSE);
	_tmp0_ = fso_framework_file_handling_read ("nocontent.txt");
	contents = _tmp0_;
	g_assert (g_strcmp0 (contents, "Dieser Satz kein Verb!") == 0);
	_g_free0 (contents);
}


void test_utilities_filehandling_remove_tree (void) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = fso_framework_file_handling_removeTree ("this_tree_not_existing");
	g_assert (!_tmp0_);
	g_mkdir_with_parents ("./this/tree/existing", 0777);
	_tmp1_ = fso_framework_file_handling_removeTree ("this");
	g_assert (_tmp1_);
}


void test_utilities_stringhandling_list (void) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** list;
	gint list_length1;
	gint _list_size_;
	gchar* _tmp5_ = NULL;
	gchar* line;
	_tmp0_ = g_strdup ("Dieser");
	_tmp1_ = g_strdup ("Satz");
	_tmp2_ = g_strdup ("kein");
	_tmp3_ = g_strdup ("Verb!");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	list = _tmp4_;
	list_length1 = 4;
	_list_size_ = list_length1;
	_tmp5_ = fso_framework_string_handling_stringListToString (list, list_length1);
	line = _tmp5_;
	g_assert (g_strcmp0 (line, "[ \"Dieser\", \"Satz\", \"kein\", \"Verb!\" ]") == 0);
	_g_free0 (line);
	list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
}


GType my_enum_type_get_type (void) {
	static volatile gsize my_enum_type_type_id__volatile = 0;
	if (g_once_init_enter (&my_enum_type_type_id__volatile)) {
		static const GEnumValue values[] = {{MY_ENUM_TYPE_FOO, "MY_ENUM_TYPE_FOO", "foo"}, {MY_ENUM_TYPE_BAR, "MY_ENUM_TYPE_BAR", "bar"}, {MY_ENUM_TYPE_BAZ, "MY_ENUM_TYPE_BAZ", "baz"}, {0, NULL, NULL}};
		GType my_enum_type_type_id;
		my_enum_type_type_id = g_enum_register_static ("MyEnumType", values);
		g_once_init_leave (&my_enum_type_type_id__volatile, my_enum_type_type_id);
	}
	return my_enum_type_type_id__volatile;
}


GType my_enum_type2_get_type (void) {
	static volatile gsize my_enum_type2_type_id__volatile = 0;
	if (g_once_init_enter (&my_enum_type2_type_id__volatile)) {
		static const GEnumValue values[] = {{MY_ENUM_TYPE2_FOO, "MY_ENUM_TYPE2_FOO", "foo"}, {MY_ENUM_TYPE2_BAR, "MY_ENUM_TYPE2_BAR", "bar"}, {MY_ENUM_TYPE2_BAZ, "MY_ENUM_TYPE2_BAZ", "baz"}, {0, NULL, NULL}};
		GType my_enum_type2_type_id;
		my_enum_type2_type_id = g_enum_register_static ("MyEnumType2", values);
		g_once_init_leave (&my_enum_type2_type_id__volatile, my_enum_type2_type_id);
	}
	return my_enum_type2_type_id__volatile;
}


void test_utilities_stringhandling_enum (void) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gpointer _tmp9_ = NULL;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gpointer _tmp13_ = NULL;
	gpointer _tmp14_ = NULL;
	gpointer _tmp15_ = NULL;
	gpointer _tmp16_ = NULL;
	_tmp0_ = fso_framework_string_handling_enumToString (TYPE_MY_ENUM_TYPE, NULL, NULL, GINT_TO_POINTER (MY_ENUM_TYPE_FOO));
	_tmp1_ = _tmp0_;
	g_assert (g_strcmp0 (_tmp1_, "MY_ENUM_TYPE_FOO") == 0);
	_g_free0 (_tmp1_);
	_tmp2_ = fso_framework_string_handling_enumToString (TYPE_MY_ENUM_TYPE, NULL, NULL, GINT_TO_POINTER (MY_ENUM_TYPE_BAR));
	_tmp3_ = _tmp2_;
	g_assert (g_strcmp0 (_tmp3_, "MY_ENUM_TYPE_BAR") == 0);
	_g_free0 (_tmp3_);
	_tmp4_ = fso_framework_string_handling_enumToString (TYPE_MY_ENUM_TYPE, NULL, NULL, GINT_TO_POINTER (MY_ENUM_TYPE_BAZ));
	_tmp5_ = _tmp4_;
	g_assert (g_strcmp0 (_tmp5_, "MY_ENUM_TYPE_BAZ") == 0);
	_g_free0 (_tmp5_);
	_tmp6_ = fso_framework_string_handling_enumToString (TYPE_MY_ENUM_TYPE, NULL, NULL, GINT_TO_POINTER ((MyEnumType) 1000));
	_tmp7_ = _tmp6_;
	_tmp8_ = g_str_has_prefix (_tmp7_, "Unknown");
	g_assert (_tmp8_);
	_g_free0 (_tmp7_);
	_tmp9_ = fso_framework_string_handling_convertEnum (TYPE_MY_ENUM_TYPE, NULL, NULL, TYPE_MY_ENUM_TYPE2, NULL, NULL, GINT_TO_POINTER (MY_ENUM_TYPE_BAR));
	g_assert (GPOINTER_TO_INT (_tmp9_) == MY_ENUM_TYPE2_BAR);
	_tmp10_ = fso_framework_string_handling_enumFromName (TYPE_MY_ENUM_TYPE, NULL, NULL, "MY_ENUM_TYPE_FOO");
	g_assert (GPOINTER_TO_INT (_tmp10_) == MY_ENUM_TYPE_FOO);
	_tmp11_ = fso_framework_string_handling_enumToNick (TYPE_MY_ENUM_TYPE, NULL, NULL, GINT_TO_POINTER (MY_ENUM_TYPE_FOO));
	_tmp12_ = _tmp11_;
	g_assert (g_strcmp0 (_tmp12_, "foo") == 0);
	_g_free0 (_tmp12_);
	_tmp13_ = fso_framework_string_handling_enumFromNick (TYPE_MY_ENUM_TYPE, NULL, NULL, "foo");
	g_assert (GPOINTER_TO_INT (_tmp13_) == MY_ENUM_TYPE_FOO);
	_tmp14_ = fso_framework_string_handling_enumFromString (TYPE_MY_ENUM_TYPE, NULL, NULL, "foobar", GINT_TO_POINTER (MY_ENUM_TYPE_FOO));
	g_assert (GPOINTER_TO_INT (_tmp14_) == MY_ENUM_TYPE_FOO);
	_tmp15_ = fso_framework_string_handling_enumFromString (TYPE_MY_ENUM_TYPE, NULL, NULL, "bar", GINT_TO_POINTER (MY_ENUM_TYPE_FOO));
	g_assert (GPOINTER_TO_INT (_tmp15_) == MY_ENUM_TYPE_BAR);
	_tmp16_ = fso_framework_string_handling_enumFromString (TYPE_MY_ENUM_TYPE, NULL, NULL, "MY_ENUM_TYPE_BAR", GINT_TO_POINTER (MY_ENUM_TYPE_FOO));
	g_assert (GPOINTER_TO_INT (_tmp16_) == MY_ENUM_TYPE_BAR);
}


void test_utilities_stringhandling_key_value_split (void) {
	GHashTable* _tmp0_ = NULL;
	GHashTable* _result_;
	GHashTable* _tmp1_;
	guint _tmp2_ = 0U;
	GHashTable* _tmp3_ = NULL;
	GHashTable* _tmp4_;
	guint _tmp5_ = 0U;
	GHashTable* _tmp6_ = NULL;
	GHashTable* _tmp7_;
	guint _tmp8_ = 0U;
	GHashTable* _tmp9_;
	gconstpointer _tmp10_ = NULL;
	GHashTable* _tmp11_ = NULL;
	GHashTable* _tmp12_;
	guint _tmp13_ = 0U;
	GHashTable* _tmp14_;
	gconstpointer _tmp15_ = NULL;
	GHashTable* _tmp16_;
	gconstpointer _tmp17_ = NULL;
	_tmp0_ = fso_framework_string_handling_splitKeyValuePairs ("");
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	_tmp2_ = g_hash_table_size (_tmp1_);
	g_assert (_tmp2_ == ((guint) 0));
	_tmp3_ = fso_framework_string_handling_splitKeyValuePairs ("YoKurt Nix Nix");
	_g_hash_table_unref0 (_result_);
	_result_ = _tmp3_;
	_tmp4_ = _result_;
	_tmp5_ = g_hash_table_size (_tmp4_);
	g_assert (_tmp5_ == ((guint) 0));
	_tmp6_ = fso_framework_string_handling_splitKeyValuePairs ("FOO=BAR");
	_g_hash_table_unref0 (_result_);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	_tmp8_ = g_hash_table_size (_tmp7_);
	g_assert (_tmp8_ == ((guint) 1));
	_tmp9_ = _result_;
	_tmp10_ = g_hash_table_lookup (_tmp9_, "FOO");
	g_assert (g_strcmp0 ((const gchar*) _tmp10_, "BAR") == 0);
	_tmp11_ = fso_framework_string_handling_splitKeyValuePairs ("prefix\nFOO=BAR\nBOO=FAZ\npostfix");
	_g_hash_table_unref0 (_result_);
	_result_ = _tmp11_;
	_tmp12_ = _result_;
	_tmp13_ = g_hash_table_size (_tmp12_);
	g_assert (_tmp13_ == ((guint) 2));
	_tmp14_ = _result_;
	_tmp15_ = g_hash_table_lookup (_tmp14_, "FOO");
	g_assert (g_strcmp0 ((const gchar*) _tmp15_, "BAR") == 0);
	_tmp16_ = _result_;
	_tmp17_ = g_hash_table_lookup (_tmp16_, "BOO");
	g_assert (g_strcmp0 ((const gchar*) _tmp17_, "FAZ") == 0);
	_g_hash_table_unref0 (_result_);
}


void test_utilities_stringhandling_filter_by_allowed_characters (void) {
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	_tmp0_ = fso_framework_string_handling_filterByAllowedCharacters ("(0) 69-243 448", "+0123456789wp");
	_result_ = _tmp0_;
	g_assert (g_strcmp0 (_result_, "069243448") == 0);
	_g_free0 (_result_);
}


void test_utilities_utility_program_name (void) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = fso_framework_utility_programName ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_str_has_suffix (_tmp1_, "lt-testutilities");
	g_assert (_tmp2_);
	_g_free0 (_tmp1_);
}


void test_utilities_utility_prefix_for_executable (void) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = fso_framework_utility_prefixForExecutable ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_str_has_suffix (_tmp1_, "lt-testutilities/");
	g_assert (_tmp2_);
	_g_free0 (_tmp1_);
}


void test_utilities_utility_first_available_program (void) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_ = NULL;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	_tmp0_ = g_strdup ("foo");
	_tmp1_ = g_strdup ("bar");
	_tmp2_ = g_strdup ("yo");
	_tmp3_ = g_strdup ("kurt");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 4;
	_tmp6_ = fso_framework_utility_firstAvailableProgram (_tmp5_, 4);
	_tmp7_ = _tmp6_;
	g_assert (_tmp7_ == NULL);
	_g_free0 (_tmp7_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp8_ = g_strdup ("bash");
	_tmp9_ = g_strdup ("dash");
	_tmp10_ = g_strdup ("ash");
	_tmp11_ = g_new0 (gchar*, 3 + 1);
	_tmp11_[0] = _tmp8_;
	_tmp11_[1] = _tmp9_;
	_tmp11_[2] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 3;
	_tmp13_ = fso_framework_utility_firstAvailableProgram (_tmp12_, 3);
	_tmp14_ = _tmp13_;
	g_assert (g_strcmp0 (_tmp14_, "/bin/bash") == 0);
	_g_free0 (_tmp14_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
}


void test_utilities_utility_create_backtrace (void) {
	gint _tmp0_ = 0;
	gchar** _tmp1_ = NULL;
	gchar** backtrace;
	gint backtrace_length1;
	gint _backtrace_size_;
	_tmp1_ = fso_framework_utility_createBacktrace (&_tmp0_);
	backtrace = _tmp1_;
	backtrace_length1 = _tmp0_;
	_backtrace_size_ = backtrace_length1;
	g_assert (backtrace_length1 > 2);
	backtrace = (_vala_array_free (backtrace, backtrace_length1, (GDestroyNotify) g_free), NULL);
}


void test_utilities_utility_hardware (void) {
	gchar* _tmp0_ = NULL;
	gchar* hardware;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp4_;
	_tmp0_ = fso_framework_utility_hardware ();
	hardware = _tmp0_;
	_tmp2_ = hardware;
	if (g_strcmp0 (_tmp2_, "default") == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = hardware;
		_tmp1_ = g_strcmp0 (_tmp3_, "GenuineIntel") == 0;
	}
	_tmp4_ = _tmp1_;
	g_assert (_tmp4_);
	_g_free0 (hardware);
}


static void foo_data_free (gpointer _data) {
	FooData* _data_;
	_data_ = _data;
	g_slice_free (FooData, _data_);
}


void foo (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FooData* _data_;
	_data_ = g_slice_new0 (FooData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, foo);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, foo_data_free);
	foo_co (_data_);
}


void foo_finish (GAsyncResult* _res_) {
	FooData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void foo_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FooData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	foo_co (_data_);
}


static gboolean foo_co (FooData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_state_ = 1;
	fso_framework_network_textForUri ("checkip.dyndns.org", "/", foo_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = fso_framework_network_textForUri_finish (_data_->_res_, &_data_->_tmp0_, &_data_->_inner_error_);
	_data_->text = _data_->_tmp1_;
	_data_->text_length1 = _data_->_tmp0_;
	_data_->_text_size_ = _data_->text_length1;
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp2_ = loop;
	g_main_loop_quit (_data_->_tmp2_);
	_data_->text = (_vala_array_free (_data_->text, _data_->text_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean __lambda0_ (void) {
	gboolean result = FALSE;
	foo (NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean ___lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda0_ ();
	return result;
}


void test_utilities_network_textForUri (void) {
	GMainLoop* _tmp0_;
	GMainLoop* _tmp1_;
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (loop);
	loop = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda0__gsource_func, NULL, NULL);
	_tmp1_ = loop;
	g_main_loop_run (_tmp1_);
}


static void _test_utilities_stringhandling_list_gcallback (void) {
	test_utilities_stringhandling_list ();
}


static void _test_utilities_stringhandling_enum_gcallback (void) {
	test_utilities_stringhandling_enum ();
}


static void _test_utilities_stringhandling_key_value_split_gcallback (void) {
	test_utilities_stringhandling_key_value_split ();
}


static void _test_utilities_stringhandling_filter_by_allowed_characters_gcallback (void) {
	test_utilities_stringhandling_filter_by_allowed_characters ();
}


static void _test_utilities_utility_program_name_gcallback (void) {
	test_utilities_utility_program_name ();
}


static void _test_utilities_utility_prefix_for_executable_gcallback (void) {
	test_utilities_utility_prefix_for_executable ();
}


static void _test_utilities_utility_first_available_program_gcallback (void) {
	test_utilities_utility_first_available_program ();
}


static void _test_utilities_network_textForUri_gcallback (void) {
	test_utilities_network_textForUri ();
}


void _vala_main (gchar** args, int args_length1) {
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/Utilities/StringHandling/List", _test_utilities_stringhandling_list_gcallback);
	g_test_add_func ("/Utilities/StringHandling/Enum", _test_utilities_stringhandling_enum_gcallback);
	g_test_add_func ("/Utilities/StringHandling/Split", _test_utilities_stringhandling_key_value_split_gcallback);
	g_test_add_func ("/Utilities/StringHandling/Filter", _test_utilities_stringhandling_filter_by_allowed_characters_gcallback);
	g_test_add_func ("/Utilities/Utility/programName", _test_utilities_utility_program_name_gcallback);
	g_test_add_func ("/Utilities/Utility/prefixForExecutable", _test_utilities_utility_prefix_for_executable_gcallback);
	g_test_add_func ("/Utilities/Utility/firstAvailableProgram", _test_utilities_utility_first_available_program_gcallback);
	g_test_add_func ("/Utilities/Network/textForUri", _test_utilities_network_textForUri_gcallback);
	g_test_run ();
}


int main (int argc, char ** argv) {
	g_type_init ();
	_vala_main (argv, argc);
	return 0;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



