------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2012-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNATCOLL.Readline;  use GNATCOLL.Readline;
with GNATCOLL.Utils;     use GNATCOLL.Utils;
with Ada.Text_IO;        use Ada.Text_IO;
with GNAT.Strings;       use GNAT.Strings;

procedure Main is
   function Command_Completion
      (Text : String; State : Integer) return String;
   function Completer
      (Full_Line, Text : String;
       Start, Last : Integer) return Possible_Completions;

   Commands : array (Natural range <>) of String_Access :=
      (1 => new String'("help"),
       2 => new String'("history"),
       3 => new String'("parse"));

   List_Index : Natural;

   function Command_Completion
      (Text : String; State : Integer) return String
   is
   begin
      if State = 0 then
         List_Index := Commands'First;
      end if;

      while List_Index <= Commands'Last loop
         List_Index := List_Index + 1;

         if Starts_With (Commands (List_Index - 1).all, Text) then
            return Commands (List_Index - 1).all;
         end if;
      end loop;

      return "";
   end Command_Completion;

   function Completer
      (Full_Line, Text : String;
       Start, Last : Integer) return Possible_Completions is
   begin
      --  If first word on the line, complete the command
      if Start = 0 then
         return Completion_Matches
            (Text, Command_Completion'Unrestricted_Access);

      --  Else use standard completion
      else
         return null;
      end if;
   end Completer;

   Hist_File : constant String := ".gnatcolltest";
begin
   GNATCOLL.Readline.Initialize
      (Appname      => "gnatcolltest",
       History_File => Hist_File,
       Completer    => Completer'Unrestricted_Access);

   loop
      declare
         Input : constant String := Get_Line (Prompt => ">>> ");
      begin
         exit when Input = "";
         Put_Line ("    input was '" & Input & "'");
      end;
   end loop;

   GNATCOLL.Readline.Finalize (History_File => Hist_File);

end Main;
