/* manager.c generated by valac 0.14.2, the Vala compiler
 * generated from manager.vala, do not modify */

/*
 * This file is part of libgsm0710mux
 *
 * (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */
/*===========================================================================*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <fsotransport.h>
#include <fsobasics.h>
#include <config.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define GSM0710MUX_TYPE_CHANNEL_INFO (gsm0710mux_channel_info_get_type ())
#define GSM0710MUX_CHANNEL_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSM0710MUX_TYPE_CHANNEL_INFO, Gsm0710muxChannelInfo))
#define GSM0710MUX_CHANNEL_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSM0710MUX_TYPE_CHANNEL_INFO, Gsm0710muxChannelInfoClass))
#define GSM0710MUX_IS_CHANNEL_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSM0710MUX_TYPE_CHANNEL_INFO))
#define GSM0710MUX_IS_CHANNEL_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSM0710MUX_TYPE_CHANNEL_INFO))
#define GSM0710MUX_CHANNEL_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSM0710MUX_TYPE_CHANNEL_INFO, Gsm0710muxChannelInfoClass))

typedef struct _Gsm0710muxChannelInfo Gsm0710muxChannelInfo;
typedef struct _Gsm0710muxChannelInfoClass Gsm0710muxChannelInfoClass;
typedef struct _Gsm0710muxChannelInfoPrivate Gsm0710muxChannelInfoPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Gsm0710muxParamSpecChannelInfo Gsm0710muxParamSpecChannelInfo;

#define GSM0710MUX_TYPE_MANAGER (gsm0710mux_manager_get_type ())
#define GSM0710MUX_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSM0710MUX_TYPE_MANAGER, Gsm0710muxManager))
#define GSM0710MUX_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSM0710MUX_TYPE_MANAGER, Gsm0710muxManagerClass))
#define GSM0710MUX_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSM0710MUX_TYPE_MANAGER))
#define GSM0710MUX_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSM0710MUX_TYPE_MANAGER))
#define GSM0710MUX_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSM0710MUX_TYPE_MANAGER, Gsm0710muxManagerClass))

typedef struct _Gsm0710muxManager Gsm0710muxManager;
typedef struct _Gsm0710muxManagerClass Gsm0710muxManagerClass;
typedef struct _Gsm0710muxManagerPrivate Gsm0710muxManagerPrivate;

#define TYPE_MULTIPLEXER (multiplexer_get_type ())
#define MULTIPLEXER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTIPLEXER, Multiplexer))
#define MULTIPLEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTIPLEXER, MultiplexerClass))
#define IS_MULTIPLEXER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTIPLEXER))
#define IS_MULTIPLEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTIPLEXER))
#define MULTIPLEXER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTIPLEXER, MultiplexerClass))

typedef struct _Multiplexer Multiplexer;
typedef struct _MultiplexerClass MultiplexerClass;
#define _multiplexer_unref0(var) ((var == NULL) ? NULL : (var = (multiplexer_unref (var), NULL)))
#define _gsm0710mux_channel_info_unref0(var) ((var == NULL) ? NULL : (var = (gsm0710mux_channel_info_unref (var), NULL)))
typedef struct _gsm0710mux_manager_allocChannelData gsm0710mux_manager_allocChannelData;

struct _Gsm0710muxChannelInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	Gsm0710muxChannelInfoPrivate * priv;
	gchar* consumer;
	gint number;
	FsoFrameworkTransport* transport;
};

struct _Gsm0710muxChannelInfoClass {
	GTypeClass parent_class;
	void (*finalize) (Gsm0710muxChannelInfo *self);
};

struct _Gsm0710muxParamSpecChannelInfo {
	GParamSpec parent_instance;
};

struct _Gsm0710muxManager {
	GObject parent_instance;
	Gsm0710muxManagerPrivate * priv;
	guint channel_ack_timeout;
};

struct _Gsm0710muxManagerClass {
	GObjectClass parent_class;
};

struct _Gsm0710muxManagerPrivate {
	Multiplexer* muxer;
	FsoFrameworkSmartKeyFile* config;
	FsoFrameworkLogger* logger;
	gboolean autoopen;
	gboolean autoclose;
	gboolean autoexit;
	gchar* session_type;
	gchar* session_path;
	guint session_speed;
	gboolean session_mode;
	guint session_framesize;
	gboolean session_unclosable;
	guint wakeup_threshold;
	guint wakeup_waitms;
	guint send_pause_threshold;
	guint channelsOpen;
};

typedef enum  {
	GSM0710MUX_MUXER_ERROR_CHANNEL_TAKEN,
	GSM0710MUX_MUXER_ERROR_INVALID_CHANNEL,
	GSM0710MUX_MUXER_ERROR_INVALID_TRANSPORT,
	GSM0710MUX_MUXER_ERROR_NO_SESSION,
	GSM0710MUX_MUXER_ERROR_NO_CHANNEL,
	GSM0710MUX_MUXER_ERROR_SESSION_ALREADY_OPEN,
	GSM0710MUX_MUXER_ERROR_SESSION_OPEN_ERROR
} Gsm0710muxMuxerError;
#define GSM0710MUX_MUXER_ERROR gsm0710mux_muxer_error_quark ()
struct _gsm0710mux_manager_allocChannelData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Gsm0710muxManager* self;
	Gsm0710muxChannelInfo* channel;
	gint result;
	FsoFrameworkLogger* _tmp0_;
	Gsm0710muxChannelInfo* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	Gsm0710muxChannelInfo* _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	Gsm0710muxChannelInfo* _tmp8_;
	FsoFrameworkTransport* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	Multiplexer* _tmp18_;
	gboolean _tmp19_;
	FsoFrameworkLogger* _tmp20_;
	gboolean _tmp21_;
	guint _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	guint _tmp25_;
	Gsm0710muxChannelInfo* _tmp26_;
	gint _tmp27_;
	GError* _tmp28_;
	Multiplexer* _tmp29_;
	GError* _tmp30_;
	Multiplexer* _tmp31_;
	Gsm0710muxChannelInfo* _tmp32_;
	gint _tmp33_;
	gint number;
	guint _tmp34_;
	GError * _inner_error_;
};


static gpointer gsm0710mux_channel_info_parent_class = NULL;
static gpointer gsm0710mux_manager_parent_class = NULL;
extern gboolean gsm0710mux_manager_leave_mux_alone;
gboolean gsm0710mux_manager_leave_mux_alone = FALSE;
extern gboolean gsm0710mux_manager_leave_fc_alone;
gboolean gsm0710mux_manager_leave_fc_alone = FALSE;

gpointer gsm0710mux_channel_info_ref (gpointer instance);
void gsm0710mux_channel_info_unref (gpointer instance);
GParamSpec* gsm0710mux_param_spec_channel_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gsm0710mux_value_set_channel_info (GValue* value, gpointer v_object);
void gsm0710mux_value_take_channel_info (GValue* value, gpointer v_object);
gpointer gsm0710mux_value_get_channel_info (const GValue* value);
GType gsm0710mux_channel_info_get_type (void) G_GNUC_CONST;
enum  {
	GSM0710MUX_CHANNEL_INFO_DUMMY_PROPERTY
};
Gsm0710muxChannelInfo* gsm0710mux_channel_info_new (void);
Gsm0710muxChannelInfo* gsm0710mux_channel_info_construct (GType object_type);
static void gsm0710mux_channel_info_finalize (Gsm0710muxChannelInfo* obj);
GType gsm0710mux_manager_get_type (void) G_GNUC_CONST;
gpointer multiplexer_ref (gpointer instance);
void multiplexer_unref (gpointer instance);
GParamSpec* param_spec_multiplexer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_multiplexer (GValue* value, gpointer v_object);
void value_take_multiplexer (GValue* value, gpointer v_object);
gpointer value_get_multiplexer (const GValue* value);
GType multiplexer_get_type (void) G_GNUC_CONST;
#define GSM0710MUX_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GSM0710MUX_TYPE_MANAGER, Gsm0710muxManagerPrivate))
enum  {
	GSM0710MUX_MANAGER_DUMMY_PROPERTY
};
Gsm0710muxManager* gsm0710mux_manager_new (void);
Gsm0710muxManager* gsm0710mux_manager_construct (GType object_type);
#define CONST_LIBGSM0710MUX_CONFIG_SECTION "libgsm0710mux"
#define CONST_LIBGSM0710MUX_LOGGING_DOMAIN "libgsm0710mux"
gchar* gsm0710mux_manager_repr (Gsm0710muxManager* self);
static gchar* _gsm0710mux_manager_repr_repr_delegate (gpointer self);
void _gsm0710mux_manager_shutdown (Gsm0710muxManager* self);
void multiplexer_closeSession (Multiplexer* self);
void gsm0710mux_manager_channelsHaveBeenClosed (Gsm0710muxManager* self, gint num);
gchar* gsm0710mux_manager_getVersion (Gsm0710muxManager* self);
gboolean gsm0710mux_manager_hasAutoSession (Gsm0710muxManager* self);
GQuark gsm0710mux_muxer_error_quark (void);
void gsm0710mux_manager_openSession (Gsm0710muxManager* self, gboolean advanced, gint framesize, const gchar* porttype, const gchar* portname, gint portspeed, GError** error);
Multiplexer* multiplexer_new (gboolean advanced, gint framesize, const gchar* porttype, const gchar* portname, gint portspeed, Gsm0710muxManager* manager);
Multiplexer* multiplexer_construct (GType object_type, gboolean advanced, gint framesize, const gchar* porttype, const gchar* portname, gint portspeed, Gsm0710muxManager* manager);
gboolean multiplexer_initSession (Multiplexer* self);
void gsm0710mux_manager_setWakeupThreshold (Gsm0710muxManager* self, guint seconds, guint waitms, GError** error);
void gsm0710mux_manager_setSendPauseThreshold (Gsm0710muxManager* self, guint ms, GError** error);
void gsm0710mux_manager_closeSession (Gsm0710muxManager* self, GError** error);
static void gsm0710mux_manager_allocChannel_data_free (gpointer _data);
void gsm0710mux_manager_allocChannel (Gsm0710muxManager* self, Gsm0710muxChannelInfo* channel, GAsyncReadyCallback _callback_, gpointer _user_data_);
gint gsm0710mux_manager_allocChannel_finish (Gsm0710muxManager* self, GAsyncResult* _res_, GError** error);
static gboolean gsm0710mux_manager_allocChannel_co (gsm0710mux_manager_allocChannelData* _data_);
void multiplexer_allocChannel (Multiplexer* self, Gsm0710muxChannelInfo* info, GAsyncReadyCallback _callback_, gpointer _user_data_);
gint multiplexer_allocChannel_finish (Multiplexer* self, GAsyncResult* _res_, GError** error);
static void gsm0710mux_manager_allocChannel_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void gsm0710mux_manager_releaseChannel (Gsm0710muxManager* self, const gchar* name, GError** error);
void multiplexer_releaseChannel (Multiplexer* self, const gchar* name, GError** error);
void multiplexer_setWakeupThreshold (Multiplexer* self, guint seconds, guint waitms, GError** error);
void multiplexer_setSendPauseThreshold (Multiplexer* self, guint ms);
void gsm0710mux_manager_setStatus (Gsm0710muxManager* self, gint channel, const gchar* status, GError** error);
void multiplexer_setStatus (Multiplexer* self, gint channel, const gchar* status, GError** error);
void gsm0710mux_manager_testCommand (Gsm0710muxManager* self, guint8* data, int data_length1, GError** error);
void multiplexer_testCommand (Multiplexer* self, guint8* data, int data_length1);
static void gsm0710mux_manager_finalize (GObject* obj);


Gsm0710muxChannelInfo* gsm0710mux_channel_info_construct (GType object_type) {
	Gsm0710muxChannelInfo* self = NULL;
	self = (Gsm0710muxChannelInfo*) g_type_create_instance (object_type);
	return self;
}


Gsm0710muxChannelInfo* gsm0710mux_channel_info_new (void) {
	return gsm0710mux_channel_info_construct (GSM0710MUX_TYPE_CHANNEL_INFO);
}


static void gsm0710mux_value_channel_info_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gsm0710mux_value_channel_info_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gsm0710mux_channel_info_unref (value->data[0].v_pointer);
	}
}


static void gsm0710mux_value_channel_info_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gsm0710mux_channel_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gsm0710mux_value_channel_info_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gsm0710mux_value_channel_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Gsm0710muxChannelInfo* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gsm0710mux_channel_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gsm0710mux_value_channel_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Gsm0710muxChannelInfo** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gsm0710mux_channel_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gsm0710mux_param_spec_channel_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	Gsm0710muxParamSpecChannelInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GSM0710MUX_TYPE_CHANNEL_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gsm0710mux_value_get_channel_info (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GSM0710MUX_TYPE_CHANNEL_INFO), NULL);
	return value->data[0].v_pointer;
}


void gsm0710mux_value_set_channel_info (GValue* value, gpointer v_object) {
	Gsm0710muxChannelInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GSM0710MUX_TYPE_CHANNEL_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GSM0710MUX_TYPE_CHANNEL_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gsm0710mux_channel_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gsm0710mux_channel_info_unref (old);
	}
}


void gsm0710mux_value_take_channel_info (GValue* value, gpointer v_object) {
	Gsm0710muxChannelInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GSM0710MUX_TYPE_CHANNEL_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GSM0710MUX_TYPE_CHANNEL_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gsm0710mux_channel_info_unref (old);
	}
}


static void gsm0710mux_channel_info_class_init (Gsm0710muxChannelInfoClass * klass) {
	gsm0710mux_channel_info_parent_class = g_type_class_peek_parent (klass);
	GSM0710MUX_CHANNEL_INFO_CLASS (klass)->finalize = gsm0710mux_channel_info_finalize;
}


static void gsm0710mux_channel_info_instance_init (Gsm0710muxChannelInfo * self) {
	self->ref_count = 1;
}


static void gsm0710mux_channel_info_finalize (Gsm0710muxChannelInfo* obj) {
	Gsm0710muxChannelInfo * self;
	self = GSM0710MUX_CHANNEL_INFO (obj);
	_g_free0 (self->consumer);
	_g_object_unref0 (self->transport);
}


GType gsm0710mux_channel_info_get_type (void) {
	static volatile gsize gsm0710mux_channel_info_type_id__volatile = 0;
	if (g_once_init_enter (&gsm0710mux_channel_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gsm0710mux_value_channel_info_init, gsm0710mux_value_channel_info_free_value, gsm0710mux_value_channel_info_copy_value, gsm0710mux_value_channel_info_peek_pointer, "p", gsm0710mux_value_channel_info_collect_value, "p", gsm0710mux_value_channel_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (Gsm0710muxChannelInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gsm0710mux_channel_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Gsm0710muxChannelInfo), 0, (GInstanceInitFunc) gsm0710mux_channel_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gsm0710mux_channel_info_type_id;
		gsm0710mux_channel_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Gsm0710muxChannelInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gsm0710mux_channel_info_type_id__volatile, gsm0710mux_channel_info_type_id);
	}
	return gsm0710mux_channel_info_type_id__volatile;
}


gpointer gsm0710mux_channel_info_ref (gpointer instance) {
	Gsm0710muxChannelInfo* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gsm0710mux_channel_info_unref (gpointer instance) {
	Gsm0710muxChannelInfo* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GSM0710MUX_CHANNEL_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar* _gsm0710mux_manager_repr_repr_delegate (gpointer self) {
	gchar* result;
	result = gsm0710mux_manager_repr (self);
	return result;
}


Gsm0710muxManager* gsm0710mux_manager_construct (GType object_type) {
	Gsm0710muxManager * self = NULL;
	FsoFrameworkSmartKeyFile* _tmp0_;
	FsoFrameworkSmartKeyFile* _tmp1_;
	FsoFrameworkSmartKeyFile* _tmp2_;
	FsoFrameworkLogger* _tmp3_ = NULL;
	FsoFrameworkLogger* _tmp4_;
	FsoFrameworkLogger* _tmp5_;
	gboolean _tmp6_ = FALSE;
	FsoFrameworkSmartKeyFile* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_ = FALSE;
	FsoFrameworkSmartKeyFile* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_ = FALSE;
	FsoFrameworkSmartKeyFile* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_ = FALSE;
	FsoFrameworkSmartKeyFile* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	FsoFrameworkSmartKeyFile* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	FsoFrameworkSmartKeyFile* _tmp22_;
	guint _tmp23_;
	gint _tmp24_ = 0;
	FsoFrameworkSmartKeyFile* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_ = FALSE;
	FsoFrameworkSmartKeyFile* _tmp28_;
	guint _tmp29_;
	gint _tmp30_ = 0;
	FsoFrameworkSmartKeyFile* _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_ = FALSE;
	FsoFrameworkSmartKeyFile* _tmp34_;
	guint _tmp35_;
	gint _tmp36_ = 0;
	FsoFrameworkSmartKeyFile* _tmp37_;
	guint _tmp38_;
	gint _tmp39_ = 0;
	FsoFrameworkSmartKeyFile* _tmp40_;
	guint _tmp41_;
	gint _tmp42_ = 0;
	FsoFrameworkSmartKeyFile* _tmp43_;
	guint _tmp44_;
	gint _tmp45_ = 0;
	FsoFrameworkSmartKeyFile* _tmp46_;
	gboolean _tmp47_ = FALSE;
	FsoFrameworkSmartKeyFile* _tmp48_;
	gboolean _tmp49_ = FALSE;
	self = (Gsm0710muxManager*) g_object_new (object_type, NULL);
	_tmp0_ = fso_framework_theConfig;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp1_;
	_tmp2_ = self->priv->config;
	_tmp3_ = fso_framework_logger_createFromKeyFile (_tmp2_, CONST_LIBGSM0710MUX_CONFIG_SECTION, CONST_LIBGSM0710MUX_LOGGING_DOMAIN);
	_g_object_unref0 (self->priv->logger);
	self->priv->logger = _tmp3_;
	_tmp4_ = self->priv->logger;
	fso_framework_logger_setReprDelegate (_tmp4_, _gsm0710mux_manager_repr_repr_delegate, self);
	_tmp5_ = self->priv->logger;
	_tmp6_ = fso_framework_logger_debug (_tmp5_, "Constructed");
	g_assert (_tmp6_);
	_tmp7_ = self->priv->config;
	_tmp8_ = self->priv->autoopen;
	_tmp9_ = fso_framework_smart_key_file_boolValue (_tmp7_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "muxer_autoopen", _tmp8_);
	self->priv->autoopen = _tmp9_;
	_tmp10_ = self->priv->config;
	_tmp11_ = self->priv->autoclose;
	_tmp12_ = fso_framework_smart_key_file_boolValue (_tmp10_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "muxer_autoclose", _tmp11_);
	self->priv->autoclose = _tmp12_;
	_tmp13_ = self->priv->config;
	_tmp14_ = self->priv->autoexit;
	_tmp15_ = fso_framework_smart_key_file_boolValue (_tmp13_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "muxer_autoexit", _tmp14_);
	self->priv->autoexit = _tmp15_;
	_tmp16_ = self->priv->config;
	_tmp17_ = self->priv->session_type;
	_tmp18_ = fso_framework_smart_key_file_stringValue (_tmp16_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "device_type", _tmp17_);
	_g_free0 (self->priv->session_type);
	self->priv->session_type = _tmp18_;
	_tmp19_ = self->priv->config;
	_tmp20_ = self->priv->session_path;
	_tmp21_ = fso_framework_smart_key_file_stringValue (_tmp19_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "device_port", _tmp20_);
	_g_free0 (self->priv->session_path);
	self->priv->session_path = _tmp21_;
	_tmp22_ = self->priv->config;
	_tmp23_ = self->priv->session_speed;
	_tmp24_ = fso_framework_smart_key_file_intValue (_tmp22_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "device_speed", (gint) _tmp23_);
	self->priv->session_speed = (guint) _tmp24_;
	_tmp25_ = self->priv->config;
	_tmp26_ = self->priv->session_mode;
	_tmp27_ = fso_framework_smart_key_file_boolValue (_tmp25_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "device_mux_mode", _tmp26_);
	self->priv->session_mode = _tmp27_;
	_tmp28_ = self->priv->config;
	_tmp29_ = self->priv->session_framesize;
	_tmp30_ = fso_framework_smart_key_file_intValue (_tmp28_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "device_mux_framesize", (gint) _tmp29_);
	self->priv->session_framesize = (guint) _tmp30_;
	_tmp31_ = self->priv->config;
	_tmp32_ = self->priv->session_unclosable;
	_tmp33_ = fso_framework_smart_key_file_boolValue (_tmp31_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "device_close_broken", _tmp32_);
	self->priv->session_unclosable = _tmp33_;
	_tmp34_ = self->priv->config;
	_tmp35_ = self->channel_ack_timeout;
	_tmp36_ = fso_framework_smart_key_file_intValue (_tmp34_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "device_ack_timeout", (gint) _tmp35_);
	self->channel_ack_timeout = (guint) _tmp36_;
	_tmp37_ = self->priv->config;
	_tmp38_ = self->priv->wakeup_threshold;
	_tmp39_ = fso_framework_smart_key_file_intValue (_tmp37_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "device_wakeup_threshold", (gint) _tmp38_);
	self->priv->wakeup_threshold = (guint) _tmp39_;
	_tmp40_ = self->priv->config;
	_tmp41_ = self->priv->wakeup_waitms;
	_tmp42_ = fso_framework_smart_key_file_intValue (_tmp40_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "device_wakeup_waitms", (gint) _tmp41_);
	self->priv->wakeup_waitms = (guint) _tmp42_;
	_tmp43_ = self->priv->config;
	_tmp44_ = self->priv->send_pause_threshold;
	_tmp45_ = fso_framework_smart_key_file_intValue (_tmp43_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "device_sendpause_threshold", (gint) _tmp44_);
	self->priv->send_pause_threshold = (guint) _tmp45_;
	_tmp46_ = self->priv->config;
	_tmp47_ = fso_framework_smart_key_file_boolValue (_tmp46_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "session_debug_leave_mux_alone", FALSE);
	gsm0710mux_manager_leave_mux_alone = _tmp47_;
	_tmp48_ = self->priv->config;
	_tmp49_ = fso_framework_smart_key_file_boolValue (_tmp48_, CONST_LIBGSM0710MUX_CONFIG_SECTION, "session_debug_leave_fc_alone", FALSE);
	gsm0710mux_manager_leave_fc_alone = _tmp49_;
	return self;
}


Gsm0710muxManager* gsm0710mux_manager_new (void) {
	return gsm0710mux_manager_construct (GSM0710MUX_TYPE_MANAGER);
}


gchar* gsm0710mux_manager_repr (Gsm0710muxManager* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("<>");
	result = _tmp0_;
	return result;
}


void _gsm0710mux_manager_shutdown (Gsm0710muxManager* self) {
	FsoFrameworkLogger* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Multiplexer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->logger;
	_tmp1_ = fso_framework_logger_debug (_tmp0_, "_shutdown");
	g_assert (_tmp1_);
	_tmp2_ = self->priv->muxer;
	if (_tmp2_ != NULL) {
		Multiplexer* _tmp3_;
		_tmp3_ = self->priv->muxer;
		multiplexer_closeSession (_tmp3_);
		_multiplexer_unref0 (self->priv->muxer);
		self->priv->muxer = NULL;
	}
}


void gsm0710mux_manager_channelsHaveBeenClosed (Gsm0710muxManager* self, gint num) {
	guint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	guint _tmp3_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->channelsOpen;
	_tmp1_ = num;
	self->priv->channelsOpen = _tmp0_ - _tmp1_;
	_tmp3_ = self->priv->channelsOpen;
	if (_tmp3_ == ((guint) 0)) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->autoclose;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		_gsm0710mux_manager_shutdown (self);
	}
}


gchar* gsm0710mux_manager_getVersion (Gsm0710muxManager* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (PACKAGE_VERSION);
	result = _tmp0_;
	return result;
}


gboolean gsm0710mux_manager_hasAutoSession (Gsm0710muxManager* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->autoopen;
	result = _tmp0_;
	return result;
}


void gsm0710mux_manager_openSession (Gsm0710muxManager* self, gboolean advanced, gint framesize, const gchar* porttype, const gchar* portname, gint portspeed, GError** error) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	FsoFrameworkLogger* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	Multiplexer* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (porttype != NULL);
	g_return_if_fail (portname != NULL);
	_tmp1_ = advanced;
	if (_tmp1_) {
		_tmp0_ = "advanced";
	} else {
		_tmp0_ = "basic";
	}
	_tmp2_ = self->priv->logger;
	_tmp3_ = _tmp0_;
	_tmp4_ = framesize;
	_tmp5_ = porttype;
	_tmp6_ = portname;
	_tmp7_ = portspeed;
	_tmp8_ = g_strdup_printf ("InitSession requested for mode %s, framesize %d, type %s, name %s @ %d", _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
	_tmp9_ = _tmp8_;
	fso_framework_logger_debug (_tmp2_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->muxer;
	if (_tmp10_ != NULL) {
		GError* _tmp11_;
		_tmp11_ = g_error_new_literal (GSM0710MUX_MUXER_ERROR, GSM0710MUX_MUXER_ERROR_SESSION_ALREADY_OPEN, "Close session before opening another one.");
		_inner_error_ = _tmp11_;
		if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		gboolean _tmp12_;
		gint _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		Multiplexer* _tmp17_;
		Multiplexer* _tmp18_;
		gboolean _tmp19_ = FALSE;
		_tmp12_ = advanced;
		_tmp13_ = framesize;
		_tmp14_ = porttype;
		_tmp15_ = portname;
		_tmp16_ = portspeed;
		_tmp17_ = multiplexer_new (_tmp12_, _tmp13_, _tmp14_, _tmp15_, _tmp16_, self);
		_multiplexer_unref0 (self->priv->muxer);
		self->priv->muxer = _tmp17_;
		_tmp18_ = self->priv->muxer;
		_tmp19_ = multiplexer_initSession (_tmp18_);
		if (!_tmp19_) {
			GError* _tmp20_;
			_multiplexer_unref0 (self->priv->muxer);
			self->priv->muxer = NULL;
			_tmp20_ = g_error_new_literal (GSM0710MUX_MUXER_ERROR, GSM0710MUX_MUXER_ERROR_SESSION_OPEN_ERROR, "Can't initialize the session");
			_inner_error_ = _tmp20_;
			if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
			gboolean _tmp21_ = FALSE;
			guint _tmp22_;
			gboolean _tmp24_;
			guint _tmp27_;
			_tmp22_ = self->priv->wakeup_threshold;
			if (_tmp22_ > ((guint) 0)) {
				guint _tmp23_;
				_tmp23_ = self->priv->wakeup_waitms;
				_tmp21_ = _tmp23_ > ((guint) 0);
			} else {
				_tmp21_ = FALSE;
			}
			_tmp24_ = _tmp21_;
			if (_tmp24_) {
				guint _tmp25_;
				guint _tmp26_;
				_tmp25_ = self->priv->wakeup_threshold;
				_tmp26_ = self->priv->wakeup_waitms;
				gsm0710mux_manager_setWakeupThreshold (self, _tmp25_, _tmp26_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			_tmp27_ = self->priv->send_pause_threshold;
			if (_tmp27_ > ((guint) 0)) {
				guint _tmp28_;
				_tmp28_ = self->priv->send_pause_threshold;
				gsm0710mux_manager_setSendPauseThreshold (self, _tmp28_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
	}
}


void gsm0710mux_manager_closeSession (Gsm0710muxManager* self, GError** error) {
	FsoFrameworkLogger* _tmp0_;
	Multiplexer* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->logger;
	fso_framework_logger_debug (_tmp0_, "CloseSession requested");
	_tmp1_ = self->priv->muxer;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (GSM0710MUX_MUXER_ERROR, GSM0710MUX_MUXER_ERROR_NO_SESSION, "Session has to be initialized first.");
		_inner_error_ = _tmp2_;
		if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		gboolean _tmp3_;
		_tmp3_ = self->priv->session_unclosable;
		if (_tmp3_) {
			FsoFrameworkLogger* _tmp4_;
			_tmp4_ = self->priv->logger;
			fso_framework_logger_debug (_tmp4_, "This device can't close the session [ignoring]");
		} else {
			Multiplexer* _tmp5_;
			_tmp5_ = self->priv->muxer;
			multiplexer_closeSession (_tmp5_);
		}
		_multiplexer_unref0 (self->priv->muxer);
		self->priv->muxer = NULL;
	}
}


static void gsm0710mux_manager_allocChannel_data_free (gpointer _data) {
	gsm0710mux_manager_allocChannelData* _data_;
	_data_ = _data;
	_gsm0710mux_channel_info_unref0 (_data_->channel);
	_g_object_unref0 (_data_->self);
	g_slice_free (gsm0710mux_manager_allocChannelData, _data_);
}


static gpointer _gsm0710mux_channel_info_ref0 (gpointer self) {
	return self ? gsm0710mux_channel_info_ref (self) : NULL;
}


void gsm0710mux_manager_allocChannel (Gsm0710muxManager* self, Gsm0710muxChannelInfo* channel, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	gsm0710mux_manager_allocChannelData* _data_;
	Gsm0710muxManager* _tmp0_;
	Gsm0710muxChannelInfo* _tmp1_;
	Gsm0710muxChannelInfo* _tmp2_;
	_data_ = g_slice_new0 (gsm0710mux_manager_allocChannelData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gsm0710mux_manager_allocChannel);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gsm0710mux_manager_allocChannel_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = channel;
	_tmp2_ = _gsm0710mux_channel_info_ref0 (_tmp1_);
	_data_->channel = _tmp2_;
	gsm0710mux_manager_allocChannel_co (_data_);
}


gint gsm0710mux_manager_allocChannel_finish (Gsm0710muxManager* self, GAsyncResult* _res_, GError** error) {
	gint result;
	gsm0710mux_manager_allocChannelData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void gsm0710mux_manager_allocChannel_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	gsm0710mux_manager_allocChannelData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gsm0710mux_manager_allocChannel_co (_data_);
}


static gboolean gsm0710mux_manager_allocChannel_co (gsm0710mux_manager_allocChannelData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->logger;
	_data_->_tmp1_ = _data_->channel;
	_data_->_tmp2_ = _data_->_tmp1_->consumer;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = string_to_string (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->channel;
	_data_->_tmp5_ = _data_->_tmp4_->number;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup_printf ("%i", _data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = _data_->channel;
	_data_->_tmp9_ = _data_->_tmp8_->transport;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = fso_framework_transport_getName (_data_->_tmp9_);
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = string_to_string (_data_->_tmp11_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = g_strconcat ("Consumer ", _data_->_tmp3_, " requested channel ", _data_->_tmp7_, " via ", _data_->_tmp12_, NULL);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = FALSE;
	_data_->_tmp15_ = fso_framework_logger_debug (_data_->_tmp0_, _data_->_tmp14_);
	g_assert (_data_->_tmp15_);
	_g_free0 (_data_->_tmp14_);
	_g_free0 (_data_->_tmp11_);
	_g_free0 (_data_->_tmp7_);
	_data_->_tmp17_ = _data_->self->priv->autoopen;
	if (_data_->_tmp17_) {
		_data_->_tmp18_ = _data_->self->priv->muxer;
		_data_->_tmp16_ = _data_->_tmp18_ == NULL;
	} else {
		_data_->_tmp16_ = FALSE;
	}
	_data_->_tmp19_ = _data_->_tmp16_;
	if (_data_->_tmp19_) {
		_data_->_tmp20_ = _data_->self->priv->logger;
		fso_framework_logger_debug (_data_->_tmp20_, "auto configuring...");
		_data_->_tmp21_ = _data_->self->priv->session_mode;
		_data_->_tmp22_ = _data_->self->priv->session_framesize;
		_data_->_tmp23_ = _data_->self->priv->session_type;
		_data_->_tmp24_ = _data_->self->priv->session_path;
		_data_->_tmp25_ = _data_->self->priv->session_speed;
		gsm0710mux_manager_openSession (_data_->self, _data_->_tmp21_, (gint) _data_->_tmp22_, _data_->_tmp23_, _data_->_tmp24_, (gint) _data_->_tmp25_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_data_->_tmp26_ = _data_->channel;
	_data_->_tmp27_ = _data_->_tmp26_->number;
	if (_data_->_tmp27_ < 0) {
		_data_->_tmp28_ = g_error_new_literal (GSM0710MUX_MUXER_ERROR, GSM0710MUX_MUXER_ERROR_INVALID_CHANNEL, "Channel has to be >= 0");
		_data_->_inner_error_ = _data_->_tmp28_;
		if (_data_->_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp29_ = _data_->self->priv->muxer;
	if (_data_->_tmp29_ == NULL) {
		_data_->_tmp30_ = g_error_new_literal (GSM0710MUX_MUXER_ERROR, GSM0710MUX_MUXER_ERROR_NO_SESSION, "Session has to be initialized first.");
		_data_->_inner_error_ = _data_->_tmp30_;
		if (_data_->_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	} else {
		_data_->_tmp31_ = _data_->self->priv->muxer;
		_data_->_tmp32_ = _data_->channel;
		_data_->_state_ = 1;
		multiplexer_allocChannel (_data_->_tmp31_, _data_->_tmp32_, gsm0710mux_manager_allocChannel_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp33_ = 0;
		_data_->_tmp33_ = multiplexer_allocChannel_finish (_data_->_tmp31_, _data_->_res_, &_data_->_inner_error_);
		_data_->number = _data_->_tmp33_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_data_->_tmp34_ = _data_->self->priv->channelsOpen;
		_data_->self->priv->channelsOpen = _data_->_tmp34_ + 1;
		_data_->result = _data_->number;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void gsm0710mux_manager_releaseChannel (Gsm0710muxManager* self, const gchar* name, GError** error) {
	FsoFrameworkLogger* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	Multiplexer* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->logger;
	_tmp1_ = name;
	_tmp2_ = g_strdup_printf ("ReleaseChannel requested for name %s", _tmp1_);
	_tmp3_ = _tmp2_;
	fso_framework_logger_debug (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->muxer;
	if (_tmp4_ == NULL) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (GSM0710MUX_MUXER_ERROR, GSM0710MUX_MUXER_ERROR_NO_SESSION, "Session has to be initialized first.");
		_inner_error_ = _tmp5_;
		if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		gboolean _tmp6_;
		_tmp6_ = self->priv->session_unclosable;
		if (_tmp6_) {
			FsoFrameworkLogger* _tmp7_;
			_tmp7_ = self->priv->logger;
			fso_framework_logger_debug (_tmp7_, "Not releasing channel due to session being unclosable (Ignoring)");
			return;
		} else {
			Multiplexer* _tmp8_;
			const gchar* _tmp9_;
			_tmp8_ = self->priv->muxer;
			_tmp9_ = name;
			multiplexer_releaseChannel (_tmp8_, _tmp9_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


void gsm0710mux_manager_setWakeupThreshold (Gsm0710muxManager* self, guint seconds, guint waitms, GError** error) {
	FsoFrameworkLogger* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	Multiplexer* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->logger;
	_tmp1_ = seconds;
	_tmp2_ = waitms;
	_tmp3_ = g_strdup_printf ("SetWakeupThreshold to wakeup before transmitting after %u sec. of idle" \
"ness, wait period = %u msec.", _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	fso_framework_logger_debug (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->muxer;
	if (_tmp5_ == NULL) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (GSM0710MUX_MUXER_ERROR, GSM0710MUX_MUXER_ERROR_NO_SESSION, "Session has to be initialized first.");
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		Multiplexer* _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		_tmp7_ = self->priv->muxer;
		_tmp8_ = seconds;
		_tmp9_ = waitms;
		multiplexer_setWakeupThreshold (_tmp7_, _tmp8_, _tmp9_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


void gsm0710mux_manager_setSendPauseThreshold (Gsm0710muxManager* self, guint ms, GError** error) {
	FsoFrameworkLogger* _tmp0_;
	guint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	Multiplexer* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->logger;
	_tmp1_ = ms;
	_tmp2_ = g_strdup_printf ("SetSendPauseThreshold to sleep until %u msec. have been passed until l" \
"ast command has been sent.", _tmp1_);
	_tmp3_ = _tmp2_;
	fso_framework_logger_debug (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->muxer;
	if (_tmp4_ == NULL) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (GSM0710MUX_MUXER_ERROR, GSM0710MUX_MUXER_ERROR_NO_SESSION, "Session has to be initialized first.");
		_inner_error_ = _tmp5_;
		if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		Multiplexer* _tmp6_;
		guint _tmp7_;
		_tmp6_ = self->priv->muxer;
		_tmp7_ = ms;
		multiplexer_setSendPauseThreshold (_tmp6_, _tmp7_);
	}
}


void gsm0710mux_manager_setStatus (Gsm0710muxManager* self, gint channel, const gchar* status, GError** error) {
	FsoFrameworkLogger* _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	Multiplexer* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (status != NULL);
	_tmp0_ = self->priv->logger;
	_tmp1_ = channel;
	_tmp2_ = status;
	_tmp3_ = g_strdup_printf ("SetStatus requested for channel %d, status = %s", _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	fso_framework_logger_debug (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->muxer;
	if (_tmp5_ == NULL) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (GSM0710MUX_MUXER_ERROR, GSM0710MUX_MUXER_ERROR_NO_SESSION, "Session has to be initialized first.");
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		Multiplexer* _tmp7_;
		gint _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = self->priv->muxer;
		_tmp8_ = channel;
		_tmp9_ = status;
		multiplexer_setStatus (_tmp7_, _tmp8_, _tmp9_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


void gsm0710mux_manager_testCommand (Gsm0710muxManager* self, guint8* data, int data_length1, GError** error) {
	FsoFrameworkLogger* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	Multiplexer* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->logger;
	_tmp1_ = data;
	_tmp1__length1 = data_length1;
	_tmp2_ = g_strdup_printf ("Sending %d test command bytes", _tmp1__length1);
	_tmp3_ = _tmp2_;
	fso_framework_logger_debug (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->muxer;
	_tmp5_ = data;
	_tmp5__length1 = data_length1;
	multiplexer_testCommand (_tmp4_, _tmp5_, _tmp5__length1);
}


static void gsm0710mux_manager_class_init (Gsm0710muxManagerClass * klass) {
	gsm0710mux_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (Gsm0710muxManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = gsm0710mux_manager_finalize;
}


static void gsm0710mux_manager_instance_init (Gsm0710muxManager * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = GSM0710MUX_MANAGER_GET_PRIVATE (self);
	self->priv->autoopen = FALSE;
	self->priv->autoclose = FALSE;
	self->priv->autoexit = TRUE;
	_tmp0_ = g_strdup ("serial");
	self->priv->session_type = _tmp0_;
	_tmp1_ = g_strdup ("/dev/ttySAC0");
	self->priv->session_path = _tmp1_;
	self->priv->session_speed = (guint) 115200;
	self->priv->session_mode = TRUE;
	self->priv->session_framesize = (guint) 64;
	self->priv->session_unclosable = FALSE;
	self->channel_ack_timeout = (guint) 10;
	self->priv->wakeup_threshold = (guint) 0;
	self->priv->wakeup_waitms = (guint) 0;
	self->priv->send_pause_threshold = (guint) 0;
}


static void gsm0710mux_manager_finalize (GObject* obj) {
	Gsm0710muxManager * self;
	FsoFrameworkLogger* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = GSM0710MUX_MANAGER (obj);
	_tmp0_ = self->priv->logger;
	_tmp1_ = fso_framework_logger_debug (_tmp0_, "Destructed");
	g_assert (_tmp1_);
	_multiplexer_unref0 (self->priv->muxer);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->logger);
	_g_free0 (self->priv->session_type);
	_g_free0 (self->priv->session_path);
	G_OBJECT_CLASS (gsm0710mux_manager_parent_class)->finalize (obj);
}


GType gsm0710mux_manager_get_type (void) {
	static volatile gsize gsm0710mux_manager_type_id__volatile = 0;
	if (g_once_init_enter (&gsm0710mux_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (Gsm0710muxManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gsm0710mux_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Gsm0710muxManager), 0, (GInstanceInitFunc) gsm0710mux_manager_instance_init, NULL };
		GType gsm0710mux_manager_type_id;
		gsm0710mux_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "Gsm0710muxManager", &g_define_type_info, 0);
		g_once_init_leave (&gsm0710mux_manager_type_id__volatile, gsm0710mux_manager_type_id);
	}
	return gsm0710mux_manager_type_id__volatile;
}



