// Copyright 2017 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "fxjs/xfa/cjx_digestmethod.h"

#include "xfa/fxfa/parser/cxfa_digestmethod.h"

CJX_DigestMethod::CJX_DigestMethod(CXFA_DigestMethod* node) : CJX_Node(node) {}

CJX_DigestMethod::~CJX_DigestMethod() = default;

void CJX_DigestMethod::use(CFXJSE_Value* pValue,
                           bool bSetting,
                           XFA_Attribute eAttribute) {
  Script_Attribute_String(pValue, bSetting, eAttribute);
}

void CJX_DigestMethod::usehref(CFXJSE_Value* pValue,
                               bool bSetting,
                               XFA_Attribute eAttribute) {
  Script_Attribute_String(pValue, bSetting, eAttribute);
}
