[bgfx](https://github.com/bkaradzic/bgfx) - Cross-platform rendering library
============================================================================

[![Build Status](https://travis-ci.org/bkaradzic/bgfx.svg?branch=master)](https://travis-ci.org/bkaradzic/bgfx)
[![Build status](https://ci.appveyor.com/api/projects/status/ipa3ojgeaet1oko5?svg=true)](https://ci.appveyor.com/project/bkaradzic/bgfx)
[![License](https://img.shields.io/badge/license-BSD--2%20clause-blue.svg)](https://bkaradzic.github.io/bgfx/license.html)
[![Join the chat at https://gitter.im/bkaradzic/bgfx](https://badges.gitter.im/bkaradzic/bgfx.svg)](https://gitter.im/bkaradzic/bgfx)

[What is it?](https://bkaradzic.github.io/bgfx/overview.html)
-------------------------------------------------------------

Cross-platform, graphics API agnostic, "Bring Your Own Engine/Framework" style
rendering library.

Supported rendering backends:

 * Direct3D 9
 * Direct3D 11
 * Direct3D 12
 * Metal
 * OpenGL 2.1
 * OpenGL 3.1+
 * OpenGL ES 2
 * OpenGL ES 3.1
 * WebGL 1.0
 * WebGL 2.0

Supported platforms:

 * Android (14+, ARM, x86, MIPS)
 * asm.js/Emscripten (1.25.0)
 * FreeBSD
 * iOS (iPhone, iPad, AppleTV)
 * Linux
 * MIPS Creator CI20
 * OSX (10.12+)
 * RaspberryPi
 * SteamLink
 * Windows (XP, Vista, 7, 8, 10)
 * UWP (Universal Windows, Xbox One)

Supported compilers:

 * Clang 3.3 and above
 * GCC 5 and above
 * VS2017 and above

Languages:

 * [C/C++ API documentation](https://bkaradzic.github.io/bgfx/bgfx.html)
 * [C#/VB/F# language API bindings](https://github.com/MikePopoloski/SharpBgfx)
 * [D language API bindings](https://github.com/DerelictOrg/DerelictBgfx)
 * [Go language API bindings](https://github.com/james4k/go-bgfx)
 * [Haskell language API bindings](https://github.com/haskell-game/bgfx)
 * [Lightweight Java Game Library 3 bindings](https://github.com/LWJGL/lwjgl3)
 * [Lua language API bindings 1](https://github.com/excessive/lua-bgfx)
 * [Lua language API bindings 2](https://github.com/cloudwu/lua-bgfx)
 * [Nim language API bindings](https://github.com/Halsys/nim-bgfx)
 * [Python language API bindings](https://github.com/jnadro/pybgfx#pybgf)
 * [Rust language API bindings](https://github.com/rhoot/bgfx-rs)
 * [Swift language API bindings](https://github.com/stuartcarnie/SwiftBGFX)

[Building](https://bkaradzic.github.io/bgfx/build.html)
----------------------------------------------------

 - AppVeyor https://ci.appveyor.com/project/bkaradzic/bgfx
 - TravisCI https://travis-ci.org/bkaradzic/bgfx

[Examples](https://bkaradzic.github.io/bgfx/examples.html)
----------------------------------------------------------

[API Reference](https://bkaradzic.github.io/bgfx/bgfx.html)
-----------------------------------------------------------

[Tools](https://bkaradzic.github.io/bgfx/tools.html)
----------------------------------------------------

Who is using it? #madewithbgfx
------------------------------

## Airmech

http://airmech.com/ AirMech is a free-to-play futuristic action real-time
strategy video game developed and published by Carbon Games.  
![airmech](https://www.mobygames.com/images/shots/l/830630-airmech-playstation-4-screenshot-blue-bar-on-your-mech-indicates.jpg)

## cmftStudio

https://github.com/dariomanesku/cmftStudio cmftStudio - cubemap filtering tool.  
![cmftStudio](https://github.com/dariomanesku/cmftStudio/raw/master/screenshots/cmftStudio_small.jpg)

## Crown

https://github.com/dbartolini/crown Crown is a general purpose data-driven game
engine, written from scratch with a minimalistic and data-oriented design
philosophy in mind.  
![Crown screenshot](https://raw.githubusercontent.com/dbartolini/crown/master/docs/shots/level-editor.png)

## Offroad Legends 2

http://www.dogbytegames.com/ Dogbyte Games is an indie mobile developer studio
focusing on racing games.  
![ios](http://www.dogbytegames.com/bgfx/offroadlegends2_bgfx_ipad2.jpg)

## Torque6

https://github.com/andr3wmac/Torque6 Torque 6 is an MIT licensed 3D engine
loosely based on Torque2D. Being neither Torque2D or Torque3D it is the 6th
derivative of the original Torque Engine.
<a href="http://www.youtube.com/watch?feature=player_embedded&v=p4LTM_QGK34" 
target="_blank"><img src="http://img.youtube.com/vi/p4LTM_QGK34/0.jpg" 
alt="Torque 6 Material Editor" width="640" height="480" border="0" /></a>

## Lumix Engine

https://github.com/nem0/LumixEngine LumixEngine is a MIT licensed 3D engine.
The main goal is performance and Unity-like usability.  
![LumixEngine screenshot](https://cloud.githubusercontent.com/assets/153526/12904252/3fcf130e-cece-11e5-878b-c9fe24c1b11a.png)

## Kepler Orbits

https://github.com/podgorskiy/KeplerOrbits KeplerOrbits - Tool that calculates
positions of celestial bodies using their orbital elements. [Web Demo](http://podgorskiy.com/KeplerOrbits/KeplerOrbits.html)

## CETech

https://github.com/cyberegoorg/cetech - CETech is Data-Driven game engine and
toolbox inspired by Bitsquid/Stingray engine.  
![CETech screenshot](https://github.com/cyberegoorg/cetech/raw/master/docs/img/prototyp.png)

## ioquake3

https://github.com/jpcy/ioq3-renderer-bgfx - A renderer for ioquake3 written in
C++ and using bgfx to support multiple rendering APIs.  
![ioq3-renderer-bgfx screenshot](https://camo.githubusercontent.com/052aa40c05120e56306294d3a1bb5f99f97de8c8/687474703a2f2f692e696d6775722e636f6d2f64364f6856594b2e6a7067)

## DLS

http://makingartstudios.itch.io/dls - DLS the digital logic simulator game.  
<a href="http://www.youtube.com/watch?feature=player_embedded&v=6o1-sQRNqcA
" target="_blank"><img src="http://img.youtube.com/vi/6o1-sQRNqcA/0.jpg" 
alt="DLS - Creating a 4-bit Register "
width="640" height="480" border="0" /></a>

http://dls.makingartstudios.com/sandbox/ - DLS: The Sandbox  
![dls-sandbox-screenshot](https://pbs.twimg.com/media/DBaFwOKWAAEq0mp.jpg:large)

## MAME

https://github.com/mamedev/mame MAME - Multiple Arcade Machine Emulator
[Try MAME in Browser!](http://fos.textfiles.com/dfjustin/pacman/pacman/)  
![mame-screenshot](https://raw.githubusercontent.com/mamedev/www.mamedev.org/d8d716dbb63919a11964b5d47b9b7f6cfa006b56/bgfx/Raiden.png)

## Blackshift

https://blackshift.itch.io/blackshift - Blackshift is a grid-based, space-themed
action puzzle game which isn't afraid of complexity — think Chip's Challenge on
crack.

<a href="http://www.youtube.com/watch?feature=player_embedded&v=PUl8612Y-ds" 
target="_blank"><img src="http://img.youtube.com/vi/PUl8612Y-ds/0.jpg" 
alt="Blackshift Trailer, May 2016"
width="640" height="480" border="0" /></a>

## Real-Time Polygonal-Light Shading with Linearly Transformed Cosines

https://eheitzresearch.wordpress.com/415-2/ - Real-Time Polygonal-Light Shading
with Linearly Transformed Cosines, Eric Heitz, Jonathan Dupuy, Stephen Hill and
David Neubelt, ACM SIGGRAPH 2016

<a href="http://www.youtube.com/watch?feature=player_embedded&v=ZLRgEN7AQgM" 
target="_blank"><img src="http://img.youtube.com/vi/ZLRgEN7AQgM/0.jpg" 
alt="Real-Time Polygonal-Light Shading with Linearly Transformed Cosines"
width="640" height="480" border="0" /></a>

## Dead Venture

http://www.dogbytegames.com/dead_venture.html - Dead Venture is a new Drive 'N
Gun game where you help a handful of survivals reach the safe haven: a military
base on a far island.

<a href="http://www.youtube.com/watch?feature=player_embedded&v=CgMr1g12yXw" 
target="_blank"><img src="http://img.youtube.com/vi/CgMr1g12yXw/0.jpg" 
alt="Dead Venture - Gameplay Teaser (iOS / Android)"
width="640" height="480" border="0" /></a>

## REGoth

https://github.com/degenerated1123/REGoth - Open source reimplementation of the
zEngine, used by the game "Gothic" and "Gothic II".

Browser demo: http://gothic-dx11.de/gothic-js/REGoth.html

<a href="http://www.youtube.com/watch?feature=player_embedded&v=8bLAGttYYpY
" target="_blank"><img src="http://img.youtube.com/vi/8bLAGttYYpY/0.jpg" 
alt="REGoth Engine"
width="640" height="480" border="0" /></a>

## Ethereal Engine

https://github.com/volcoma/EtherealEngine EtherealEngine C++ Game Engine and
WYSIWYG Editor  
![EtherealEngine screenshot](https://user-images.githubusercontent.com/1499411/29488403-ff3c3df6-8512-11e7-869f-32a783530cc3.png)

## Go Rally

http://gorallygame.com/ - Go Rally is top-down rally game with a career mode,
multiplayer time challenges, and a track creator.

<a href="http://www.youtube.com/watch?feature=player_embedded&v=ckbkQsB6RVY" 
target="_blank"><img src="http://img.youtube.com/vi/ckbkQsB6RVY/0.jpg" 
alt="Go Rally"
width="640" height="480" border="0" /></a>

## Fiber2D

https://github.com/s1ddok/Fiber2D#fiber2d - Fiber2D - Cross-platform 2D Game
Engine in pure Swift  
![Fiber2D Demo Gif](http://imgur.com/CP6d9kT.gif)

## On the Hunt / Lumix Engine

http://www.indiedb.com/games/on-the-hunt - On the Hunt is an open world hunting
game in development. It's a combination of FPS and stealth.

<a href="http://www.youtube.com/watch?feature=player_embedded&v=cAsqLbqSDBg" 
target="_blank"><img src="http://img.youtube.com/vi/cAsqLbqSDBg/0.jpg" 
alt="Lumix Engine - new features v0.29 & v0.30"
width="640" height="480" border="0" /></a>

## vg-renderer

https://github.com/jdryg/vg-renderer#vg-renderer - A vector graphics renderer
for bgfx, based on ideas from both NanoVG and ImDrawList (Dear ImGUI)  
![vg-renderer](https://raw.githubusercontent.com/jdryg/vg-renderer/master/img/vgrenderer_tiger.png)

## Zombie Safari

http://www.dogbytegames.com/zombie_safari.html - Do what you please in this
Open-World Offroad Driving game: explore massive landscapes, complete challenges,
smash zombies, find secret locations, unlock and upgrade cars and weapons, it's
up to you!

<a href="http://www.youtube.com/watch?feature=player_embedded&v=LSiH0lRkw8g" 
target="_blank"><img src="http://img.youtube.com/vi/LSiH0lRkw8g/0.jpg" 
alt="Zombie Safari - Official Gameplay Trailer (Android)"
width="640" height="480" border="0" /></a>

## Smith and Winston

http://www.smithandwinston.com/ - Smith and Winston is an exploration twin stick
shooter for PC, PS4 & XBoxOne arriving in late 2018. Smith and Winston features
a massively destructable voxel world, rapid twin stick combat, physics puzzles
and Metroid style discovery.

<a href="http://www.youtube.com/watch?feature=player_embedded&v=Mr_L7KuiByU" 
target="_blank"><img src="http://img.youtube.com/vi/Mr_L7KuiByU/0.jpg" 
alt="Smith and Winston: Gameplay Video"
width="640" height="480" border="0" /></a>

## Football Manager 2018

http://www.footballmanager.com/ - Football Manager 2018 is a 2017 football
management simulation video game developed by Sports Interactive and published
by Sega.

<a href="http://www.youtube.com/watch?feature=player_embedded&v=1Woak1Bl_KI" 
target="_blank"><img src="http://img.youtube.com/vi/1Woak1Bl_KI/0.jpg" 
alt="Match Engine | Football Manager 2018"
width="640" height="480" border="0" /></a>

## WonderWorlds

http://wonderworlds.me/ - WonderWorlds is a place to play thousands
of user-created levels and stories, make your own using the extensive in-game
tools and share them with whomever you want.

<a href="http://www.youtube.com/watch?feature=player_embedded&v=nY8y_dFolKo" 
target="_blank"><img src="http://img.youtube.com/vi/nY8y_dFolKo/0.jpg" 
alt="WonderWorlds"
width="640" height="480" border="0" /></a>

## mud

https://hugoam.github.io/mud-io/ - an all-purpose c++ app prototyping library,
focused towards live graphical apps and games.

![mud](https://raw.githubusercontent.com/hugoam/mud-io/master/media/14_live_gfx.png)

## Talking Tom Pool

https://outfit7.com/apps/talking-tom-pool/ - "Sling and match” puzzle game for
mobile devices.

<a href="http://www.youtube.com/watch?feature=player_embedded&v=eNSI45zDEo0" 
target="_blank"><img src="http://img.youtube.com/vi/eNSI45zDEo0/0.jpg" 
alt="Talking Tom Pool"
width="640" height="480" border="0" /></a>

## GPlayEngine

https://github.com/fredakilla/GPlayEngine#gplayengine - GPlayEngine is C++ 
cross-platform game engine for creating 2D/3D games based on the GamePlay 3D 
engine v3.0.

![](https://camo.githubusercontent.com/d89a364fb306f208ca14a58267c8303f60f0f0cf/68747470733a2f2f692e696d6775722e636f6d2f306569395932382e706e67)

## Off The Road

http://www.dogbytegames.com/off_the_road.html - Sandbox off-road driving
simulator.

<a href="http://www.youtube.com/watch?feature=player_embedded&v=IUmxqAWdXvk" 
target="_blank"><img src="http://img.youtube.com/vi/IUmxqAWdXvk/0.jpg" 
alt="Off The Road"
width="640" height="480" border="0" /></a>

## Coal Burnout

https://beardsvibe.com/ - Multiplayer PVP rhythm game.

![coal-burnout](https://beardsvibe.com/scr/0l.png)

## Project Aero

https://www.adobe.com/products/projectaero.html - Project Aero, a powerful new
augmented reality (AR) authoring tool that makes it easier for designers to
create immersive content.

![project-aero](https://www.adobe.com/content/dam/acom/en/products/aero/pod2.jpg/_jcr_content/renditions/cq5dam.mobile_640.640.462.jpg)

[License (BSD 2-clause)](https://bkaradzic.github.io/bgfx/license.html)
-----------------------------------------------------------------------

<a href="http://opensource.org/licenses/BSD-2-Clause" target="_blank">
<img align="right" src="http://opensource.org/trademarks/opensource/OSI-Approved-License-100x137.png">
</a>

	Copyright 2010-2018 Branimir Karadzic. All rights reserved.
	
	https://github.com/bkaradzic/bgfx
	
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions are met:
	
	   1. Redistributions of source code must retain the above copyright notice,
	      this list of conditions and the following disclaimer.
	
	   2. Redistributions in binary form must reproduce the above copyright
	      notice, this list of conditions and the following disclaimer in the
	      documentation and/or other materials provided with the distribution.
	
	THIS SOFTWARE IS PROVIDED BY COPYRIGHT HOLDER ``AS IS'' AND ANY EXPRESS OR
	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
	EVENT SHALL COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
