# - Find Xerces-C
# Find the Xerces-C includes and library
#
#  XERCESC_INCLUDE_DIR - Where to find xercesc include sub-directory.
#  XERCESC_LIBRARIES   - List of libraries when using Xerces-C.
#  XERCESC_FOUND       - True if Xerces-C found.


#IF (XERCESC_INCLUDE_DIR)
# Already in cache, be silent.
#SET(XERCESC_FIND_QUIETLY TRUE)
#ENDIF (XERCESC_INCLUDE_DIR)

#FIND_PATH(XERCESC_INCLUDE_DIR xercesc
#	PATH_SUFFIXES DOM/dom.hpp)

#SET(XERCESC_NAMES xerces-c2_8_0 xerces-c xerces-c_3 xerces-c_2 Xerces)
#FIND_LIBRARY(XERCESC_LIBRARY NAMES ${XERCESC_NAMES} )

# Handle the QUIETLY and REQUIRED arguments and set XERCESC_FOUND to
# TRUE if all listed variables are TRUE.
#INCLUDE(FindPackageHandleStandardArgs)
#FIND_PACKAGE_HANDLE_STANDARD_ARGS(XercesC DEFAULT_MSG XERCESC_LIBRARY XERCESC_INCLUDE_DIR)

#IF(XERCESC_FOUND)
#	SET( XERCESC_LIBRARIES ${XERCESC_LIBRARY} )
#ELSE(XERCESC_FOUND)
#	SET( XERCESC_LIBRARIES )
#ENDIF(XERCESC_FOUND)

#MARK_AS_ADVANCED( XERCESC_LIBRARY XERCESC_INCLUDE_DIR )

########################### NEW CODE BELOW

# - Try to find Xerces-C
# Once done this will define
#
#  XERCESC_FOUND - system has Xerces-C
#  XERCESC_INCLUDE - the Xerces-C include directory
#  XERCESC_LIBRARY - Link these to use Xerces-C
#  XERCESC_VERSION - Xerces-C found version

IF (XERCESC_INCLUDE AND XERCESC_LIBRARY)
	# in cache already
	SET(XERCESC_FIND_QUIETLY TRUE)
        #MESSAGE(STATUS "Found cached Xerces-C lib [${XERCESC_LIBRARY}]")
ENDIF (XERCESC_INCLUDE AND XERCESC_LIBRARY)

IF (NOT  ${XERCESC_WAS_STATIC} STREQUAL ${STATIC_XercesC})
	UNSET(XERCESC_LIBRARY CACHE)
	UNSET(XERCESC_LIBRARY_DEBUG CACHE)
ENDIF (NOT  ${XERCESC_WAS_STATIC} STREQUAL ${STATIC_XercesC})

SET(XERCESC_WAS_STATIC ${STATIC_XercesC} CACHE INTERNAL "" )

IF (XERCESC_INCLUDE_DIR)
    SET(XERCESC_INCLUDE ${XERCESC_INCLUDE_DIR})
ENDIF()

IF (NOT XERCESC_INCLUDE)
	FIND_PATH(XERCESC_INCLUDE NAMES xercesc/util/XercesVersion.hpp
	PATHS 
	$ENV{XERCESC_INCLUDE_DIR}
	${XERCESC_INCLUDE_DIR}
	 /usr/local/include
	 /usr/include
	)
ENDIF()

#MESSAGE(STATUS "Current Xerces-C lib [${XERCESC_LIBRARY}] XERCESC_INCLUDE [${XERCESC_INCLUDE}")

IF (STATIC_XercesC AND NOT XERCESC_LIBRARY)
        MESSAGE(STATUS "Looking for static Xerces-C lib...")
	FIND_LIBRARY(XERCESC_LIBRARY NAMES xerces-c_static_3 libxerces-c.a libxerces-c_3.a libxerces-c2_8_0.a libxerces-c_2.a libXerces.a
	 PATHS
	 $ENV{XERCESC_LIBRARY_DIR}
	 ${XERCESC_LIBRARY_DIR}
	 /usr/lib
	 /usr/local/lib
	)

	IF (XERCESC_INCLUDE AND XERCESC_LIBRARY)
                MESSAGE(STATUS "Found static Xerces-C lib [${XERCESC_LIBRARY}]")
		ADD_DEFINITIONS( -DXERCES_STATIC_LIBRARY )

		IF(UNIX AND NOT APPLE)
			#SET(XERCESC_LIBRARY "-Bstatic ${XERCESC_LIBRARY} -Bdynamic -licuuc -licudata")
			SET(XERCESC_LIBRARY "-Bstatic ${XERCESC_LIBRARY}")
		ENDIF()
	ENDIF()
ENDIF()

IF (NOT XERCESC_LIBRARY)
        MESSAGE(STATUS "Looking for dynamic Xerces-C lib...")
	FIND_LIBRARY(XERCESC_LIBRARY NAMES xerces-c_3 xerces-c xerces-c_3 xerces-c2_8_0 xerces-c_2 Xerces libxerces-c.dll libxerces-c_3.dll libxerces-c2_8_0.dll libxerces-c_2.dll libXerces.dll
	 PATHS
	 $ENV{XERCESC_LIBRARY_DIR}
	 ${XERCESC_LIBRARY_DIR}
	)
	FIND_LIBRARY(XERCESC_LIBRARY_DEBUG NAMES xerces-c_3D
	 PATHS
	 $ENV{XERCESC_LIBRARY_DIR}
	 ${XERCESC_LIBRARY_DIR}
	)
	MARK_AS_ADVANCED(XERCESC_LIBRARY_DEBUG)

	IF (XERCESC_INCLUDE AND XERCESC_LIBRARY)
                MESSAGE(STATUS "Found dynamic Xerces-C lib [${XERCESC_LIBRARY}]")
	ENDIF()
ENDIF()

IF (XERCESC_INCLUDE AND XERCESC_LIBRARY)
	SET(XERCESC_FOUND TRUE)
ELSE (XERCESC_INCLUDE AND XERCESC_LIBRARY)
	SET(XERCESC_FOUND FALSE)
ENDIF (XERCESC_INCLUDE AND XERCESC_LIBRARY)

IF(XERCESC_FOUND)
	FIND_PATH(XERCESC_XVERHPPPATH NAMES XercesVersion.hpp PATHS
	 ${XERCESC_INCLUDE}
	 PATH_SUFFIXES xercesc/util)

	MARK_AS_ADVANCED(XERCESC_XVERHPPPATH)

	IF ( ${XERCESC_XVERHPPPATH} STREQUAL XERCESC_XVERHPPPATH-NOTFOUND )
		 SET(XERCES_VERSION "0")
	ELSE( ${XERCESC_XVERHPPPATH} STREQUAL XERCESC_XVERHPPPATH-NOTFOUND )
		 FILE(READ ${XERCESC_XVERHPPPATH}/XercesVersion.hpp XVERHPP)

		 STRING(REGEX MATCHALL "\n *#define XERCES_VERSION_MAJOR +[0-9]+" XVERMAJ
		   ${XVERHPP})
		 STRING(REGEX MATCH "\n *#define XERCES_VERSION_MINOR +[0-9]+" XVERMIN
		   ${XVERHPP})
		 STRING(REGEX MATCH "\n *#define XERCES_VERSION_REVISION +[0-9]+" XVERREV
		   ${XVERHPP})

		 STRING(REGEX REPLACE "\n *#define XERCES_VERSION_MAJOR +" ""
		   XVERMAJ ${XVERMAJ})
		 STRING(REGEX REPLACE "\n *#define XERCES_VERSION_MINOR +" ""
		   XVERMIN ${XVERMIN})
		 STRING(REGEX REPLACE "\n *#define XERCES_VERSION_REVISION +" ""
		   XVERREV ${XVERREV})

		 SET(XERCESC_VERSION ${XVERMAJ}.${XVERMIN}.${XVERREV})

	ENDIF ( ${XERCESC_XVERHPPPATH} STREQUAL XERCESC_XVERHPPPATH-NOTFOUND )

	IF(NOT XERCESC_FIND_QUIETLY)
	  	MESSAGE(STATUS "Found Xerces-C: ${XERCESC_LIBRARY}")
		MESSAGE(STATUS "              : ${XERCESC_INCLUDE}")
		MESSAGE(STATUS "       Version: ${XERCESC_VERSION}")
	ENDIF(NOT XERCESC_FIND_QUIETLY)
ELSE(XERCESC_FOUND)
	MESSAGE(FATAL_ERROR "Could not find Xerces-C !")
ENDIF(XERCESC_FOUND)

MARK_AS_ADVANCED(XERCESC_INCLUDE XERCESC_LIBRARY)

