/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQObstatScatterToolBase_H
#define MvQObstatScatterToolBase_H

#include <QComboBox>
#include <QMainWindow>
#include <QStandardItemModel>

#include "MvQMainWindow.h"
#include "MvQMenuItem.h"
#include "MvQObstatScatterData.h"

class QColor;
class QGroupBox;
class QLabel;
class QListWidget;
class QListWidgetItem;
class QPushButton;
class QSortFilterProxyModel;
class QSplitter;
class QStackedWidget;
class QTextBrowser;
class QTreeView;
class QTreeWidget;
class QTreeWidgetItem;
class QVBoxLayout;

class MvKeyProfile;

class MvQFileInfoLabel;
class MvQKeyManager;
class MvQKeyProfileModel;
class MvQPlotWidget;
class MvQTreeView;

class MvQObstatScatterToolBase : public QObject
{
    Q_OBJECT

public:
    	MvQObstatScatterToolBase(QWidget *parent = 0);
    	~MvQObstatScatterToolBase();
    	void init(MvQObstatScatterData*);

	MvQFileInfoLabel* fileInfoLabel() {return fileInfoLabel_;}
	//QGroupBox*  messageBox() {return messageBox_;}
	//QGroupBox* dumpBox() {return dumpBox_;}
	QSplitter* messageSplitter() {return blockSplitter_;}
	QWidget* messagePanel() {return messagePanel_;}
	QWidget* plotPanel() {return plotPanel_;}
	
	void updateFileInfoLabel();
	const MvQMainWindow::MenuItemMap& menuItems () {return menuItems_;}

public slots:
	void slotSelectBlock(QModelIndex);
	void slotSelectMessage(QModelIndex);
	void slotManageKeyProfiles();
	//void slotLoadKeyProfile(int);
	void slotUpdateKeyProfiles();
	void slotMessageTreeContextMenu(const QPoint &);
	void slotMessageTreeColumnMoved(int,int,int);
	void slotDropToMessageTree(QString);
	//void updateLogOutput();
	void slotSwapAxes(bool);
	
signals:
	void keyProfileLoaded(MvKeyProfile*);
	void logOutputChanged();
	void messageSelected(int);
	void blockSelected(int);	
	
private:
	void setupViewActions();
	void setupSettingsActions();
	void setupMessageBox();
	void setupPlotBox();
 
	void loadKeyProfile(MvKeyProfile *);

	void renameMessageTreeHeader(int,QString);
	void deleteMessageTreeColumn(int);

	void loadItems(int);
	void createPlot();
	
	MvQObstatScatterData *data_;
 	int currentBlockNo_;
	int currentItemNo_;

	MvQMainWindow::MenuItemMap menuItems_;

	MvQFileInfoLabel*  fileInfoLabel_;

	QGroupBox*   messageBox_;
	QGroupBox*   dumpBox_;
	QWidget*     plotPanel_;
	QWidget*     messagePanel_;

	QStackedWidget* dumpStacked_;

	QComboBox*   keyCombo_;
	QComboBox*   dumpCombo_;

	QSplitter*    blockSplitter_; 	
	MvQTreeView*   messageTree_;

	
	MvQTreeView*   stdDumpTree_;
	MvQTreeView*    wmoDumpTree_;
	QTextBrowser*  stdDumpBrowser_;
	QTextBrowser*  wmoDumpBrowser_;

	//QLabel* summaryTreeLabel_;

	MvQKeyProfileModel* messageModel_;
	QSortFilterProxyModel* messageSortModel_;

	MvQTreeView*   blockTree_;
	MvQKeyProfileModel* blockModel_;
	QSortFilterProxyModel* blockSortModel_;


	QLabel *plotWidget_;

	QPushButton* swapPb_;
	bool swapAxes_;

	QString magmlScript_;

};

#endif
