/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

/*
 ** Generated by X-Designer 
 */
/*
 **LIBS: -lXm -lXt -lX11
 */

#include "inc_iostream.h"

#include "mars.h"
#include <math.h>
#include <float.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>

#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/ToggleB.h>
#include <Xm/Text.h>
#include <Xm/PushB.h>
#include <Xm/Protocols.h>

#include "Drag.h"
#include "MvVisTool.h"
#include "MvXApplication.h"

#include "MvObs.h"
#include "MvMatrix.h"
#include "MvGeoPoints.h"

enum {CURSOR_BUSY,CURSOR_OK};
enum {DECODE_ALL= 1, DECODE_GRIB, DECODE_BUFR };

static int decode_choice = DECODE_ALL;
static int expand_bitmaps = 0;

extern "C" {
  XtAppContext app_context;
  Display *display;
  extern Widget top,out_txt,info_label_1,bufr_toggle;
  void create_top ( Display*, char*, int, char** );
  void close_callback(Widget,XtPointer,XtPointer);
  void empty_txt_callback(Widget,XtPointer,XtPointer);
  void decode_choice_cb(Widget,XtPointer,XtPointer);
  void expand_bitmaps_cb(Widget,XtPointer,XtPointer);

#include <xec.h>
}

void select_input(Widget,Boolean);
void set_cursor(int);

// In order for ordinary motif callbacks to access
// this class, it contains a static pointer to 
// itself. Probably not the best way to do it,
// but the XDesigner generated code is kept as it
// was.
class GribTool : public MvVisTool {
  virtual void windowClosed();
  virtual void windowChanged();
  virtual void info(MvRequest&);
  virtual void startUp(MvRequest&);
  void add_wm_quit();
  void print_msg(Widget,char *);
  double get_field_val(MvRequest &);
  bool getMatrixNN(MvRequest &r, MvMatrix& mat);
  int get_closest(const char *,MvLocation &);

  static GribTool *self;
  int txt_pos;
  MvObs myObs;
  double lat,lon;
  FILE *fp_;             // file containing the point values

public:
  GribTool();
      virtual ~GribTool();
  static GribTool *get_this() { return self; }
};

GribTool *GribTool::self = NULL;

// Constructor. Keeps a static copy of the this pointer
// in order for callbacks to call member functions.
GribTool::GribTool() : lat(kFortranBufrMissingValue),lon(kFortranBufrMissingValue)
{
  self = this;
  add_wm_quit();

  // If METVIEW_EXAMINE_FILE is defined then create the output file
  fp_ = 0;
  char* s1 = getenv("METVIEW_EXAMINE_FILE");
  if ( s1 && strlen(s1) > 0)
  {
	string path(s1);
	fp_ = fopen(path.c_str(),"w");
	if ( !fp_ )
	{
	      string str = "ERROR -> Can not open output file: " + path + "\n\n";
	      print_msg(out_txt,(char*)str.c_str());
	}
	else
	{
	      string str = "Output file will be created at " + path + "\n\n";
	      print_msg(out_txt,(char*)str.c_str());
	}
  }
}

GribTool::~GribTool()
{
  if ( fp_ )
	fclose(fp_);
}

void GribTool::windowChanged()
{
  // Rais window ...
  if(XtIsRealized(top))
    XMapRaised(XtDisplay(top),XtWindow(top));
}

static Cached IMAGE = "IMAGE";
static Cached GRIB  = "GRIB";
static Cached BUFR  = "BUFR";
static Cached INPUT = "INPUT";
static Cached GEOPOINTS  = "GEOPOINTS";
static Cached VECTOR_FIELD  = "VECTOR_FIELD";

void GribTool::info(MvRequest&r )
{
  ostrstream oss_pos,oss_bufr,oss_grib;

  int nr_bufr = 0,nr_grib = 0;
  
  char* mytext = NULL,*mypos = NULL;

  MvRequest tmpreq;

//cout << "\nENTERING GribTool::info..." << endl;
//r.print();

  lat = kFortranBufrMissingValue;
  lon = kFortranBufrMissingValue;

  set_cursor(CURSOR_BUSY);
  txt_pos =  XmTextGetLastPosition (out_txt);

  while(r)
    {
      const char *v = r.getVerb();
      if(v == INPUT)
	{
	  lat = r("LATITUDE");
	  lon = r("LONGITUDE");

	  int a = int(fabs(lat)*10.0);
	  int b = int(fabs(lon)*10.0);
	  oss_pos << "====================== ";
	  oss_pos << "Position " <<  (a/10) << "." << (a%10) << (lat>=0?'N':'S');
	  oss_pos << " " << (b/10) << "." << (b%10) << (lon>=0?'E':'W');
	  oss_pos << " ======================\n" << ends;
	  mypos = oss_pos.str();
	}
      else if( v == GRIB || v == BUFR || v == GEOPOINTS || v == VECTOR_FIELD || v == IMAGE )
	{
	  const char *name = r("_NAME");
	  if(!name) name = "???";

	  if ( lat == kFortranBufrMissingValue || lon == kFortranBufrMissingValue )
	    {
	      oss_bufr << "----  " << name << "  ----" << endl;
	      oss_bufr << "No latitude/longitude given" << endl;
	      nr_bufr++;
	      break; 
	    }

	  r("LENGTH") = 0; // Just testing

	  if( v == GRIB )
	    {
              if ( decode_choice == DECODE_ALL || decode_choice == DECODE_GRIB )
		{
		  oss_grib  << "----  " << name << "  ----" << endl;

		  double val =  get_field_val(r);
		  if ( val == DBL_MAX ) 
		    {
		      oss_grib << 
			"Missing value or interpolation " <<
			  "for this grid type not supported" << endl;
		    }
		  else
		    oss_grib << val << endl;

		  nr_grib++;
		}
	    }
	  else if( v == IMAGE )
	    {
              if ( decode_choice == DECODE_ALL || decode_choice == DECODE_GRIB )
	      {
		  oss_grib  << "----  " << name << "  ----" << endl;

		  int MLIN=5, MCOL=5;
		  MvMatrix mat(MLIN,MCOL);
		  if ( !getMatrixNN(r,mat) )
		      oss_grib << "Error retrieving image values" << endl;
		  else
		  {
		      int i,j;
		      for ( i = 0; i < MLIN; i++ )
		      {
			      for ( j = 0; j < MCOL; j++ )
			      {
				      oss_grib << setw(4) << mat.Mget(i,j);
			      }
			      oss_grib << endl;
		      }
		  }
		  nr_grib++;
	      }
	    }
	  else if( v == VECTOR_FIELD )
	    {
              if ( decode_choice == DECODE_ALL || decode_choice == DECODE_GRIB )
		{

		  MvRequest rsub = r.getSubrequest("U_COMPONENT");
		  double uval =  get_field_val(rsub);

		  name = rsub("_NAME");
		  oss_grib  << "----  " << name << "  ----" << endl;

		  rsub = r.getSubrequest("V_COMPONENT");
		  double vval =  get_field_val(rsub);

		  if ( uval != DBL_MAX && vval != DBL_MAX )
		    { 
		      oss_grib << "u: " << uval << endl;
		      oss_grib << "v: " << vval << endl;
		    }
		  else
		      oss_grib << "Missing wind component(s) or interpolation "
		               << "for this grid type not supported"
			       << endl;

		  nr_grib++;
		}
	    }
	  else if( v == BUFR )  
	    {
	      if ( decode_choice == DECODE_ALL || decode_choice == DECODE_BUFR )
		{
		  oss_bufr << "----  " << name << "  ----" << endl;
		  const char* bufr_path = r("PATH");
		  
		  int count = 0;
		  if ( bufr_path ) 
		    {
		      MvLocation closest;
		      count = get_closest(bufr_path,closest);
		      
		      if ( count == 0 )
			oss_bufr <<  "No observation found" << endl;
		      else
			{
			  MvObsSet myBufr(bufr_path);
			  MvObsSetIterator exactBufrIter( myBufr );
			  exactBufrIter.setArea(closest,closest);
			  
			  count = 0;
			  while ( myObs =exactBufrIter()  )
			    {
			      oss_bufr << "Message nr : " <<  ++count << endl;
			      if ( expand_bitmaps ) 
				myObs.writeBufrBox( oss_bufr );
			      else 
				myObs.writeAllValues( oss_bufr );

			    }
			  myBufr.close();
			}
		    }
		  else
		    {
		      oss_bufr <<  "BUFR decoding could not be done." << endl;
		    }
		  nr_bufr++;
		}
	    }
	  else if( v == GEOPOINTS )
	    {
	      if ( decode_choice == DECODE_ALL || decode_choice == DECODE_BUFR )
		{
		  const char* geop_path = r("PATH");
		  if( geop_path )
		    {
		      MvGeoPoints geop( geop_path );
		      if( geop.count() > 0 )
			{
			  MvGeoP1 geop_nearest = geop.nearestPoint( lat, lon );
			  oss_bufr << "Nearest geopoint:\n" << geop_nearest << endl;
			  ++nr_bufr;
			}
		    }
		}
	    } 
	}
      r.advance();
    }

  if ( !mypos )   // No pos, info called for zoom or similar.
    { 
      set_cursor(CURSOR_OK); 
      XmUpdateDisplay(top);
      return;
    }
  print_msg(out_txt,mypos);
  delete [] mypos;
  if ( nr_bufr > 0 ) 
    {
      oss_bufr << ends;
      mytext = oss_bufr.str();
      print_msg(out_txt,mytext);
      delete [] mytext;
    }
  if ( nr_grib > 0 ) 
    {
      oss_grib << ends;
      mytext = oss_grib.str();
      print_msg(out_txt,mytext);
      delete [] mytext;
    }

  set_cursor(CURSOR_OK);
}

void GribTool::startUp(MvRequest& r)
{
//  cout << "In startup" << endl;
  const char *p = r("TITLE");
  xec_SetLabel(info_label_1,p?p:"-");
  txt_pos =  XmTextGetLastPosition (out_txt);
}

void GribTool::windowClosed()
{
  exit(0);
}

// Function that prints messages to a common text widget. It
// takes a widget and a string as arguments
void GribTool::print_msg(Widget out_txt,char *str )
{
  XmTextInsert(out_txt,txt_pos,str);
  txt_pos += strlen(str);
  XmTextShowPosition(out_txt,txt_pos);

  if ( fp_ )
	fprintf(fp_,"%s",str);
}

double GribTool::get_field_val(MvRequest &r)
{
   MvFieldSet fs(r);
   MvField f = fs[0];
   return f.interpolateAt(lon,lat);
}

bool GribTool::getMatrixNN(MvRequest &r, MvMatrix& mat)
{
   MvFieldSet fs(r);
   MvField f = fs[0];

   return f.getMatrixNN(lon,lat,mat);
}
int GribTool::get_closest(const char *bufr_path,MvLocation &closest )
{
  MvObsSet         myBufr( bufr_path );
  MvObsSetIterator myBufrIter( myBufr );
  myBufrIter.setArea( MvLocation( lat - 10.0, lon - 10.0 ),
		     MvLocation( lat + 10.0, lon + 10.0 ) );
  
  int count = 0;
  MvLocation exact(lat,lon);
  float closest_dist;
  while ( myObs = myBufrIter()  )
    {
      if ( count == 0 ) 
	{
	  closest = myObs.location();
	  closest_dist = exact.distanceInDegrees(closest);
	}
      else
	{
	  
	  if ( exact.distanceInDegrees(myObs.location()) < closest_dist )
	    {
	      closest =  myObs.location();
	      closest_dist = exact.distanceInDegrees(closest);
	    }
	}
      count++;
    }
  myBufr.close();
  return count;
}
// Close callback needs to tell VisMod to clean up after 
// the gribtool with this id, or gribtool will be "called"
// twice if restarted.
// Destructor is called explicitly because the
// function disconnect() is private in the MvVisTool
// class. The destructor is public, and will call
// disconnect.
void close_callback(Widget,XtPointer,XtPointer)
{ 
  GribTool::get_this()->~GribTool();
  exit(0);
}

void empty_txt_callback(Widget,XtPointer,XtPointer)
{
  XmTextSetString(out_txt,"");
  
}

// Set variable deciding what to decode. Called from
// option menu.
void decode_choice_cb(Widget,XtPointer cl_data,XtPointer)
{
  decode_choice = (long) cl_data; //-- 'hpcd' C++ fails with 'int' cast
  if ( decode_choice == DECODE_GRIB ) 
    XtSetSensitive (bufr_toggle, FALSE);
  else
    XtSetSensitive (bufr_toggle, TRUE);
}
void expand_bitmaps_cb(Widget,XtPointer,XtPointer call_data)
{
  XmToggleButtonCallbackStruct *xx = (XmToggleButtonCallbackStruct*)call_data;
  expand_bitmaps = xx->set;
}

//  Catch quit messages from window manager menu 
void GribTool::add_wm_quit()
{
  Atom WM_DELETE_WINDOW = XmInternAtom(XtDisplay(top),
				       "WM_DELETE_WINDOW",
				       False);
  
  XmAddWMProtocolCallback(top,WM_DELETE_WINDOW,
			  close_callback,(XtPointer)NULL);
}

///////////// Functions to set cursor busy and disable input.
void set_cursor(int status)
{
  static Display   *display = NULL;
  static Window    win;
  static Cursor cursor;
  static Widget xx_top = top;

  while ( !XtIsShell(xx_top)) xx_top = XtParent(xx_top);
  display = XtDisplay (xx_top);
  win  = XtWindow(xx_top);  
  cursor  = XCreateFontCursor (display, XC_watch);
  
  if ( status == CURSOR_BUSY)
    {
      /* Set X stuff to busy/insensitive */
      XDefineCursor (display, win, cursor);
      XtSetSensitive(xx_top,False); 
      select_input(xx_top,False);
      XmUpdateDisplay(xx_top);
    }
  else 
    {
      /* Reset X stuff  */
      XUndefineCursor (display, win);
      //XSync(display,True);
      select_input(xx_top,True);
      XtSetSensitive(xx_top,True);
      XmUpdateDisplay(xx_top);
    }
}

void select_input(Widget w,Boolean choice)
{
  WidgetList wl;
  Cardinal num;

  if ( XtIsComposite(w))
    {
      XtVaGetValues(w,
            XtNnumChildren,&num,
            XtNchildren, &wl,
            NULL);
 
      for ( int i = 0; i < (int)num;i++)
	if (XtWindow(wl[i]))
	  select_input(wl[i],choice);
    }

  if ( choice )
    {
      if (XtIsWidget(w))
	XSelectInput(XtDisplay(w),
             XtWindow(w),
             XtBuildEventMask(w));
    }
  else 
    if (XtIsWidget(w))
      XSelectInput(XtDisplay(w),
           XtWindow(w),
           (long)(LeaveWindowMask|Button1MotionMask|Button2MotionMask|
              Button3MotionMask|Button4MotionMask|Button5MotionMask|
              ButtonMotionMask|
              ExposureMask|VisibilityChangeMask|StructureNotifyMask|
              SubstructureNotifyMask|
              SubstructureRedirectMask|PropertyChangeMask|
              FocusChangeMask|ColormapChangeMask|OwnerGrabButtonMask));

  return;
}


static int xerror(Display *d, XErrorEvent *e)
{
  cout << "\nXlib error encountered!!!" << endl;
  cout << "   To find the originating location in the source code, i.e." << endl;
  cout << "   to get a proper call stack, run MetviewUI in a debugger" << endl;
  cout << "   with run-time flag '-synchronous' (otherwise call stack" << endl;
  cout << "   will not correspond to the originating error location).\n" << endl;

  char buf[1024];
  XGetErrorText(d,e->error_code,buf,sizeof(buf));
  cout << "xerror: " << buf << "\n" << endl;

  abort();
  return 0;    //-- we could use this for non-fatal errors...
}


int main (int argc,char **argv)
{

  XtToolkitInitialize ();
  app_context = XtCreateApplicationContext ();
  display = XtOpenDisplay (app_context, NULL, argv[0], "Metview",
			   NULL, 0, &argc, argv);
  if (!display)
    {
      printf("%s: can't open display, exiting...\n", argv[0]);
      exit (-1);
    }

#if (XmVersion < 2000)
  /* Register converters, just in case you are really unlucky !! */
  XmRegisterConverters();
#endif

  /* String to unit type doesn't get added !! */
  XtAddConverter ( XmRString, XmRUnitType, XmCvtStringToUnitType, NULL, 0 );
  create_top ( display, argv[0], argc, argv );
  XtRealizeWidget (top);

  XSetErrorHandler(xerror);

  // Create an MvApplication

  MvXApplication app(app_context,argc,argv);
  GribTool      tool;
  app.run();
}
