#ifndef Transfm_H
#define Transfm_H

#include <X11/Xlib.h>
#include <Point.hpp>
class Box;

class Transfm
{
	float _H11, _H12, _H21, _H22, _H31, _H32; // accumulative transform. param.
	float _G11, _G12, _G21, _G22, _G31, _G32; // inverse transform matrix

public:

	Transfm() { 	_H11 = _H22 = 1.; _H12 = _H21 = _H31 = _H32 = 0.;
			_G11 = _G22 = 1.; _G12 = _G21 = _G31 = _G32 = 0.;}
//		Normal constructor. Both matrix are made equal identity.

	void print(char*);

	Transfm operator= (float);

	Transfm operator= (const Transfm&);

	void rotation (float a);
//		Accumulate the rotation transformation.
//		Input :
//			a : rotation angle (radians), counterclockwise positive

	void scale (float tx, float ty);
//		Accumulate the scale transformation.
//		Input :
//			tx : translation in x
//			ty : translation in y

	void setTransf (Box& sys1, Box& sys2);
//		Set transformation from sys1 to sys2
//		Input :
//			sys1 : input coordinate system
//			sys2 : output coordinate system

	friend Transfm operator+ (const Transfm&, const Point&);
//		Translate 

	friend Transfm operator- (const Transfm&, const Point&);
//		Translate 

//<*teste*> esta parte nao esta' funcionando
//	Transfm operator+= (Point& p) { return ((*this) = ((*this)+p)); }


//	Transfm operator-= (Point& p) { return ((*this) = ((*this)-p)); }
//<*end teste*> 

	Transfm reflectInX ();
//		Accumulate a reflection (in y) around x axis.

	friend	Point operator* (const Point&, const Transfm&);

	friend	Point operator* (const XPoint&, const Transfm&);

	friend Transfm operator* (const Transfm&, const Transfm&);

};

#endif
