/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
// .NAME:
//  MapView
//
// .AUTHOR:
//  Gilberto Camara and Fernando Ii
//
// .SUMMARY:
//  Describes the MapView class, which handles the
//  matching issues related to the Map View
//
//
// .CLIENTS:
//  DropAction
//
// .RESPONSIBILITY:
//
//  - Process the drop, asking the 
//
//
// .COLLABORATORS:
//  MvRequest - extracts information from the request
//
// .DESCENDENT:
//
// .RELATED:
//  Presentable, SuperPage, Page, DataObject
//
// .ASCENDENT:
// PlotModView, PlotModService
//

#ifndef MapView_H
#define MapView_H

#include "PlotModView.h"
#include "PlotModService.h"

class MapView: public PlotModView, public PlotModService {

public:

  // Constructors
  MapView( Page&, const MvRequest&, const MvRequest& );
  MapView(const MapView&);
  virtual PlotModView *Clone() const { return new MapView(*this); }

  // Destructor
  ~MapView() {}

  // Get the object name
  virtual string Name();

//  static void SaveRequest ( const Cached& path, MvRequest& viewRequest );
  // save a request for later use

  // Methods Overriden from PlotModView class
  virtual void Drop ( PmContext& );

  // Insert a new data request into the page hierarchy;
  virtual void InsertDataRequest ( MvRequest& dropRequest );

  // Updates the current view
  virtual void UpdateView ( MvRequest& viewRequest);

  // Replaces the current geographical area
//  virtual void ReplaceArea ( const Location& coordinates, int izoom=-1 );

  // Draw the background (coastlines)
  virtual void DrawBackground ( );

  // Draw the foreground (coastlines with land-sea shade)
  virtual void DrawForeground ( );

  // Describe the contents of the view
  virtual void DescribeYourself ( ObjectInfo& );

  // Decode the data Unit
  virtual void DecodeDataUnit ( MvIcon& dataUnit);

  // Call an application
  virtual bool CallService(const MvRequest &,  PmContext &);

//  virtual Cached InputMode () { return Cached ("MAP"); }
  // Input mode is MAP

//  virtual bool CanChangeGeography() { return true; }
  // Allow to change geography coordinates

protected:

//  virtual int CheckPSymb(MvRequest&);
  // Find, and if necessary, add a psymb. Return it's id.

//  virtual void DescribeSubrequest ( ObjectInfo& description, MvRequest& request, const Cached& name, const Cached& verb);

  // Provide coastline information
  virtual void ReplaceCoastlines ( MvRequest& coastRequest );

  void ConvertToSatellite ( MvRequest& decoderRequest );

private:

  // No assignment
  MapView& operator=(const MapView&);
};

#endif
