/***************************** LICENSE START ***********************************

 Copyright 2015 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ViewEditor_H
#define ViewEditor_H

#include "Request.h"
//#include "PageView.h"

#include "MvQEditor.h"

class QComboBox;
class QLabel;
class QLineEdit;
class QToolButton;
class QSpinBox;
class QSplitter;
class QStakedWidget;
class QUndoStack;

class MvQPageItem;
class MvQPageView;

struct PaperRectangle;

class PaperSize
{
public:
    PaperSize(string n, float w, float h,string ori) : name_(n), width_(w), height_(h), orientation_(ori) {}
	string name() const {return name_;}
	double width() const {return width_;}
	double height() const {return height_;}
	void setWidth(double w) {width_=w;}
	void setHeight(double h) {height_=h;}
	string orientation() const {return orientation_;}

protected:	
	string name_;
	double width_;
	double height_;
	string orientation_;
};

class PaperSizeHandler
{
public:
	PaperSizeHandler();
	
	void set(const Request&);
	void set(const string&,const string&,double,double);
	void save(Request&);
	PaperSize* current() {return current_;}
	double width();
	double height();
	bool isCustom() {return current_==custom_;}
	string orientation() {return orientation_;}
	
	static const vector<PaperSize*>& stdSizes() {return std_;}
	
protected:
	string orientation_;
	
	PaperSize *current_;	
	static vector<PaperSize*> std_;
	PaperSize* custom_;
};  

class GridSnapHandler
{
public:  
	GridSnapHandler();
	void setCurrent(int,int);
	void setCurrentValues(float,float);
	float x() const;
	float y() const;
	int xIndex() const {return xIndex_;}
	int yIndex() const {return yIndex_;}
	const string& units() const {return units_;}
	const vector<float>& values() const {return vals_;}
	
	
protected:    
	vector<float> vals_;
	string units_;
	int xIndex_;
	int yIndex_; 
};  

class MvQPaperSizeWidget : public QWidget
{
Q_OBJECT
  
public:
    	MvQPaperSizeWidget(PaperSizeHandler *,QWidget *parent=0);
  	~MvQPaperSizeWidget() {};
	void accept();

public slots:
	void slotSize(int);
  
protected:
  	void updateState();
	
  	PaperSizeHandler *paper_;
  	QComboBox *sizeCb_;
	QLabel* oriLabel_;
	QComboBox* oriCb_;
  	QLabel* widthLabel_;
	QLabel *heightLabel_;
	QLineEdit *widthEdit_;
	QLineEdit *heightEdit_;
};


class MvQGridSnapWidget : public QWidget
{
public:
    	MvQGridSnapWidget(GridSnapHandler *,QWidget *parent=0);
  	~MvQGridSnapWidget() {};
	void accept();
	
protected:  	
  	GridSnapHandler *snap_;
  	QComboBox *xCb_;
	QComboBox *yCb_;
};


class MvQPageSetupDialog : public QDialog
{
Q_OBJECT

public:
     MvQPageSetupDialog(PaperSizeHandler *,GridSnapHandler*,QWidget *parent=0);
  	~MvQPageSetupDialog() {};

public slots:
  	void accept();
  
protected:	
  	MvQPaperSizeWidget *paper_;
	MvQGridSnapWidget* snap_;
};

class MvQGridSelector;

class MvQSplitDialog : public QDialog
{
Q_OBJECT
  
public:
    MvQSplitDialog(QWidget *parent=0);
  	~MvQSplitDialog() {};
	int row() const {return row_;}
	int column() const {return column_;}

public slots:
	void slotChangeMode(int);
	void slotRowChanged(int);
	void slotColumnChanged(int);
	void slotSelectionChanged(int,int);
	void accept();
	void reject();
  
protected:
    void closeEvent(QCloseEvent* event);
	void updateLabel();
	void readSettings();
	void writeSettings();

	int row_;
	int column_;
	int maxRow_;
	int maxColumn_;
	int maxGrRow_;
	int maxGrColumn_;
	QComboBox *modeCb_;
	QStackedWidget* stacked_;
	QLabel* label_;
	MvQGridSelector *selector_;
	QSpinBox* rowSpin_;
	QSpinBox* colSpin_;
};


class MvQGridSelector : public QWidget
{  
Q_OBJECT  
  
public:
    	MvQGridSelector(int,int,int,int,QWidget *parent=0);
  	~MvQGridSelector() {};
	int row() const {return row_;}
	int column() const {return column_;}
	void setGridSize(int,int);
	void setSelection(int row, int col);
	
signals:
	void changed(int,int);    
	
protected:      
    void paintEvent(QPaintEvent *event);
    void resizeEvent (QResizeEvent * event );
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
	void mouseReleaseEvent(QMouseEvent *event);
    bool select(QPoint);
  
	int row_;
	int column_;
	int rowNum_;
	int columnNum_;
	int offset_;
	float dx_;
	float dy_;
	QColor rectColour_;
	QColor frameColour_;
	QColor selectedColour_;
};


class ViewEditor : public MvQEditor
{

Q_OBJECT

public:
	ViewEditor(const IconClass&,const string&);
	virtual ~ViewEditor();
	
	void setPaperSize(double,double);
	void getPaperSize(double&,double&);	
	IconObject* defaultView();
	IconObject *makeIcon(Folder*,int, Request&);

public slots:
        void updateButtonStatus(int);
	void slotSnap(bool);
	void slotGrid(bool);
	void slotAddPage(bool);
	void slotDuplicateSelection(bool);
  	void slotDeleteSelection(bool);
	void slotJoinSelection(bool);
	void slotSplitSelection(bool);
	void slotExpandSelection(bool);
	void slotSelectAll(bool);
	void slotConnectSelection(bool);
	void slotDisconnectSelection(bool);
  	void slotSetupPage(bool);
	void slotViewChanged();

protected slots:
    void slotShowDisabled(bool) {}

protected:
 	void readSettings(QSettings&);
	void writeSettings(QSettings&);

private:
	// No copy allowed
	ViewEditor(const ViewEditor&);
	ViewEditor& operator=(const ViewEditor&);

	void loadPages(IconObject*,const Request&);
	void loadSubPages(MvQPageItem*,IconObject*,const Request&);	
	void loadPaperSize(const Request&);
	void savePaperSize(Request&);
	void savePages(IconObject*,Request&);
	void saveRectToRequest(QRectF,Request&);

	virtual void apply();
	virtual void reset();
	virtual void close();
	virtual void merge(IconObjectH);
	virtual void replace(IconObjectH);
	virtual string alternateEditor();
	
	Request request_;
	vector<IconObjectH> save_;

	//map<IconObjectH,PageViewH> cache_;
	
	QAction* snapAc_;
	QAction* gridAc_;
	PaperSizeHandler *paper_;
	GridSnapHandler *snap_;	
	QUndoStack* undoStack_;
	MvQPageView *view_;
};

inline void destroy(ViewEditor**) {}

#endif
