"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Metlakatla"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Metlakatla", { offset: true, expect: "America/Anchorage" }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Metlakatla", { abbr: true, expect: "America/Anchorage" }),

	"1900" : helpers.makeTestYear("America/Metlakatla", [
		["1900-08-20T20:46:17+00:00", "11:59:59", "LMT", 31578 / 60],
		["1900-08-20T20:46:18+00:00", "12:46:18", "PST", 480]
	]),

	"1942" : helpers.makeTestYear("America/Metlakatla", [
		["1942-02-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["1942-02-09T10:00:00+00:00", "03:00:00", "PWT", 420]
	]),

	"1945" : helpers.makeTestYear("America/Metlakatla", [
		["1945-08-14T22:59:59+00:00", "15:59:59", "PWT", 420],
		["1945-08-14T23:00:00+00:00", "16:00:00", "PPT", 420],
		["1945-09-30T08:59:59+00:00", "01:59:59", "PPT", 420],
		["1945-09-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1969" : helpers.makeTestYear("America/Metlakatla", [
		["1969-04-27T09:59:59+00:00", "01:59:59", "PST", 480],
		["1969-04-27T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1969-10-26T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1969-10-26T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1970" : helpers.makeTestYear("America/Metlakatla", [
		["1970-04-26T09:59:59+00:00", "01:59:59", "PST", 480],
		["1970-04-26T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1970-10-25T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1970-10-25T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1971" : helpers.makeTestYear("America/Metlakatla", [
		["1971-04-25T09:59:59+00:00", "01:59:59", "PST", 480],
		["1971-04-25T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1971-10-31T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1971-10-31T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1972" : helpers.makeTestYear("America/Metlakatla", [
		["1972-04-30T09:59:59+00:00", "01:59:59", "PST", 480],
		["1972-04-30T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1972-10-29T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1972-10-29T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1973" : helpers.makeTestYear("America/Metlakatla", [
		["1973-04-29T09:59:59+00:00", "01:59:59", "PST", 480],
		["1973-04-29T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1973-10-28T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1973-10-28T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1974" : helpers.makeTestYear("America/Metlakatla", [
		["1974-01-06T09:59:59+00:00", "01:59:59", "PST", 480],
		["1974-01-06T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1974-10-27T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1974-10-27T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1975" : helpers.makeTestYear("America/Metlakatla", [
		["1975-02-23T09:59:59+00:00", "01:59:59", "PST", 480],
		["1975-02-23T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1975-10-26T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1975-10-26T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1976" : helpers.makeTestYear("America/Metlakatla", [
		["1976-04-25T09:59:59+00:00", "01:59:59", "PST", 480],
		["1976-04-25T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1976-10-31T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1976-10-31T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1977" : helpers.makeTestYear("America/Metlakatla", [
		["1977-04-24T09:59:59+00:00", "01:59:59", "PST", 480],
		["1977-04-24T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1977-10-30T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1977-10-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1978" : helpers.makeTestYear("America/Metlakatla", [
		["1978-04-30T09:59:59+00:00", "01:59:59", "PST", 480],
		["1978-04-30T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1978-10-29T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1978-10-29T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1979" : helpers.makeTestYear("America/Metlakatla", [
		["1979-04-29T09:59:59+00:00", "01:59:59", "PST", 480],
		["1979-04-29T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1979-10-28T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1979-10-28T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1980" : helpers.makeTestYear("America/Metlakatla", [
		["1980-04-27T09:59:59+00:00", "01:59:59", "PST", 480],
		["1980-04-27T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1980-10-26T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1980-10-26T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1981" : helpers.makeTestYear("America/Metlakatla", [
		["1981-04-26T09:59:59+00:00", "01:59:59", "PST", 480],
		["1981-04-26T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1981-10-25T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1981-10-25T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1982" : helpers.makeTestYear("America/Metlakatla", [
		["1982-04-25T09:59:59+00:00", "01:59:59", "PST", 480],
		["1982-04-25T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1982-10-31T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1982-10-31T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1983" : helpers.makeTestYear("America/Metlakatla", [
		["1983-04-24T09:59:59+00:00", "01:59:59", "PST", 480],
		["1983-04-24T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1983-10-30T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1983-10-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2015" : helpers.makeTestYear("America/Metlakatla", [
		["2015-11-01T09:59:59+00:00", "01:59:59", "PST", 480],
		["2015-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2016" : helpers.makeTestYear("America/Metlakatla", [
		["2016-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2016-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2016-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2016-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2017" : helpers.makeTestYear("America/Metlakatla", [
		["2017-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2017-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2017-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2017-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2018" : helpers.makeTestYear("America/Metlakatla", [
		["2018-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2018-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2018-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2018-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2019" : helpers.makeTestYear("America/Metlakatla", [
		["2019-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2019-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2019-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2019-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2020" : helpers.makeTestYear("America/Metlakatla", [
		["2020-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2020-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2020-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2020-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2021" : helpers.makeTestYear("America/Metlakatla", [
		["2021-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2021-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2021-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2021-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2022" : helpers.makeTestYear("America/Metlakatla", [
		["2022-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2022-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2022-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2022-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2023" : helpers.makeTestYear("America/Metlakatla", [
		["2023-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2023-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2023-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2023-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2024" : helpers.makeTestYear("America/Metlakatla", [
		["2024-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2024-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2024-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2024-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2025" : helpers.makeTestYear("America/Metlakatla", [
		["2025-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2025-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2025-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2025-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2026" : helpers.makeTestYear("America/Metlakatla", [
		["2026-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2026-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2026-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2026-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2027" : helpers.makeTestYear("America/Metlakatla", [
		["2027-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2027-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2027-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2027-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2028" : helpers.makeTestYear("America/Metlakatla", [
		["2028-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2028-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2028-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2028-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2029" : helpers.makeTestYear("America/Metlakatla", [
		["2029-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2029-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2029-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2029-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2030" : helpers.makeTestYear("America/Metlakatla", [
		["2030-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2030-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2030-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2030-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2031" : helpers.makeTestYear("America/Metlakatla", [
		["2031-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2031-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2031-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2031-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2032" : helpers.makeTestYear("America/Metlakatla", [
		["2032-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2032-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2032-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2032-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2033" : helpers.makeTestYear("America/Metlakatla", [
		["2033-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2033-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2033-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2033-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2034" : helpers.makeTestYear("America/Metlakatla", [
		["2034-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2034-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2034-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2034-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2035" : helpers.makeTestYear("America/Metlakatla", [
		["2035-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2035-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2035-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2035-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2036" : helpers.makeTestYear("America/Metlakatla", [
		["2036-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2036-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2036-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2036-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2037" : helpers.makeTestYear("America/Metlakatla", [
		["2037-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2037-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2037-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2037-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2038" : helpers.makeTestYear("America/Metlakatla", [
		["2038-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2038-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2038-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2038-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2039" : helpers.makeTestYear("America/Metlakatla", [
		["2039-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2039-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2039-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2039-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2040" : helpers.makeTestYear("America/Metlakatla", [
		["2040-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2040-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2040-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2040-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2041" : helpers.makeTestYear("America/Metlakatla", [
		["2041-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2041-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2041-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2041-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2042" : helpers.makeTestYear("America/Metlakatla", [
		["2042-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2042-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2042-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2042-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2043" : helpers.makeTestYear("America/Metlakatla", [
		["2043-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2043-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2043-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2043-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2044" : helpers.makeTestYear("America/Metlakatla", [
		["2044-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2044-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2044-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2044-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2045" : helpers.makeTestYear("America/Metlakatla", [
		["2045-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2045-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2045-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2045-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2046" : helpers.makeTestYear("America/Metlakatla", [
		["2046-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2046-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2046-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2046-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2047" : helpers.makeTestYear("America/Metlakatla", [
		["2047-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2047-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2047-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2047-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2048" : helpers.makeTestYear("America/Metlakatla", [
		["2048-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2048-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2048-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2048-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2049" : helpers.makeTestYear("America/Metlakatla", [
		["2049-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2049-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2049-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2049-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2050" : helpers.makeTestYear("America/Metlakatla", [
		["2050-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2050-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2050-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2050-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2051" : helpers.makeTestYear("America/Metlakatla", [
		["2051-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2051-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2051-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2051-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2052" : helpers.makeTestYear("America/Metlakatla", [
		["2052-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2052-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2052-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2052-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2053" : helpers.makeTestYear("America/Metlakatla", [
		["2053-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2053-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2053-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2053-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2054" : helpers.makeTestYear("America/Metlakatla", [
		["2054-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2054-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2054-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2054-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2055" : helpers.makeTestYear("America/Metlakatla", [
		["2055-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2055-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2055-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2055-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2056" : helpers.makeTestYear("America/Metlakatla", [
		["2056-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2056-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2056-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2056-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2057" : helpers.makeTestYear("America/Metlakatla", [
		["2057-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2057-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2057-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2057-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2058" : helpers.makeTestYear("America/Metlakatla", [
		["2058-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2058-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2058-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2058-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2059" : helpers.makeTestYear("America/Metlakatla", [
		["2059-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2059-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2059-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2059-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2060" : helpers.makeTestYear("America/Metlakatla", [
		["2060-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2060-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2060-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2060-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2061" : helpers.makeTestYear("America/Metlakatla", [
		["2061-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2061-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2061-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2061-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2062" : helpers.makeTestYear("America/Metlakatla", [
		["2062-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2062-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2062-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2062-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2063" : helpers.makeTestYear("America/Metlakatla", [
		["2063-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2063-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2063-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2063-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2064" : helpers.makeTestYear("America/Metlakatla", [
		["2064-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2064-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2064-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2064-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2065" : helpers.makeTestYear("America/Metlakatla", [
		["2065-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2065-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2065-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2065-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2066" : helpers.makeTestYear("America/Metlakatla", [
		["2066-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2066-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2066-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2066-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2067" : helpers.makeTestYear("America/Metlakatla", [
		["2067-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2067-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2067-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2067-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2068" : helpers.makeTestYear("America/Metlakatla", [
		["2068-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2068-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2068-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2068-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2069" : helpers.makeTestYear("America/Metlakatla", [
		["2069-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2069-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2069-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2069-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2070" : helpers.makeTestYear("America/Metlakatla", [
		["2070-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2070-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2070-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2070-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2071" : helpers.makeTestYear("America/Metlakatla", [
		["2071-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2071-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2071-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2071-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2072" : helpers.makeTestYear("America/Metlakatla", [
		["2072-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2072-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2072-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2072-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2073" : helpers.makeTestYear("America/Metlakatla", [
		["2073-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2073-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2073-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2073-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2074" : helpers.makeTestYear("America/Metlakatla", [
		["2074-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2074-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2074-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2074-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2075" : helpers.makeTestYear("America/Metlakatla", [
		["2075-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2075-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2075-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2075-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2076" : helpers.makeTestYear("America/Metlakatla", [
		["2076-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2076-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2076-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2076-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2077" : helpers.makeTestYear("America/Metlakatla", [
		["2077-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2077-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2077-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2077-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2078" : helpers.makeTestYear("America/Metlakatla", [
		["2078-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2078-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2078-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2078-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2079" : helpers.makeTestYear("America/Metlakatla", [
		["2079-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2079-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2079-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2079-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2080" : helpers.makeTestYear("America/Metlakatla", [
		["2080-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2080-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2080-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2080-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2081" : helpers.makeTestYear("America/Metlakatla", [
		["2081-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2081-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2081-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2081-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2082" : helpers.makeTestYear("America/Metlakatla", [
		["2082-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2082-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2082-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2082-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2083" : helpers.makeTestYear("America/Metlakatla", [
		["2083-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2083-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2083-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2083-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2084" : helpers.makeTestYear("America/Metlakatla", [
		["2084-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2084-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2084-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2084-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2085" : helpers.makeTestYear("America/Metlakatla", [
		["2085-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2085-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2085-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2085-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2086" : helpers.makeTestYear("America/Metlakatla", [
		["2086-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2086-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2086-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2086-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2087" : helpers.makeTestYear("America/Metlakatla", [
		["2087-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2087-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2087-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2087-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2088" : helpers.makeTestYear("America/Metlakatla", [
		["2088-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2088-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2088-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2088-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2089" : helpers.makeTestYear("America/Metlakatla", [
		["2089-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2089-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2089-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2089-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2090" : helpers.makeTestYear("America/Metlakatla", [
		["2090-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2090-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2090-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2090-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2091" : helpers.makeTestYear("America/Metlakatla", [
		["2091-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2091-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2091-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2091-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2092" : helpers.makeTestYear("America/Metlakatla", [
		["2092-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2092-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2092-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2092-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2093" : helpers.makeTestYear("America/Metlakatla", [
		["2093-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2093-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2093-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2093-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2094" : helpers.makeTestYear("America/Metlakatla", [
		["2094-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2094-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2094-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2094-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2095" : helpers.makeTestYear("America/Metlakatla", [
		["2095-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2095-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2095-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2095-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2096" : helpers.makeTestYear("America/Metlakatla", [
		["2096-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2096-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2096-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2096-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2097" : helpers.makeTestYear("America/Metlakatla", [
		["2097-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2097-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2097-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2097-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2098" : helpers.makeTestYear("America/Metlakatla", [
		["2098-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2098-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2098-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2098-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2099" : helpers.makeTestYear("America/Metlakatla", [
		["2099-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2099-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2099-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2099-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2100" : helpers.makeTestYear("America/Metlakatla", [
		["2100-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2100-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2100-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2100-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2101" : helpers.makeTestYear("America/Metlakatla", [
		["2101-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2101-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2101-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2101-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2102" : helpers.makeTestYear("America/Metlakatla", [
		["2102-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2102-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2102-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2102-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2103" : helpers.makeTestYear("America/Metlakatla", [
		["2103-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2103-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2103-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2103-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2104" : helpers.makeTestYear("America/Metlakatla", [
		["2104-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2104-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2104-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2104-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2105" : helpers.makeTestYear("America/Metlakatla", [
		["2105-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2105-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2105-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2105-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2106" : helpers.makeTestYear("America/Metlakatla", [
		["2106-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2106-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2106-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2106-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2107" : helpers.makeTestYear("America/Metlakatla", [
		["2107-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2107-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2107-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2107-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2108" : helpers.makeTestYear("America/Metlakatla", [
		["2108-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2108-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2108-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2108-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2109" : helpers.makeTestYear("America/Metlakatla", [
		["2109-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2109-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2109-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2109-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2110" : helpers.makeTestYear("America/Metlakatla", [
		["2110-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2110-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2110-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2110-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2111" : helpers.makeTestYear("America/Metlakatla", [
		["2111-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2111-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2111-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2111-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2112" : helpers.makeTestYear("America/Metlakatla", [
		["2112-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2112-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2112-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2112-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2113" : helpers.makeTestYear("America/Metlakatla", [
		["2113-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2113-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2113-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2113-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2114" : helpers.makeTestYear("America/Metlakatla", [
		["2114-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2114-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2114-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2114-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2115" : helpers.makeTestYear("America/Metlakatla", [
		["2115-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2115-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2115-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2115-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2116" : helpers.makeTestYear("America/Metlakatla", [
		["2116-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2116-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2116-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2116-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2117" : helpers.makeTestYear("America/Metlakatla", [
		["2117-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2117-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2117-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2117-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2118" : helpers.makeTestYear("America/Metlakatla", [
		["2118-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2118-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2118-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2118-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2119" : helpers.makeTestYear("America/Metlakatla", [
		["2119-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2119-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2119-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2119-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2120" : helpers.makeTestYear("America/Metlakatla", [
		["2120-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2120-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2120-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2120-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2121" : helpers.makeTestYear("America/Metlakatla", [
		["2121-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2121-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2121-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2121-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2122" : helpers.makeTestYear("America/Metlakatla", [
		["2122-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2122-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2122-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2122-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2123" : helpers.makeTestYear("America/Metlakatla", [
		["2123-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2123-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2123-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2123-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2124" : helpers.makeTestYear("America/Metlakatla", [
		["2124-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2124-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2124-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2124-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2125" : helpers.makeTestYear("America/Metlakatla", [
		["2125-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2125-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2125-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2125-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2126" : helpers.makeTestYear("America/Metlakatla", [
		["2126-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2126-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2126-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2126-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2127" : helpers.makeTestYear("America/Metlakatla", [
		["2127-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2127-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2127-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2127-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2128" : helpers.makeTestYear("America/Metlakatla", [
		["2128-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2128-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2128-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2128-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2129" : helpers.makeTestYear("America/Metlakatla", [
		["2129-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2129-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2129-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2129-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2130" : helpers.makeTestYear("America/Metlakatla", [
		["2130-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2130-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2130-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2130-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2131" : helpers.makeTestYear("America/Metlakatla", [
		["2131-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2131-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2131-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2131-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2132" : helpers.makeTestYear("America/Metlakatla", [
		["2132-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2132-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2132-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2132-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2133" : helpers.makeTestYear("America/Metlakatla", [
		["2133-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2133-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2133-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2133-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2134" : helpers.makeTestYear("America/Metlakatla", [
		["2134-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2134-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2134-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2134-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2135" : helpers.makeTestYear("America/Metlakatla", [
		["2135-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2135-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2135-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2135-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2136" : helpers.makeTestYear("America/Metlakatla", [
		["2136-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2136-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2136-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2136-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2137" : helpers.makeTestYear("America/Metlakatla", [
		["2137-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2137-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2137-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2137-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2138" : helpers.makeTestYear("America/Metlakatla", [
		["2138-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2138-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2138-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2138-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2139" : helpers.makeTestYear("America/Metlakatla", [
		["2139-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2139-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2139-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2139-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2140" : helpers.makeTestYear("America/Metlakatla", [
		["2140-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2140-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2140-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2140-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2141" : helpers.makeTestYear("America/Metlakatla", [
		["2141-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2141-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2141-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2141-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2142" : helpers.makeTestYear("America/Metlakatla", [
		["2142-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2142-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2142-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2142-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2143" : helpers.makeTestYear("America/Metlakatla", [
		["2143-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2143-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2143-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2143-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2144" : helpers.makeTestYear("America/Metlakatla", [
		["2144-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2144-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2144-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2144-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2145" : helpers.makeTestYear("America/Metlakatla", [
		["2145-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2145-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2145-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2145-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2146" : helpers.makeTestYear("America/Metlakatla", [
		["2146-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2146-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2146-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2146-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2147" : helpers.makeTestYear("America/Metlakatla", [
		["2147-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2147-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2147-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2147-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2148" : helpers.makeTestYear("America/Metlakatla", [
		["2148-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2148-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2148-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2148-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2149" : helpers.makeTestYear("America/Metlakatla", [
		["2149-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2149-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2149-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2149-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2150" : helpers.makeTestYear("America/Metlakatla", [
		["2150-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2150-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2150-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2150-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2151" : helpers.makeTestYear("America/Metlakatla", [
		["2151-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2151-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2151-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2151-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2152" : helpers.makeTestYear("America/Metlakatla", [
		["2152-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2152-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2152-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2152-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2153" : helpers.makeTestYear("America/Metlakatla", [
		["2153-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2153-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2153-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2153-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2154" : helpers.makeTestYear("America/Metlakatla", [
		["2154-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2154-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2154-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2154-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2155" : helpers.makeTestYear("America/Metlakatla", [
		["2155-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2155-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2155-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2155-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2156" : helpers.makeTestYear("America/Metlakatla", [
		["2156-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2156-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2156-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2156-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2157" : helpers.makeTestYear("America/Metlakatla", [
		["2157-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2157-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2157-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2157-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2158" : helpers.makeTestYear("America/Metlakatla", [
		["2158-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2158-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2158-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2158-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2159" : helpers.makeTestYear("America/Metlakatla", [
		["2159-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2159-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2159-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2159-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2160" : helpers.makeTestYear("America/Metlakatla", [
		["2160-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2160-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2160-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2160-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2161" : helpers.makeTestYear("America/Metlakatla", [
		["2161-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2161-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2161-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2161-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2162" : helpers.makeTestYear("America/Metlakatla", [
		["2162-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2162-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2162-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2162-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2163" : helpers.makeTestYear("America/Metlakatla", [
		["2163-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2163-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2163-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2163-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2164" : helpers.makeTestYear("America/Metlakatla", [
		["2164-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2164-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2164-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2164-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2165" : helpers.makeTestYear("America/Metlakatla", [
		["2165-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2165-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2165-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2165-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2166" : helpers.makeTestYear("America/Metlakatla", [
		["2166-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2166-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2166-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2166-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2167" : helpers.makeTestYear("America/Metlakatla", [
		["2167-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2167-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2167-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2167-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2168" : helpers.makeTestYear("America/Metlakatla", [
		["2168-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2168-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2168-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2168-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2169" : helpers.makeTestYear("America/Metlakatla", [
		["2169-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2169-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2169-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2169-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2170" : helpers.makeTestYear("America/Metlakatla", [
		["2170-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2170-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2170-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2170-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2171" : helpers.makeTestYear("America/Metlakatla", [
		["2171-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2171-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2171-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2171-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2172" : helpers.makeTestYear("America/Metlakatla", [
		["2172-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2172-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2172-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2172-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2173" : helpers.makeTestYear("America/Metlakatla", [
		["2173-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2173-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2173-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2173-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2174" : helpers.makeTestYear("America/Metlakatla", [
		["2174-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2174-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2174-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2174-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2175" : helpers.makeTestYear("America/Metlakatla", [
		["2175-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2175-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2175-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2175-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2176" : helpers.makeTestYear("America/Metlakatla", [
		["2176-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2176-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2176-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2176-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2177" : helpers.makeTestYear("America/Metlakatla", [
		["2177-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2177-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2177-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2177-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2178" : helpers.makeTestYear("America/Metlakatla", [
		["2178-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2178-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2178-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2178-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2179" : helpers.makeTestYear("America/Metlakatla", [
		["2179-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2179-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2179-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2179-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2180" : helpers.makeTestYear("America/Metlakatla", [
		["2180-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2180-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2180-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2180-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2181" : helpers.makeTestYear("America/Metlakatla", [
		["2181-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2181-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2181-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2181-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2182" : helpers.makeTestYear("America/Metlakatla", [
		["2182-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2182-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2182-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2182-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2183" : helpers.makeTestYear("America/Metlakatla", [
		["2183-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2183-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2183-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2183-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2184" : helpers.makeTestYear("America/Metlakatla", [
		["2184-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2184-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2184-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2184-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2185" : helpers.makeTestYear("America/Metlakatla", [
		["2185-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2185-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2185-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2185-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2186" : helpers.makeTestYear("America/Metlakatla", [
		["2186-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2186-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2186-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2186-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2187" : helpers.makeTestYear("America/Metlakatla", [
		["2187-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2187-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2187-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2187-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2188" : helpers.makeTestYear("America/Metlakatla", [
		["2188-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2188-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2188-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2188-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2189" : helpers.makeTestYear("America/Metlakatla", [
		["2189-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2189-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2189-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2189-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2190" : helpers.makeTestYear("America/Metlakatla", [
		["2190-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2190-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2190-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2190-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2191" : helpers.makeTestYear("America/Metlakatla", [
		["2191-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2191-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2191-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2191-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2192" : helpers.makeTestYear("America/Metlakatla", [
		["2192-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2192-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2192-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2192-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2193" : helpers.makeTestYear("America/Metlakatla", [
		["2193-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2193-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2193-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2193-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2194" : helpers.makeTestYear("America/Metlakatla", [
		["2194-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2194-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2194-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2194-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2195" : helpers.makeTestYear("America/Metlakatla", [
		["2195-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2195-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2195-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2195-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2196" : helpers.makeTestYear("America/Metlakatla", [
		["2196-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2196-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2196-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2196-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2197" : helpers.makeTestYear("America/Metlakatla", [
		["2197-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2197-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2197-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2197-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2198" : helpers.makeTestYear("America/Metlakatla", [
		["2198-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2198-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2198-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2198-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2199" : helpers.makeTestYear("America/Metlakatla", [
		["2199-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2199-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2199-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2199-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2200" : helpers.makeTestYear("America/Metlakatla", [
		["2200-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2200-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2200-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2200-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2201" : helpers.makeTestYear("America/Metlakatla", [
		["2201-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2201-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2201-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2201-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2202" : helpers.makeTestYear("America/Metlakatla", [
		["2202-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2202-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2202-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2202-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2203" : helpers.makeTestYear("America/Metlakatla", [
		["2203-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2203-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2203-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2203-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2204" : helpers.makeTestYear("America/Metlakatla", [
		["2204-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2204-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2204-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2204-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2205" : helpers.makeTestYear("America/Metlakatla", [
		["2205-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2205-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2205-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2205-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2206" : helpers.makeTestYear("America/Metlakatla", [
		["2206-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2206-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2206-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2206-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2207" : helpers.makeTestYear("America/Metlakatla", [
		["2207-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2207-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2207-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2207-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2208" : helpers.makeTestYear("America/Metlakatla", [
		["2208-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2208-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2208-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2208-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2209" : helpers.makeTestYear("America/Metlakatla", [
		["2209-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2209-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2209-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2209-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2210" : helpers.makeTestYear("America/Metlakatla", [
		["2210-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2210-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2210-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2210-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2211" : helpers.makeTestYear("America/Metlakatla", [
		["2211-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2211-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2211-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2211-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2212" : helpers.makeTestYear("America/Metlakatla", [
		["2212-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2212-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2212-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2212-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2213" : helpers.makeTestYear("America/Metlakatla", [
		["2213-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2213-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2213-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2213-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2214" : helpers.makeTestYear("America/Metlakatla", [
		["2214-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2214-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2214-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2214-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2215" : helpers.makeTestYear("America/Metlakatla", [
		["2215-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2215-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2215-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2215-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2216" : helpers.makeTestYear("America/Metlakatla", [
		["2216-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2216-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2216-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2216-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2217" : helpers.makeTestYear("America/Metlakatla", [
		["2217-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2217-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2217-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2217-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2218" : helpers.makeTestYear("America/Metlakatla", [
		["2218-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2218-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2218-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2218-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2219" : helpers.makeTestYear("America/Metlakatla", [
		["2219-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2219-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2219-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2219-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2220" : helpers.makeTestYear("America/Metlakatla", [
		["2220-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2220-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2220-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2220-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2221" : helpers.makeTestYear("America/Metlakatla", [
		["2221-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2221-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2221-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2221-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2222" : helpers.makeTestYear("America/Metlakatla", [
		["2222-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2222-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2222-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2222-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2223" : helpers.makeTestYear("America/Metlakatla", [
		["2223-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2223-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2223-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2223-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2224" : helpers.makeTestYear("America/Metlakatla", [
		["2224-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2224-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2224-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2224-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2225" : helpers.makeTestYear("America/Metlakatla", [
		["2225-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2225-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2225-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2225-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2226" : helpers.makeTestYear("America/Metlakatla", [
		["2226-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2226-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2226-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2226-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2227" : helpers.makeTestYear("America/Metlakatla", [
		["2227-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2227-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2227-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2227-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2228" : helpers.makeTestYear("America/Metlakatla", [
		["2228-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2228-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2228-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2228-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2229" : helpers.makeTestYear("America/Metlakatla", [
		["2229-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2229-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2229-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2229-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2230" : helpers.makeTestYear("America/Metlakatla", [
		["2230-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2230-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2230-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2230-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2231" : helpers.makeTestYear("America/Metlakatla", [
		["2231-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2231-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2231-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2231-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2232" : helpers.makeTestYear("America/Metlakatla", [
		["2232-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2232-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2232-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2232-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2233" : helpers.makeTestYear("America/Metlakatla", [
		["2233-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2233-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2233-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2233-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2234" : helpers.makeTestYear("America/Metlakatla", [
		["2234-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2234-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2234-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2234-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2235" : helpers.makeTestYear("America/Metlakatla", [
		["2235-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2235-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2235-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2235-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2236" : helpers.makeTestYear("America/Metlakatla", [
		["2236-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2236-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2236-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2236-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2237" : helpers.makeTestYear("America/Metlakatla", [
		["2237-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2237-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2237-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2237-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2238" : helpers.makeTestYear("America/Metlakatla", [
		["2238-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2238-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2238-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2238-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2239" : helpers.makeTestYear("America/Metlakatla", [
		["2239-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2239-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2239-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2239-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2240" : helpers.makeTestYear("America/Metlakatla", [
		["2240-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2240-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2240-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2240-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2241" : helpers.makeTestYear("America/Metlakatla", [
		["2241-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2241-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2241-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2241-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2242" : helpers.makeTestYear("America/Metlakatla", [
		["2242-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2242-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2242-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2242-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2243" : helpers.makeTestYear("America/Metlakatla", [
		["2243-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2243-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2243-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2243-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2244" : helpers.makeTestYear("America/Metlakatla", [
		["2244-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2244-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2244-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2244-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2245" : helpers.makeTestYear("America/Metlakatla", [
		["2245-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2245-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2245-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2245-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2246" : helpers.makeTestYear("America/Metlakatla", [
		["2246-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2246-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2246-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2246-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2247" : helpers.makeTestYear("America/Metlakatla", [
		["2247-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2247-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2247-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2247-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2248" : helpers.makeTestYear("America/Metlakatla", [
		["2248-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2248-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2248-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2248-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2249" : helpers.makeTestYear("America/Metlakatla", [
		["2249-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2249-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2249-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2249-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2250" : helpers.makeTestYear("America/Metlakatla", [
		["2250-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2250-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2250-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2250-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2251" : helpers.makeTestYear("America/Metlakatla", [
		["2251-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2251-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2251-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2251-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2252" : helpers.makeTestYear("America/Metlakatla", [
		["2252-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2252-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2252-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2252-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2253" : helpers.makeTestYear("America/Metlakatla", [
		["2253-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2253-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2253-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2253-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2254" : helpers.makeTestYear("America/Metlakatla", [
		["2254-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2254-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2254-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2254-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2255" : helpers.makeTestYear("America/Metlakatla", [
		["2255-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2255-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2255-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2255-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2256" : helpers.makeTestYear("America/Metlakatla", [
		["2256-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2256-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2256-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2256-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2257" : helpers.makeTestYear("America/Metlakatla", [
		["2257-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2257-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2257-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2257-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2258" : helpers.makeTestYear("America/Metlakatla", [
		["2258-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2258-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2258-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2258-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2259" : helpers.makeTestYear("America/Metlakatla", [
		["2259-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2259-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2259-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2259-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2260" : helpers.makeTestYear("America/Metlakatla", [
		["2260-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2260-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2260-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2260-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2261" : helpers.makeTestYear("America/Metlakatla", [
		["2261-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2261-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2261-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2261-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2262" : helpers.makeTestYear("America/Metlakatla", [
		["2262-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2262-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2262-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2262-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2263" : helpers.makeTestYear("America/Metlakatla", [
		["2263-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2263-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2263-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2263-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2264" : helpers.makeTestYear("America/Metlakatla", [
		["2264-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2264-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2264-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2264-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2265" : helpers.makeTestYear("America/Metlakatla", [
		["2265-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2265-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2265-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2265-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2266" : helpers.makeTestYear("America/Metlakatla", [
		["2266-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2266-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2266-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2266-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2267" : helpers.makeTestYear("America/Metlakatla", [
		["2267-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2267-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2267-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2267-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2268" : helpers.makeTestYear("America/Metlakatla", [
		["2268-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2268-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2268-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2268-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2269" : helpers.makeTestYear("America/Metlakatla", [
		["2269-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2269-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2269-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2269-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2270" : helpers.makeTestYear("America/Metlakatla", [
		["2270-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2270-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2270-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2270-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2271" : helpers.makeTestYear("America/Metlakatla", [
		["2271-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2271-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2271-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2271-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2272" : helpers.makeTestYear("America/Metlakatla", [
		["2272-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2272-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2272-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2272-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2273" : helpers.makeTestYear("America/Metlakatla", [
		["2273-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2273-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2273-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2273-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2274" : helpers.makeTestYear("America/Metlakatla", [
		["2274-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2274-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2274-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2274-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2275" : helpers.makeTestYear("America/Metlakatla", [
		["2275-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2275-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2275-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2275-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2276" : helpers.makeTestYear("America/Metlakatla", [
		["2276-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2276-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2276-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2276-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2277" : helpers.makeTestYear("America/Metlakatla", [
		["2277-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2277-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2277-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2277-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2278" : helpers.makeTestYear("America/Metlakatla", [
		["2278-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2278-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2278-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2278-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2279" : helpers.makeTestYear("America/Metlakatla", [
		["2279-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2279-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2279-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2279-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2280" : helpers.makeTestYear("America/Metlakatla", [
		["2280-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2280-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2280-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2280-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2281" : helpers.makeTestYear("America/Metlakatla", [
		["2281-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2281-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2281-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2281-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2282" : helpers.makeTestYear("America/Metlakatla", [
		["2282-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2282-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2282-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2282-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2283" : helpers.makeTestYear("America/Metlakatla", [
		["2283-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2283-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2283-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2283-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2284" : helpers.makeTestYear("America/Metlakatla", [
		["2284-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2284-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2284-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2284-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2285" : helpers.makeTestYear("America/Metlakatla", [
		["2285-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2285-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2285-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2285-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2286" : helpers.makeTestYear("America/Metlakatla", [
		["2286-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2286-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2286-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2286-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2287" : helpers.makeTestYear("America/Metlakatla", [
		["2287-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2287-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2287-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2287-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2288" : helpers.makeTestYear("America/Metlakatla", [
		["2288-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2288-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2288-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2288-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2289" : helpers.makeTestYear("America/Metlakatla", [
		["2289-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2289-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2289-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2289-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2290" : helpers.makeTestYear("America/Metlakatla", [
		["2290-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2290-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2290-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2290-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2291" : helpers.makeTestYear("America/Metlakatla", [
		["2291-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2291-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2291-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2291-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2292" : helpers.makeTestYear("America/Metlakatla", [
		["2292-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2292-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2292-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2292-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2293" : helpers.makeTestYear("America/Metlakatla", [
		["2293-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2293-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2293-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2293-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2294" : helpers.makeTestYear("America/Metlakatla", [
		["2294-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2294-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2294-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2294-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2295" : helpers.makeTestYear("America/Metlakatla", [
		["2295-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2295-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2295-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2295-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2296" : helpers.makeTestYear("America/Metlakatla", [
		["2296-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2296-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2296-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2296-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2297" : helpers.makeTestYear("America/Metlakatla", [
		["2297-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2297-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2297-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2297-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2298" : helpers.makeTestYear("America/Metlakatla", [
		["2298-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2298-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2298-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2298-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2299" : helpers.makeTestYear("America/Metlakatla", [
		["2299-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2299-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2299-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2299-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2300" : helpers.makeTestYear("America/Metlakatla", [
		["2300-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2300-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2300-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2300-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2301" : helpers.makeTestYear("America/Metlakatla", [
		["2301-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2301-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2301-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2301-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2302" : helpers.makeTestYear("America/Metlakatla", [
		["2302-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2302-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2302-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2302-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2303" : helpers.makeTestYear("America/Metlakatla", [
		["2303-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2303-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2303-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2303-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2304" : helpers.makeTestYear("America/Metlakatla", [
		["2304-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2304-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2304-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2304-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2305" : helpers.makeTestYear("America/Metlakatla", [
		["2305-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2305-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2305-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2305-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2306" : helpers.makeTestYear("America/Metlakatla", [
		["2306-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2306-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2306-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2306-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2307" : helpers.makeTestYear("America/Metlakatla", [
		["2307-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2307-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2307-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2307-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2308" : helpers.makeTestYear("America/Metlakatla", [
		["2308-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2308-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2308-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2308-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2309" : helpers.makeTestYear("America/Metlakatla", [
		["2309-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2309-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2309-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2309-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2310" : helpers.makeTestYear("America/Metlakatla", [
		["2310-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2310-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2310-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2310-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2311" : helpers.makeTestYear("America/Metlakatla", [
		["2311-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2311-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2311-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2311-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2312" : helpers.makeTestYear("America/Metlakatla", [
		["2312-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2312-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2312-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2312-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2313" : helpers.makeTestYear("America/Metlakatla", [
		["2313-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2313-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2313-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2313-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2314" : helpers.makeTestYear("America/Metlakatla", [
		["2314-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2314-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2314-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2314-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2315" : helpers.makeTestYear("America/Metlakatla", [
		["2315-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2315-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2315-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2315-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2316" : helpers.makeTestYear("America/Metlakatla", [
		["2316-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2316-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2316-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2316-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2317" : helpers.makeTestYear("America/Metlakatla", [
		["2317-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2317-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2317-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2317-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2318" : helpers.makeTestYear("America/Metlakatla", [
		["2318-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2318-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2318-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2318-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2319" : helpers.makeTestYear("America/Metlakatla", [
		["2319-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2319-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2319-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2319-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2320" : helpers.makeTestYear("America/Metlakatla", [
		["2320-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2320-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2320-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2320-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2321" : helpers.makeTestYear("America/Metlakatla", [
		["2321-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2321-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2321-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2321-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2322" : helpers.makeTestYear("America/Metlakatla", [
		["2322-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2322-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2322-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2322-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2323" : helpers.makeTestYear("America/Metlakatla", [
		["2323-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2323-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2323-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2323-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2324" : helpers.makeTestYear("America/Metlakatla", [
		["2324-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2324-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2324-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2324-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2325" : helpers.makeTestYear("America/Metlakatla", [
		["2325-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2325-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2325-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2325-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2326" : helpers.makeTestYear("America/Metlakatla", [
		["2326-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2326-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2326-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2326-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2327" : helpers.makeTestYear("America/Metlakatla", [
		["2327-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2327-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2327-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2327-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2328" : helpers.makeTestYear("America/Metlakatla", [
		["2328-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2328-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2328-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2328-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2329" : helpers.makeTestYear("America/Metlakatla", [
		["2329-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2329-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2329-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2329-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2330" : helpers.makeTestYear("America/Metlakatla", [
		["2330-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2330-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2330-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2330-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2331" : helpers.makeTestYear("America/Metlakatla", [
		["2331-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2331-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2331-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2331-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2332" : helpers.makeTestYear("America/Metlakatla", [
		["2332-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2332-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2332-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2332-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2333" : helpers.makeTestYear("America/Metlakatla", [
		["2333-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2333-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2333-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2333-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2334" : helpers.makeTestYear("America/Metlakatla", [
		["2334-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2334-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2334-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2334-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2335" : helpers.makeTestYear("America/Metlakatla", [
		["2335-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2335-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2335-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2335-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2336" : helpers.makeTestYear("America/Metlakatla", [
		["2336-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2336-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2336-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2336-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2337" : helpers.makeTestYear("America/Metlakatla", [
		["2337-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2337-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2337-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2337-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2338" : helpers.makeTestYear("America/Metlakatla", [
		["2338-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2338-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2338-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2338-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2339" : helpers.makeTestYear("America/Metlakatla", [
		["2339-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2339-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2339-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2339-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2340" : helpers.makeTestYear("America/Metlakatla", [
		["2340-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2340-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2340-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2340-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2341" : helpers.makeTestYear("America/Metlakatla", [
		["2341-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2341-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2341-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2341-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2342" : helpers.makeTestYear("America/Metlakatla", [
		["2342-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2342-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2342-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2342-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2343" : helpers.makeTestYear("America/Metlakatla", [
		["2343-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2343-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2343-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2343-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2344" : helpers.makeTestYear("America/Metlakatla", [
		["2344-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2344-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2344-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2344-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2345" : helpers.makeTestYear("America/Metlakatla", [
		["2345-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2345-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2345-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2345-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2346" : helpers.makeTestYear("America/Metlakatla", [
		["2346-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2346-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2346-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2346-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2347" : helpers.makeTestYear("America/Metlakatla", [
		["2347-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2347-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2347-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2347-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2348" : helpers.makeTestYear("America/Metlakatla", [
		["2348-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2348-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2348-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2348-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2349" : helpers.makeTestYear("America/Metlakatla", [
		["2349-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2349-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2349-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2349-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2350" : helpers.makeTestYear("America/Metlakatla", [
		["2350-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2350-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2350-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2350-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2351" : helpers.makeTestYear("America/Metlakatla", [
		["2351-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2351-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2351-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2351-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2352" : helpers.makeTestYear("America/Metlakatla", [
		["2352-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2352-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2352-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2352-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2353" : helpers.makeTestYear("America/Metlakatla", [
		["2353-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2353-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2353-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2353-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2354" : helpers.makeTestYear("America/Metlakatla", [
		["2354-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2354-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2354-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2354-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2355" : helpers.makeTestYear("America/Metlakatla", [
		["2355-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2355-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2355-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2355-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2356" : helpers.makeTestYear("America/Metlakatla", [
		["2356-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2356-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2356-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2356-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2357" : helpers.makeTestYear("America/Metlakatla", [
		["2357-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2357-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2357-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2357-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2358" : helpers.makeTestYear("America/Metlakatla", [
		["2358-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2358-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2358-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2358-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2359" : helpers.makeTestYear("America/Metlakatla", [
		["2359-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2359-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2359-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2359-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2360" : helpers.makeTestYear("America/Metlakatla", [
		["2360-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2360-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2360-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2360-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2361" : helpers.makeTestYear("America/Metlakatla", [
		["2361-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2361-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2361-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2361-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2362" : helpers.makeTestYear("America/Metlakatla", [
		["2362-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2362-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2362-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2362-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2363" : helpers.makeTestYear("America/Metlakatla", [
		["2363-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2363-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2363-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2363-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2364" : helpers.makeTestYear("America/Metlakatla", [
		["2364-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2364-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2364-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2364-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2365" : helpers.makeTestYear("America/Metlakatla", [
		["2365-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2365-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2365-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2365-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2366" : helpers.makeTestYear("America/Metlakatla", [
		["2366-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2366-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2366-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2366-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2367" : helpers.makeTestYear("America/Metlakatla", [
		["2367-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2367-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2367-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2367-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2368" : helpers.makeTestYear("America/Metlakatla", [
		["2368-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2368-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2368-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2368-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2369" : helpers.makeTestYear("America/Metlakatla", [
		["2369-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2369-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2369-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2369-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2370" : helpers.makeTestYear("America/Metlakatla", [
		["2370-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2370-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2370-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2370-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2371" : helpers.makeTestYear("America/Metlakatla", [
		["2371-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2371-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2371-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2371-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2372" : helpers.makeTestYear("America/Metlakatla", [
		["2372-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2372-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2372-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2372-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2373" : helpers.makeTestYear("America/Metlakatla", [
		["2373-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2373-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2373-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2373-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2374" : helpers.makeTestYear("America/Metlakatla", [
		["2374-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2374-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2374-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2374-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2375" : helpers.makeTestYear("America/Metlakatla", [
		["2375-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2375-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2375-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2375-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2376" : helpers.makeTestYear("America/Metlakatla", [
		["2376-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2376-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2376-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2376-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2377" : helpers.makeTestYear("America/Metlakatla", [
		["2377-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2377-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2377-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2377-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2378" : helpers.makeTestYear("America/Metlakatla", [
		["2378-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2378-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2378-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2378-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2379" : helpers.makeTestYear("America/Metlakatla", [
		["2379-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2379-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2379-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2379-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2380" : helpers.makeTestYear("America/Metlakatla", [
		["2380-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2380-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2380-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2380-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2381" : helpers.makeTestYear("America/Metlakatla", [
		["2381-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2381-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2381-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2381-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2382" : helpers.makeTestYear("America/Metlakatla", [
		["2382-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2382-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2382-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2382-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2383" : helpers.makeTestYear("America/Metlakatla", [
		["2383-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2383-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2383-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2383-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2384" : helpers.makeTestYear("America/Metlakatla", [
		["2384-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2384-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2384-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2384-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2385" : helpers.makeTestYear("America/Metlakatla", [
		["2385-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2385-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2385-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2385-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2386" : helpers.makeTestYear("America/Metlakatla", [
		["2386-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2386-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2386-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2386-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2387" : helpers.makeTestYear("America/Metlakatla", [
		["2387-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2387-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2387-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2387-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2388" : helpers.makeTestYear("America/Metlakatla", [
		["2388-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2388-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2388-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2388-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2389" : helpers.makeTestYear("America/Metlakatla", [
		["2389-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2389-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2389-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2389-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2390" : helpers.makeTestYear("America/Metlakatla", [
		["2390-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2390-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2390-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2390-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2391" : helpers.makeTestYear("America/Metlakatla", [
		["2391-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2391-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2391-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2391-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2392" : helpers.makeTestYear("America/Metlakatla", [
		["2392-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2392-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2392-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2392-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2393" : helpers.makeTestYear("America/Metlakatla", [
		["2393-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2393-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2393-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2393-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2394" : helpers.makeTestYear("America/Metlakatla", [
		["2394-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2394-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2394-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2394-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2395" : helpers.makeTestYear("America/Metlakatla", [
		["2395-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2395-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2395-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2395-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2396" : helpers.makeTestYear("America/Metlakatla", [
		["2396-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2396-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2396-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2396-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2397" : helpers.makeTestYear("America/Metlakatla", [
		["2397-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2397-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2397-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2397-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2398" : helpers.makeTestYear("America/Metlakatla", [
		["2398-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2398-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2398-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2398-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2399" : helpers.makeTestYear("America/Metlakatla", [
		["2399-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2399-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2399-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2399-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2400" : helpers.makeTestYear("America/Metlakatla", [
		["2400-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2400-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2400-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2400-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2401" : helpers.makeTestYear("America/Metlakatla", [
		["2401-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2401-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2401-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2401-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2402" : helpers.makeTestYear("America/Metlakatla", [
		["2402-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2402-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2402-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2402-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2403" : helpers.makeTestYear("America/Metlakatla", [
		["2403-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2403-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2403-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2403-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2404" : helpers.makeTestYear("America/Metlakatla", [
		["2404-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2404-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2404-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2404-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2405" : helpers.makeTestYear("America/Metlakatla", [
		["2405-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2405-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2405-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2405-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2406" : helpers.makeTestYear("America/Metlakatla", [
		["2406-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2406-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2406-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2406-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2407" : helpers.makeTestYear("America/Metlakatla", [
		["2407-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2407-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2407-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2407-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2408" : helpers.makeTestYear("America/Metlakatla", [
		["2408-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2408-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2408-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2408-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2409" : helpers.makeTestYear("America/Metlakatla", [
		["2409-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2409-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2409-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2409-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2410" : helpers.makeTestYear("America/Metlakatla", [
		["2410-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2410-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2410-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2410-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2411" : helpers.makeTestYear("America/Metlakatla", [
		["2411-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2411-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2411-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2411-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2412" : helpers.makeTestYear("America/Metlakatla", [
		["2412-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2412-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2412-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2412-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2413" : helpers.makeTestYear("America/Metlakatla", [
		["2413-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2413-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2413-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2413-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2414" : helpers.makeTestYear("America/Metlakatla", [
		["2414-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2414-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2414-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2414-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2415" : helpers.makeTestYear("America/Metlakatla", [
		["2415-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2415-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2415-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2415-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2416" : helpers.makeTestYear("America/Metlakatla", [
		["2416-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2416-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2416-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2416-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2417" : helpers.makeTestYear("America/Metlakatla", [
		["2417-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2417-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2417-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2417-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2418" : helpers.makeTestYear("America/Metlakatla", [
		["2418-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2418-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2418-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2418-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2419" : helpers.makeTestYear("America/Metlakatla", [
		["2419-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2419-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2419-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2419-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2420" : helpers.makeTestYear("America/Metlakatla", [
		["2420-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2420-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2420-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2420-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2421" : helpers.makeTestYear("America/Metlakatla", [
		["2421-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2421-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2421-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2421-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2422" : helpers.makeTestYear("America/Metlakatla", [
		["2422-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2422-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2422-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2422-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2423" : helpers.makeTestYear("America/Metlakatla", [
		["2423-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2423-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2423-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2423-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2424" : helpers.makeTestYear("America/Metlakatla", [
		["2424-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2424-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2424-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2424-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2425" : helpers.makeTestYear("America/Metlakatla", [
		["2425-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2425-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2425-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2425-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2426" : helpers.makeTestYear("America/Metlakatla", [
		["2426-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2426-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2426-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2426-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2427" : helpers.makeTestYear("America/Metlakatla", [
		["2427-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2427-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2427-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2427-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2428" : helpers.makeTestYear("America/Metlakatla", [
		["2428-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2428-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2428-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2428-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2429" : helpers.makeTestYear("America/Metlakatla", [
		["2429-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2429-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2429-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2429-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2430" : helpers.makeTestYear("America/Metlakatla", [
		["2430-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2430-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2430-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2430-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2431" : helpers.makeTestYear("America/Metlakatla", [
		["2431-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2431-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2431-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2431-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2432" : helpers.makeTestYear("America/Metlakatla", [
		["2432-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2432-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2432-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2432-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2433" : helpers.makeTestYear("America/Metlakatla", [
		["2433-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2433-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2433-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2433-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2434" : helpers.makeTestYear("America/Metlakatla", [
		["2434-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2434-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2434-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2434-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2435" : helpers.makeTestYear("America/Metlakatla", [
		["2435-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2435-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2435-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2435-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2436" : helpers.makeTestYear("America/Metlakatla", [
		["2436-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2436-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2436-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2436-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2437" : helpers.makeTestYear("America/Metlakatla", [
		["2437-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2437-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2437-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2437-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2438" : helpers.makeTestYear("America/Metlakatla", [
		["2438-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2438-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2438-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2438-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2439" : helpers.makeTestYear("America/Metlakatla", [
		["2439-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2439-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2439-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2439-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2440" : helpers.makeTestYear("America/Metlakatla", [
		["2440-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2440-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2440-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2440-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2441" : helpers.makeTestYear("America/Metlakatla", [
		["2441-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2441-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2441-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2441-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2442" : helpers.makeTestYear("America/Metlakatla", [
		["2442-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2442-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2442-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2442-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2443" : helpers.makeTestYear("America/Metlakatla", [
		["2443-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2443-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2443-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2443-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2444" : helpers.makeTestYear("America/Metlakatla", [
		["2444-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2444-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2444-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2444-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2445" : helpers.makeTestYear("America/Metlakatla", [
		["2445-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2445-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2445-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2445-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2446" : helpers.makeTestYear("America/Metlakatla", [
		["2446-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2446-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2446-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2446-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2447" : helpers.makeTestYear("America/Metlakatla", [
		["2447-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2447-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2447-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2447-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2448" : helpers.makeTestYear("America/Metlakatla", [
		["2448-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2448-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2448-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2448-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2449" : helpers.makeTestYear("America/Metlakatla", [
		["2449-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2449-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2449-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2449-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2450" : helpers.makeTestYear("America/Metlakatla", [
		["2450-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2450-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2450-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2450-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2451" : helpers.makeTestYear("America/Metlakatla", [
		["2451-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2451-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2451-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2451-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2452" : helpers.makeTestYear("America/Metlakatla", [
		["2452-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2452-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2452-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2452-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2453" : helpers.makeTestYear("America/Metlakatla", [
		["2453-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2453-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2453-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2453-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2454" : helpers.makeTestYear("America/Metlakatla", [
		["2454-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2454-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2454-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2454-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2455" : helpers.makeTestYear("America/Metlakatla", [
		["2455-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2455-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2455-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2455-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2456" : helpers.makeTestYear("America/Metlakatla", [
		["2456-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2456-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2456-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2456-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2457" : helpers.makeTestYear("America/Metlakatla", [
		["2457-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2457-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2457-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2457-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2458" : helpers.makeTestYear("America/Metlakatla", [
		["2458-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2458-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2458-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2458-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2459" : helpers.makeTestYear("America/Metlakatla", [
		["2459-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2459-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2459-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2459-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2460" : helpers.makeTestYear("America/Metlakatla", [
		["2460-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2460-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2460-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2460-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2461" : helpers.makeTestYear("America/Metlakatla", [
		["2461-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2461-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2461-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2461-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2462" : helpers.makeTestYear("America/Metlakatla", [
		["2462-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2462-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2462-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2462-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2463" : helpers.makeTestYear("America/Metlakatla", [
		["2463-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2463-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2463-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2463-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2464" : helpers.makeTestYear("America/Metlakatla", [
		["2464-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2464-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2464-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2464-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2465" : helpers.makeTestYear("America/Metlakatla", [
		["2465-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2465-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2465-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2465-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2466" : helpers.makeTestYear("America/Metlakatla", [
		["2466-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2466-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2466-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2466-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2467" : helpers.makeTestYear("America/Metlakatla", [
		["2467-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2467-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2467-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2467-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2468" : helpers.makeTestYear("America/Metlakatla", [
		["2468-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2468-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2468-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2468-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2469" : helpers.makeTestYear("America/Metlakatla", [
		["2469-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2469-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2469-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2469-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2470" : helpers.makeTestYear("America/Metlakatla", [
		["2470-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2470-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2470-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2470-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2471" : helpers.makeTestYear("America/Metlakatla", [
		["2471-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2471-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2471-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2471-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2472" : helpers.makeTestYear("America/Metlakatla", [
		["2472-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2472-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2472-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2472-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2473" : helpers.makeTestYear("America/Metlakatla", [
		["2473-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2473-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2473-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2473-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2474" : helpers.makeTestYear("America/Metlakatla", [
		["2474-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2474-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2474-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2474-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2475" : helpers.makeTestYear("America/Metlakatla", [
		["2475-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2475-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2475-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2475-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2476" : helpers.makeTestYear("America/Metlakatla", [
		["2476-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2476-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2476-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2476-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2477" : helpers.makeTestYear("America/Metlakatla", [
		["2477-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2477-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2477-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2477-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2478" : helpers.makeTestYear("America/Metlakatla", [
		["2478-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2478-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2478-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2478-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2479" : helpers.makeTestYear("America/Metlakatla", [
		["2479-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2479-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2479-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2479-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2480" : helpers.makeTestYear("America/Metlakatla", [
		["2480-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2480-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2480-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2480-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2481" : helpers.makeTestYear("America/Metlakatla", [
		["2481-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2481-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2481-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2481-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2482" : helpers.makeTestYear("America/Metlakatla", [
		["2482-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2482-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2482-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2482-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2483" : helpers.makeTestYear("America/Metlakatla", [
		["2483-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2483-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2483-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2483-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2484" : helpers.makeTestYear("America/Metlakatla", [
		["2484-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2484-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2484-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2484-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2485" : helpers.makeTestYear("America/Metlakatla", [
		["2485-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2485-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2485-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2485-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2486" : helpers.makeTestYear("America/Metlakatla", [
		["2486-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2486-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2486-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2486-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2487" : helpers.makeTestYear("America/Metlakatla", [
		["2487-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2487-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2487-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2487-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2488" : helpers.makeTestYear("America/Metlakatla", [
		["2488-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2488-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2488-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2488-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2489" : helpers.makeTestYear("America/Metlakatla", [
		["2489-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2489-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2489-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2489-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2490" : helpers.makeTestYear("America/Metlakatla", [
		["2490-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2490-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2490-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2490-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2491" : helpers.makeTestYear("America/Metlakatla", [
		["2491-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2491-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2491-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2491-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2492" : helpers.makeTestYear("America/Metlakatla", [
		["2492-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2492-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2492-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2492-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2493" : helpers.makeTestYear("America/Metlakatla", [
		["2493-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2493-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2493-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2493-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2494" : helpers.makeTestYear("America/Metlakatla", [
		["2494-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2494-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2494-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2494-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2495" : helpers.makeTestYear("America/Metlakatla", [
		["2495-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2495-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2495-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2495-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2496" : helpers.makeTestYear("America/Metlakatla", [
		["2496-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2496-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2496-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2496-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2497" : helpers.makeTestYear("America/Metlakatla", [
		["2497-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2497-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2497-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2497-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2498" : helpers.makeTestYear("America/Metlakatla", [
		["2498-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2498-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2498-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2498-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2499" : helpers.makeTestYear("America/Metlakatla", [
		["2499-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2499-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480]
	])
};