/*
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _STARTER_POPUP_H_
#define _STARTER_POPUP_H_

#include "mforms/popup.h"
#include "mforms/menu.h"

#include "wb_context.h"

namespace wb {

  enum StarterAction
  {
    StarterNone,

    StarterPluginCentral,

    StarterStartPlugin,
    StarterStartPluginExternal,
    StarterFindPlugin,
    StarterAuthorHome,
    StarterSetAt1,
    StarterSetAt2,
    StarterSetAt3,
    StarterSetAt4,
    StarterSetAt5,
    StarterSetAt6,
    StarterInsertAt1,
    StarterInsertAt2,
    StarterInsertAt3,
    StarterInsertAt4,
    StarterInsertAt5,
    StarterInsertAt6,
  };

  typedef void (*starter_action_callback)(StarterAction action, const app_StarterRef& starter, void* user_data);

  typedef struct
  {
    app_StarterRef starter;
    MySQL::Geometry::Rect bounds; // Overall bounds of the entry.
  } PopupEntry;

  class StarterPopup : public mforms::Popup
  {
  private:
    WBContext* _context;
    mforms::Menu* _action_menu;
    mforms::Menu* _placing_menu;

    std::vector<PopupEntry> _entries;
    cairo_surface_t* _mysql_plugin_overlay;
    cairo_surface_t* _community_plugin_overlay;
    cairo_surface_t* _legal_image;
    cairo_surface_t* _default_starter_icon;

    cairo_surface_t* _nav_button_parts[3];
    cairo_pattern_t* _nav_button_pattern;
    cairo_surface_t* _action_button_parts[3];
    cairo_pattern_t* _action_button_pattern;

    MySQL::Geometry::Rect _more_button_bounds;
    MySQL::Geometry::Rect _back_button_bounds;
    MySQL::Geometry::Rect _next_button_bounds;
    MySQL::Geometry::Rect _action_button_bounds; // Cache for quicker hit tests.

    int _current_page;
    int _page_count;
    app_StarterRef _hot_entry;

    starter_action_callback _callback;
    void* _user_data;
  protected:
    void draw_button(cairo_t* cr, double x, double y, double w, bool action);
    void draw_entry(cairo_t* cr, app_StarterRef starter, int x, int y, int w, int h);
    app_StarterRef starter_from_point(int x, int y);
    void handle_command(const std::string& command);
  public:
    StarterPopup(WBContext* context);
    ~StarterPopup();

    void set_callback(starter_action_callback callback, void* user_data);

    virtual void repaint(cairo_t *cr, int x, int y, int w, int h);

    virtual void mouse_down(int button, int x, int y);
    virtual void mouse_up(int button, int x, int y);
    virtual void mouse_click(int button, int x, int y);
    virtual void mouse_enter();
    virtual void mouse_leave();
    virtual void mouse_move(int x, int y);
  };
};

#endif // _STARTER_POPUP_H_
