#ifndef __ERRORS_LIST_H__
#define __ERRORS_LIST_H__

#include <gtkmm.h>
#include <sigc++/sigc++.h>
#include "grtdb/editor_dbobject.h"

//==============================================================================
//
//==============================================================================
class ErrorsList
{
  public:
    ErrorsList(bec::DBObjectEditorBE* be);
    ~ErrorsList();
    
    Gtk::TreeView& widget();
    void switch_be(bec::DBObjectEditorBE* be);
    
    void clear_list();
    int add_error(const int line, const int err_tok_line_pos, const int err_tok_len, const std::string &err_msg);
    typedef sigc::signal<void, const int, const std::string&> ErrorSelectedSignal;
    ErrorSelectedSignal& signal_error_selected() { return _error_selected_signal; };

    bec::DBObjectEditorBE::Sql_parser_err_cb _sql_parser_err_cb;
    void set_sql_parser_err_cb(const bec::DBObjectEditorBE::Sql_parser_err_cb &cb) { _sql_parser_err_cb= cb; }

  private:
    void error_selected();

    struct ErrorColumns : public Gtk::TreeModel::ColumnRecord
    {
      ErrorColumns()
      {
        add(lineno);
        add(msg);
      }
      
      Gtk::TreeModelColumn<int>         lineno;
      Gtk::TreeModelColumn<std::string> msg;
    };

    Gtk::TreeView                            *_errors_tv;
    ErrorColumns                              _errors_columns;
    Glib::RefPtr<Gtk::ListStore>              _errors_model;
    ErrorSelectedSignal                       _error_selected_signal;
    bec::DBObjectEditorBE                    *_be;
};

#endif
