/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

//#include "stdafx.h"
#include "base/notifications.h"
#include "base/log.h"
#include <stdexcept>

DEFAULT_LOG_DOMAIN("base");

using namespace base;

NotificationCenter *NotificationCenter::get()
{
  static NotificationCenter *nc = 0;
  if (!nc)
    nc = new NotificationCenter();
  return nc;
}


Observer::~Observer()
{
  NotificationCenter *nc = NotificationCenter::get();
  if (nc->remove_observer(this))
    log_error("INTERNAL ERROR: Observer %p was deleted while still listening for notifications\n", this);
}


void NotificationCenter::add_observer(Observer *observer, const std::string &name)
{
  ObserverEntry entry;
  entry.observer = observer;
  entry.observed_notification = name;
  _observers.push_back(entry);
}

/*
void NotificationCenter::add_observer(Observer *observer, boost::function<void (const std::string &, void*, NotificationInfo &)> &callback, const std::string &name)
{
  ObserverEntry entry;
  entry.observer = observer;
  entry.callback = callback;
  entry.observed_notification = name;
  _observers.push_back(entry);
}*/


bool NotificationCenter::remove_observer(Observer *observer, const std::string &name)
{
  bool found = false;
  for (std::list<ObserverEntry>::iterator next, iter = _observers.begin(); iter != _observers.end();)
  {
    next = iter;
    ++next;
    if (iter->observer == observer && (name.empty() || name == iter->observed_notification))
    {
      found = true;
      _observers.erase(iter);
    }
    iter = next;
  }
  return found;
}


void NotificationCenter::send(const std::string &name, void *sender, NotificationInfo &info)
{
  if (name.substr(0, 2) != "GN")
    throw std::invalid_argument("Attempt to send notification with a name that doesn't start with GNot");
  
  // act on a copy of the observer list, because one of them could remove stuff from the list
  std::list<ObserverEntry> copy(_observers);
  for (std::list<ObserverEntry>::iterator iter = copy.begin(); iter != copy.end(); ++iter)
  {
    if (iter->observed_notification.empty() || iter->observed_notification == name)
    {
      //if (iter->callback)
      //  iter->callback(name, sender, info);
      //else
      iter->observer->handle_notification(name, sender, info);
    }
  }
}


void NotificationCenter::send(const std::string &name, void *sender)
{
  NotificationInfo info;
  send(name, sender, info);
}
