/* 
 * Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include <stdio.h>

using namespace mforms;
using namespace MySQL::Geometry;
using namespace MySQL::Drawing;

// Implementation of _app_impl for WB is done directly in main_window.cpp in Linux
// and WBMainWindow.mm in Mac
// In Windows, it's done in wf_app.h/wf_app.cpp wrapper

App *App::get()
{
  static App *singleton= 0;
  if (!singleton)
  {
    singleton= new App();
    singleton->_app_impl= &ControlFactory::get_instance()->_app_impl;
  }
  return singleton;
}


void App::dock_view(AppView *view, const std::string &position)
{
  if (_app_impl->dock_view)
    _app_impl->dock_view(this, view, position);
}

bool App::select_view(const std::string &identifier)
{
  if (_app_impl->select_view)
    return _app_impl->select_view(this, identifier);
  return false;
}

void App::undock_view(AppView *view)
{
  if (_app_impl->undock_view)
    _app_impl->undock_view(this, view);
}


void App::set_view_title(AppView *view, const std::string &title)
{
  if (_app_impl->set_view_title)
    _app_impl->set_view_title(this, view, title);
}

std::string App::get_resource_path(const std::string &file)
{
  std::string ret;
  if (_app_impl->get_resource_path)
    ret = _app_impl->get_resource_path(this, file);
  return ret;
}

void App::set_status_text(const std::string &text)
{
  if (_app_impl->set_status_text)
    _app_impl->set_status_text(this, text);
}

void App::begin_thread_loop()
{
  if (ControlFactory::get_instance()->_app_impl.begin_thread_loop)
    ControlFactory::get_instance()->_app_impl.begin_thread_loop();
}

void App::end_thread_loop()
{
  if (ControlFactory::get_instance()->_app_impl.end_thread_loop)
    ControlFactory::get_instance()->_app_impl.end_thread_loop();
}

//--------------------------------------------------------------------------------------------------

/**
 * Returns the bounds of the main application window.
 */
void App::get_bounds(int* x, int* y, int* w, int* h)
{
  bool valid= false;
  if (_app_impl->get_bounds)
  {
    std::string bounds= _app_impl->get_bounds(this);
#ifdef _WIN32
    // Use secure std lib.
    if (sscanf_s(bounds.c_str(), "%i %i %i %i", x, y, w, h) == 4)
#else
    if (sscanf(bounds.c_str(), "%i %i %i %i", x, y, w, h) == 4)
#endif
      valid= true;
  }

  if (!valid)
  {
    x= 0;
    y= 0;
    w= 0;
    h= 0;
  }
}

//--------------------------------------------------------------------------------------------------

int App::enter_event_loop(float timeout)
{
  return _app_impl->enter_event_loop(this, timeout);
}

//--------------------------------------------------------------------------------------------------

void App::exit_event_loop(int retcode)
{
  _app_impl->exit_event_loop(this, retcode);
}

//--------------------------------------------------------------------------------------------------

void App::set_view_for_identifier(mforms::View *view, const std::string &identifier)
{
  _view_by_identifier[identifier] = view;
}

//--------------------------------------------------------------------------------------------------

mforms::View *App::get_view_for_identifier(const std::string &identifier)
{  
  if (_view_by_identifier.find(identifier) == _view_by_identifier.end())
    return _view_by_identifier[identifier];
  return 0;
}

//--------------------------------------------------------------------------------------------------

void App::view_destroyed(View *data)
{
  for (std::map<std::string, View*>::iterator i = _view_by_identifier.begin(); 
       i != _view_by_identifier.end(); ++i)
  {
    if (i->second == data)
    {
      _view_by_identifier.erase(i);
    }
  }
}

//--------------------------------------------------------------------------------------------------

Color App::get_system_color(SystemColor type)
{
  return _app_impl->get_system_color(type);
}

//--------------------------------------------------------------------------------------------------
