/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _MFORMS_TASK_SIDEBAR_H_
#define _MFORMS_TASK_SIDEBAR_H_

/**
 * mforms interface to the advanced sidebar, which implements an iTunes like interface.
 */
#include <mforms/box.h>
#include <mforms/app.h>

#include <vector>

#ifndef DOXYGEN_SHOULD_SKIP_THIS

namespace wb {
  class LiveSchemaTree; // The tree model for the schema treeview.
};

namespace mforms {

  class GRTTreeView;
  class TaskSidebar;
  class TextEntry;

#ifndef SWIG
  struct TaskSidebarImplPtrs
  {
    TaskSidebar* (*create)(); // Temporary solution. This factory method should go into the ControlFactory.
  };
#endif

  class MFORMS_EXPORT TaskSidebar : public Box
  {
  private:
    boost::signals2::signal<void (const std::string&)> _on_section_command;

  protected:
    TaskSidebar();

  public:
    static TaskSidebar* create(); // Create an instance from the factory

    virtual void refresh_model() = 0;
    virtual void set_schema_model(wb::LiveSchemaTree* model) = 0;
    virtual void set_filtered_schema_model(wb::LiveSchemaTree* model) = 0;

    virtual GRTTreeView *get_schema_tree()= 0;
    virtual TextEntry *get_filter_entry()= 0;

    virtual int add_section(const std::string& name) = 0;
    virtual void remove_section(const std::string& name) = 0;
    virtual int add_section_entry(const std::string& section, const std::string& title,
      const std::string& icon, const std::string& command, bool as_link) = 0;
    virtual void remove_section_entry(const std::string& section, const std::string& entry) = 0;
    virtual void set_collapse_states(const std::string& data)= 0;
    virtual std::string get_collapse_states()= 0;

    virtual void clear_sections() = 0;
    virtual void clear_section(const std::string& section) = 0;
    virtual void set_selection_color (const std::string& color) = 0;
    virtual void set_selection_color (const mforms::SystemColor color) = 0;
    virtual boost::signals2::signal<void (const std::string&)>* signal_filter_changed() = 0;

    virtual void expand_schema(int schema_index) = 0;
    virtual void restore_expanded_nodes() = 0;

    virtual int select_entry(const std::string& section, const std::string& title) = 0;
    virtual void clear_selection() = 0;

    boost::signals2::signal<void (const std::string&)>* on_section_command() { return &_on_section_command;};

    static void register_factory(TaskSidebar* (*create)());
  private:
  };
}

#endif // !DOXYGEN_SHOULD_SKIP_THIS
#endif // _MFORMS_TASK_SIDEBAR_H_
