/* 
 * Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#include "stdafx.h"

using namespace mforms;


ScrollPanel::ScrollPanel(ScrollPanelFlags flags)
  : Container()
{
  _spanel_impl= &ControlFactory::get_instance()->_spanel_impl;

  _spanel_impl->create(this, flags);
}



void ScrollPanel::add(View *child)
{
  child->retain();
  add_subview(child);
  child->set_parent(this);
  _spanel_impl->add(this, child);
  child->show();
  
  _content = child;
}


void ScrollPanel::remove()
{
  if (_content)
  {
    remove_subview(_content);
    _spanel_impl->remove(this);
    _content->release();
    _content = 0;
  }
}


void ScrollPanel::set_visible_scrollers(bool vertical, bool horizontal)
{
  _spanel_impl->set_visible_scrollers(this, vertical, horizontal);
}


void ScrollPanel::set_autohide_scrollers(bool flag)
{
  _spanel_impl->set_autohide_scrollers(this, flag);
}


void ScrollPanel::scroll_to_view(View* child)
{
  if (_spanel_impl->scroll_to_view)
    return _spanel_impl->scroll_to_view(this, child);

  throw std::logic_error("ScrollPanel::scroll_to_view: not implemented");
}

