#ifndef _WB_STORED_NOTE_EDITOR_H_
#define _WB_STORED_NOTE_EDITOR_H_

#include "wb_editor_backend_public_interface.h"
#include "grt/editor_base.h"
#include "sqlide/sql_editor_be.h"
#include "grts/structs.workbench.model.h"
#include <memory>


class WBEDITOR_BACKEND_PUBLIC_FUNC StoredNoteEditorBE : public bec::BaseEditor
{
  GrtStoredNoteRef _note;

public:
  StoredNoteEditorBE(bec::GRTManager *grtm, const GrtStoredNoteRef &note);
  virtual GrtObjectRef get_object() { return _note; }
  
  bool is_script();
  
  virtual Sql_editor::Ref get_sql_editor();

  void set_text(const std::string &text);
  std::string get_text(bool &isutf8);

  void set_name(const std::string &name);
  std::string get_name();

  bool load_file(const std::string &name);
  bool save_file(const std::string &name);

protected:
  Sql_editor::Ref _sql_editor;
};

#endif /* _WB_STORED_NOTE_EDITOR_H_ */
