#ifndef _NEXP_COMMAND_H
#define _NEXP_COMMAND_H

/* nexp_command.h -- Definitions for netexpect commands.

   Copyright (C) 2007 Eloy Paris
    Copyright (C) 1987-2002 Don Libes <libes@cme.nist.gov>,
	National Institute of Standards and Technology <http://www.nist.gov/>

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Definitions for creating commands.
 */

#define NEXP_NOPREFIX 1 /* don't define with "nexp_" prefix */
#define NEXP_REDEFINE 2 /* stomp on old commands with same name */

struct nexp_cmd_data {
    char *name;
    Tcl_ObjCmdProc *objproc;
    Tcl_CmdProc *proc;
    ClientData data;
    int flags;
};

extern void nexp_create_commands(Tcl_Interp *, struct nexp_cmd_data *);
extern void nexp_init_cmds _ANSI_ARGS_((Tcl_Interp *));

#endif /* _NEXP_COMMAND_H */
