//                                               -*- C++ -*-
/**
 *  @file  InterfaceObject.hxx
 *  @brief The abstract class InterfaceObject defines the GetImplementation method
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: InterfaceObject.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_INTERFACEOBJECT_HXX
#define OPENTURNS_INTERFACEOBJECT_HXX

#include "OTprivate.hxx"
#include "Pointer.hxx"
#include "Object.hxx"
#include "PersistentObject.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class InterfaceObject
 *
 * @brief The top-most class that allows the construction of the Interface/Implementation design pattern
 * @internal
 * @see TypedInterfaceObject
 *
 * InterfaceObject defines a pure virtual method getImplementation
 * that returns a pointer to a PersistentObject. See TypedInterfaceObject for concrete implementation.
 */

class InterfaceObject
  : public Object
{
  CLASSNAME;
public:

  typedef Pointer<PersistentObject>   ImplementationAsPersistentObject;

  /** @copydoc Object::__repr__() const */
  virtual String __repr__() const;

  /** @copydoc Object::__str__() const */
  virtual String __str__(const String & offset = "") const;

  /** Returns a pointer to the underlying implementation object viewed as a PersistentObject
   * @internal
   */
  virtual ImplementationAsPersistentObject getImplementationAsPersistentObject() const = 0 ;

  /** Sets the pointer to the underlying implementation object
   * @internal
   */
  virtual void setImplementationAsPersistentObject(const ImplementationAsPersistentObject & obj) = 0;

  /** Id accessor */
  Id getId() const;

  /** Name accessor */
  virtual void setName(const String & name);
  virtual String getName() const;

  /** Method save() stores the object through the StorageManager
   * @internal
   */
  void save(StorageManager & mgr, const String & label) const;

  /** Method save() stores the object through the StorageManager
   * @internal
   */
  void save(StorageManager & mgr) const;

}; /* class InterfaceObject */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_INTERFACEOBJECT_HXX */
