//                                               -*- C++ -*-
/**
 *  @file  LinearModelFactory.hxx
 *  @brief Factory for linear model
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-07 15:30:42 +0100 (Wed, 07 Mar 2012) $
 *  Id:      $Id: LinearModelFactory.hxx 2411 2012-03-07 14:30:42Z lebrun $
 */
#ifndef OPENTURNS_LINEARMODELFACTORY_HXX
#define OPENTURNS_LINEARMODELFACTORY_HXX

#include "LinearModel.hxx"
#include "NumericalSample.hxx"
#include "ResourceMap.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class LinearModelFactory
 *
 * Factory for linear model
 */

class LinearModelFactory
{
public:

  typedef PersistentCollection<ConfidenceInterval> ConfidenceIntervalPersistentCollection;
  typedef PersistentCollection<NumericalScalar>    NumericalScalarPersistentCollection;

  /** Default constructor */
  LinearModelFactory();

  /** LinearModel creation */
  LinearModel build(const NumericalSample & samplePred,
                    const NumericalSample & sampleLab,
                    const NumericalScalar levelValue = ResourceMap::GetAsNumericalScalar( "LinearModelFactory-DefaultLevelValue" )) const;

}; /* class LinearModelFactory */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_LINEARMODELFACTORY_HXX */
