//                                               -*- C++ -*-
/**
 *  @file  OTStat.hxx
 *  @brief The external header file of Open TURNS for subdir Stat
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-02-11 16:49:59 +0100 (Wed, 11 Feb 2009) $
 *  Id:      $Id: OTStat.hxx 1129 2009-02-11 15:49:59Z dutka $
 */

#ifndef OPENTURNS_OTSTAT_HXX
#define OPENTURNS_OTSTAT_HXX

#include "Compact.hxx"
#include "ConfidenceInterval.hxx"
#include "CorrelationAnalysis.hxx"
#include "CorrelationMatrix.hxx"
#include "CovarianceMatrix.hxx"
#include "csv_parser_state.hxx"
#include "Full.hxx"
#include "ReverseHaltonSequence.hxx"
#include "FaureSequence.hxx"
#include "HaltonSequence.hxx"
#include "HaselgroveSequence.hxx"
#include "HistoryStrategy.hxx"
#include "HistoryStrategyImplementation.hxx"
#include "Last.hxx"
#include "LinearModelFactory.hxx"
#include "LinearModel.hxx"
#include "LowDiscrepancySequence.hxx"
#include "LowDiscrepancySequenceImplementation.hxx"
#include "Null.hxx"
#include "NumericalSample.hxx"
#include "NumericalSampleImplementation.hxx"
#include "TimeSeries.hxx"
#include "TimeSeriesImplementation.hxx"
#include "ProcessSample.hxx"
#include "RandomGenerator.hxx"
#include "SecondOrderModelImplementation.hxx"
#include "SecondOrderModel.hxx"
#include "ExponentialCauchy.hxx"
#include "SensitivityAnalysis.hxx"
#include "SobolSequence.hxx"
#include "TestResult.hxx"
#include "TimeSeries.hxx"
#include "FilteringWindowsImplementation.hxx"
#include "FilteringWindows.hxx"
#include "Hamming.hxx"
#include "Hanning.hxx"
#include "SpectralModel.hxx"
#include "CovarianceModelImplementation.hxx"
#include "SpectralModelImplementation.hxx"
#include "CovarianceModel.hxx"
#include "StationaryCovarianceModel.hxx"
#include "SpectralModelFactoryImplementation.hxx"
#include "SpectralModelFactory.hxx"
#include "UserDefinedSpectralModel.hxx"
#include "WelchFactory.hxx"
#include "ExponentialModel.hxx"
#include "CauchyModel.hxx"

#endif /* OPENTURNS_OTSTAT_HXX */
