//                                               -*- C++ -*-
/**
 *  @file  ExperimentImplementation.hxx
 *  @brief Abstract top-level view of an experiment plane
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu, 26 jun 2008) $
 *  Id:      $Id: ExperimentImplementation.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_EXPERIMENTIMPLEMENTATION_HXX
#define OPENTURNS_EXPERIMENTIMPLEMENTATION_HXX

#include "PersistentObject.hxx"
#include "Pointer.hxx"
#include "NumericalSample.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class ExperimentImplementation
 *
 * The class describes the probabilistic concept of experimentImplementation plan
 */
class ExperimentImplementation
  : public PersistentObject
{
  CLASSNAME;
public:

  typedef Pointer<ExperimentImplementation> Implementation;

  /** Default constructor */
  explicit ExperimentImplementation(const String & name = DefaultName);

  /** Virtual constructor */
  virtual ExperimentImplementation * clone() const;

  /** String converter */
  virtual String __repr__() const;

  /* Here is the interface that all derived class must implement */

  /** Sample generation */
  virtual NumericalSample generate();

protected:

private:

}; /* class ExperimentImplementation */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_EXPERIMENTIMPLEMENTATION_HXX */
