//                                               -*- C++ -*-
/**
 *  @file  Event.cxx
 *  @brief The class that implements all random vectors
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: Event.cxx 2392 2012-02-17 18:35:43Z schueller $
 */

#include "Event.hxx"
#include "CompositeRandomVector.hxx"
#include "Less.hxx"

BEGIN_NAMESPACE_OPENTURNS



CLASSNAMEINIT(Event);

/* Default constructor for save/load */
Event::Event()
  : RandomVector(CompositeRandomVector(NumericalMathFunction("x", "x"), RandomVector(NumericalPoint(1, 0.0))), Less(), 0.0)
{
  // Nothing to do
}

/* Constructor from RandomVector */
Event::Event(const RandomVector & antecedent,
             const ComparisonOperator & op,
             const NumericalScalar threshold,
             const String & name)
  : RandomVector(antecedent, op, threshold, name)
{
  // Nothing to do
}

/* Constructor from RandomVector */
Event::Event(const RandomVector & antecedent,
             const Domain & domain,
             const String & name)
  : RandomVector(antecedent, domain, name)
{
  // Nothing to do
}


/* Constructor from RandomVector */
Event::Event(const Process & process,
             const Domain & domain,
             const String & name)
  : RandomVector(process, domain, name)
{
  // Nothing to do
}

/* String converter */
String Event::__repr__() const {
  OSS oss;
  oss << "class=" << Event::GetClassName()
      << " name=" << getName()
      << " implementation=" << getImplementation()->__repr__();
  return oss;
}

/* String converter */
String Event::__str__(const String & offset) const {
  return __repr__();
}

END_NAMESPACE_OPENTURNS
