//                                               -*- C++ -*-
/**
 *  @file  WhiteNoise.hxx
 *  @brief A class which implements the WhiteNoise process
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: WhiteNoise.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_WHITENOISE_HXX
#define OPENTURNS_WHITENOISE_HXX

#include "ProcessImplementation.hxx"
#include "Process.hxx"
#include "Pointer.hxx"
#include "Distribution.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class WhiteNoise
 *
 * An interface class for composite White Noise
 */
class WhiteNoise
  : public ProcessImplementation
{
  CLASSNAME;

public:

  /** Some typedefs to ease reading */

  /** Default constructor */
  WhiteNoise(const String & name = DefaultName);

  /** Standard constructor */
  WhiteNoise(const Distribution & distribution,
             const String & name = DefaultName);

  /** Standard constructor */
  WhiteNoise(const Distribution & distribution,
             const RegularGrid & timeGrid,
             const String & name = DefaultName);

  /** Virtual constructor */
  WhiteNoise * clone() const;

  /** String converter */
  String __repr__() const;

  /** Is the underlying stationary ? */
  Bool isStationary() const;

  /** Is the underlying a Normal process ? */
  Bool isNormal() const;

  /** Realization accessor */
  TimeSeries getRealization() const;

  /** Continuation of the last realization on a given number of steps */
  using ProcessImplementation::getFuture;
  TimeSeries getFuture(const UnsignedLong stepNumber) const;

  /** Get the marginal process corresponding to the i-th marginal component */
  WhiteNoise * getMarginalProcess(const UnsignedLong i) const;

  /** Get the marginal process corresponding to indices components */
  WhiteNoise * getMarginalProcess(const Indices & indices) const;

  /** Distribution accessor */
  Distribution getDistribution() const;

  /** Distribution accessor */
  void setDistribution(const Distribution & distribution);

  /** Method save() stores the object through the StorageManager */
  void save(Advocate & adv) const;

  /** Method load() reloads the object from the StorageManager */
  void load(Advocate & adv);

private:

  /** The distribution of the WhiteNoise */
  Distribution distribution_;

}; /* class WhiteNoise */
END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_WHITENOISE_HXX */
