// SWIG file Drawable.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2012-01-02 11:44:01 +0100 (Mon, 02 Jan 2012) $
// Id : $Id: Drawable.i 2287 2012-01-02 10:44:01Z schueller $

%{
#include "Drawable.hxx"

namespace OT { 

  template <>
  struct traitsPythonType<OT::Drawable>
  {
    typedef _PyObject_ Type;
  };

  template <>
  inline
  OT::Drawable
  convert<_PyObject_,OT::Drawable>(PyObject * pyObj)
  {
    check<_PyObject_>( pyObj );
    void * ptr = 0;
    if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIG_TypeQuery("OT::DrawableImplementation *"), 0 |  0 ))) {
      OT::DrawableImplementation * p_di = reinterpret_cast< OT::DrawableImplementation * >( ptr );
      return *p_di;

    }
  }


} /* namespace OT */

%}

%template(DrawableImplementationTypedInterfaceObject)           OT::TypedInterfaceObject<OT::DrawableImplementation>;

%typemap(in) const OT::Drawable & {
  if (! SWIG_IsOK((SWIG_ConvertPtr($input, (void **) &$1, $1_descriptor, 0)))) {
    const OT::DrawableImplementation * temp;
    if (! SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &temp, SWIGTYPE_p_OT__DrawableImplementation, 0))) {
      return NULL;
    }
    $1 = new OT::Drawable( *temp );
  }
}

%typemap(typecheck,precedence=SWIG_TYPECHECK_POINTER) const OT::Drawable & {
  const OT::DrawableImplementation * temp;
  $1 = SWIG_IsOK(SWIG_ConvertPtr($input, NULL, $1_descriptor, 0)) || SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &temp, SWIGTYPE_p_OT__DrawableImplementation, 0));
}

%include Drawable.hxx
namespace OT{  

%extend Drawable {

Drawable(const Drawable & other) { return new OT::Drawable(other); }

Drawable(PyObject * pyObj)
{
 return new OT::Drawable( OT::convert<OT::_PyObject_,OT::Drawable>(pyObj) );
}

}
}
