// SWIG file SVMKernel.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2012-01-02 11:44:01 +0100 (Mon, 02 Jan 2012) $
// Id : $Id: SVMKernel.i 2287 2012-01-02 10:44:01Z schueller $

%{
#include "SVMKernel.hxx"

namespace OT { 

  template <>
  struct traitsPythonType<OT::SVMKernel>
  {
    typedef _PyObject_ Type;
  };


  template <>
  inline
  OT::SVMKernel
  convert<_PyObject_,OT::SVMKernel>(PyObject * pyObj)
  {
    void * ptr = 0;
    if (! SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIG_TypeQuery("OT::SVMKernelImplementation *"), 0 |  0 )))
      throw OT::InvalidArgumentException(HERE) << "Object passed as argument is not an object convertible to an SVMKernelImplementation";
    OT::SVMKernelImplementation * p_ki = reinterpret_cast< OT::SVMKernelImplementation * >( ptr );
    return *p_ki;
  }

} /* namespace OT */


%}

%template(SVMKernelImplementationTypedInterfaceObject)           OT::TypedInterfaceObject<OT::SVMKernelImplementation>;

%typemap(in) const OT::SVMKernel & {
  if (! SWIG_IsOK((SWIG_ConvertPtr($input, (void **) &$1, $1_descriptor, 0)))) {
    const OT::SVMKernelImplementation * temp;
    if (! SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &temp, SWIGTYPE_p_OT__SVMKernelImplementation, 0))) {
      return NULL;
    }
    $1 = new OT::SVMKernel( *temp );
  }
}

%typemap(typecheck,precedence=SWIG_TYPECHECK_POINTER) const OT::SVMKernel & {
  const OT::SVMKernelImplementation * temp;
  $1 = SWIG_IsOK(SWIG_ConvertPtr($input, NULL, $1_descriptor, 0)) || SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &temp, SWIGTYPE_p_OT__SVMKernelImplementation, 0));
}

%include SVMKernel.hxx
namespace OT{  

%extend SVMKernel {

SVMKernel(const SVMKernel & other) { return new OT::SVMKernel(other); }

}
}
