#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()

class FUNC(OpenTURNSPythonFunction):

  def __init__(self):
    OpenTURNSPythonFunction.__init__(self, 2, 1)
    self.setInputDescription( ['R','S'] )
    self.setOutputDescription( ['T'] )

  def _exec(self, X):
    #print X
    Y = [0]
    Y[0] = X[0] + X[1]
    #print Y
    return Y

F=FUNC()
print F.getInputDimension(), F.getOutputDimension()

print F( (10,5) )

print F( ((10,5), (6,7)) )

try :

  #Instance creation
  myFunc = NumericalMathFunction( F )

  #Copy constructor
  newFunc = NumericalMathFunction(myFunc)

  print "myFunc input dimension=", myFunc.getInputDimension()
  print "myFunc output dimension=", myFunc.getOutputDimension()

  inPt = NumericalPoint(2, 2.)
  print repr(inPt)

  outPt = myFunc ( inPt )
  print repr(outPt)
  
  outPt = myFunc ( (10., 11.) )
  print repr(outPt)

  inSample = NumericalSample(10, 2)
  for i in range(10):
    inSample[i] = NumericalPoint( (i,i) )
  print repr(inSample)

  outSample = myFunc ( inSample )
  print repr(outSample)

  outSample = myFunc ( ((100.,100.), (101.,101.), (102.,102.)) )
  print repr(outSample)

  # Test cache behavior
  myFunc.enableCache()
  print 'calls =', myFunc.getEvaluationCallsNumber(), 'hits = ', myFunc.getCacheHits()
  outPt = myFunc ( inPt )
  print 'T =', repr(outPt)
  print 'calls =', myFunc.getEvaluationCallsNumber(), 'hits = ', myFunc.getCacheHits()
  outPt = myFunc ( inPt )
  print 'T =', repr(outPt)
  print 'calls =', myFunc.getEvaluationCallsNumber(), 'hits = ', myFunc.getCacheHits()
  outSample = myFunc ( inSample )
  print 'T =', repr(outSample)
  print 'calls =', myFunc.getEvaluationCallsNumber(), 'hits = ', myFunc.getCacheHits()
  outSample = myFunc ( inSample )
  print 'T =', repr(outSample)
  print 'calls =', myFunc.getEvaluationCallsNumber(), 'hits = ', myFunc.getCacheHits()

except :
  import sys
  print "t_NumericalMathFunction_python.py", sys.exc_type, sys.exc_value
