#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :
    distribution = Trapezoidal(1.0, 2.3, 4.5, 5.0)
    size = 10000
    sample = distribution.getNumericalSample(size)
    factory = TrapezoidalFactory()
    estimatedDistribution = factory.build(sample)
    print "distribution=", repr(distribution)
    oldPrecision = PlatformInfo.GetNumericalPrecision()
    PlatformInfo.SetNumericalPrecision(4)
    print "Estimated distribution=", repr(estimatedDistribution)
    PlatformInfo.SetNumericalPrecision(oldPrecision)
except :
    import sys
    print "t_TrapezoidalFactory.py", sys.exc_type, sys.exc_value
