///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __POSCAR_PARSER_H
#define __POSCAR_PARSER_H

#include <core/Core.h>
#include "../AtomsFileParser.h"

namespace AtomViz {

/**
 * \brief This file import class can read POSCAR atom files as used
 *        by the VASP DFT code.
 * 
 * \sa POSCARWriter
 * \author Alexander Stukowski
 */
class ATOMVIZ_DLLEXPORT POSCARParser : public AtomsFileParser
{
public:
	/// Default constructor.
	POSCARParser(bool isLoading = false) : AtomsFileParser(isLoading) {}

	/// \brief Reads an atomic data set from the input file.
	virtual EvaluationStatus loadAtomsFile(AtomsObject* destination, int movieFrame = 0, bool suppressDialogs = false);
	
private:

	Q_OBJECT
	DECLARE_SERIALIZABLE_PLUGIN_CLASS(POSCARParser)
};

};	// End of namespace AtomViz

#endif // __POSCAR_PARSER_H
