///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_UI_EVENTFILTER_H
#define __OVITO_UI_EVENTFILTER_H

#include <core/Core.h>

namespace Core {
	
class MainFrame;		// defined in MainFrame.h

/******************************************************************************
* Abstract base class for plugin classes that want to intercept/process
* the raw GUI events of the application.
******************************************************************************/
class CORE_DLLEXPORT UIEventFilter : public PluginClass
{
protected:
	/// The default constructor.
	UIEventFilter() : PluginClass() {}
	
public:

	/// This will be called by the system after the main window of the application has been initialized.
	virtual void mainWindowCreated(MainFrame* mainWindow) {}
	
#if defined(Q_WS_X11)

	/// Handles X11 GUI events.
	/// Return true if you want to stop the event from being processed. 
	/// Return false for normal event dispatching. 
	/// The default implementation returns false.
	virtual bool x11EventFilter(XEvent* event) { return false; }

#elif defined(Q_WS_WIN)

	/// Handles Windows GUI events.
	/// Return true if you want to stop the event from being processed. 
	/// Return false for normal event dispatching. 
	/// The default implementation returns false.
	virtual bool winEventFilter(MSG * msg, long * result) { return false; }

#elif defined(Q_WS_MAC)

	/// Handles Carbon GUI events.
	/// Return true if you want to stop the event from being processed. 
	/// Return false for normal event dispatching. 
	/// The default implementation returns false.
	virtual bool macEventFilter(EventHandlerCallRef caller, EventRef event) { return false; }

#endif

private:
	Q_OBJECT	
	DECLARE_ABSTRACT_PLUGIN_CLASS(UIEventFilter)
};

};

#endif // __OVITO_UI_EVENTFILTER_H
