///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_MESH_H
#define __OVITO_MESH_H

/******************************************************************************
* The Base module is required by the Mesh module.
******************************************************************************/
#include <base/Base.h>
#include <base/utilities/Color.h>
#include <base/linalg/LinAlg.h>

/******************************************************************************
* Define the DLL export macros.
******************************************************************************/
#ifdef MAKING_MODULE_MESH
#define MESH_DLLEXPORT DLL_EXPORT_DECL
#else
#define MESH_DLLEXPORT DLL_IMPORT_DECL
#endif

// Make all classes of the Mesh namespace available by default.
namespace Mesh {};
using namespace Mesh;

#endif // __OVITO_MESH_H
