<?php

require_once 'File/Iterator/Autoload.php';
require_once 'PHP/CodeCoverage/Autoload.php';
require_once 'PHP/Timer/Autoload.php';
require_once 'PHPUnit/Framework/MockObject/Autoload.php';
require_once 'SebastianBergmann/Diff/autoload.php';
require_once 'SebastianBergmann/Environment/Runtime.php';
require_once 'SebastianBergmann/Exporter/autoload.php';
require_once 'SebastianBergmann/Version/autoload.php';
require_once 'SebastianBergmann/Comparator/autoload.php';
require_once 'Doctrine/Instantiator/autoload.php';

spl_autoload_register(
  function ($class)
  {
      static $classes = NULL;
      static $path    = NULL;

      if ($classes === NULL) {
          $classes = array(
              ___CLASSLIST___
          );

          $path = dirname(__FILE__);
      }

      $cn = strtolower($class);

      if (isset($classes[$cn])) {
          require $path . $classes[$cn];
      }
  }
);

// Symfony Yaml autoloader
spl_autoload_register(
  function ($class) {
      if (0 === strpos(ltrim($class, '/'), 'Symfony\Component\Yaml')) {
          $file = sprintf(
            'Symfony/Component/Yaml%s.php',

            substr(
              str_replace('\\', '/', $class),
              strlen('Symfony\Component\Yaml')
            )
          );

          if (stream_resolve_include_path($file)) {
              require_once $file;
          }
      }
  }
);

if (stream_resolve_include_path('PHP/Invoker/Autoload.php')) {
    require_once 'PHP/Invoker/Autoload.php';
}

if (stream_resolve_include_path('PHPUnit/Extensions/Database/Autoload.php')) {
    require_once 'PHPUnit/Extensions/Database/Autoload.php';
}

if (stream_resolve_include_path('PHPUnit/Extensions/SeleniumCommon/Autoload.php')) {
    require_once 'PHPUnit/Extensions/SeleniumCommon/Autoload.php';
}

else if (stream_resolve_include_path('PHPUnit/Extensions/SeleniumTestCase/Autoload.php')) {
    require_once 'PHPUnit/Extensions/SeleniumTestCase/Autoload.php';
}

if (stream_resolve_include_path('PHPUnit/Extensions/Story/Autoload.php')) {
    require_once 'PHPUnit/Extensions/Story/Autoload.php';
}
