/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.McIDASUtil;
import java.util.Date;

public class WxTextProduct {
    private String source = "";
    private int numBytes = 0;
    private int location = 0;
    private int day = 0;
    private int time = 0;
    private String wmo = "";
    private String wstn = "";
    private String apro = "";
    private String astn = "";
    private String text = "";
    private Date date = new Date();

    public WxTextProduct(byte[] header) {
        int[] values = McIDASUtil.bytesToIntegerArray(header, 0, 13);
        this.source = McIDASUtil.intBitsToString(values[0]);
        this.numBytes = values[1];
        this.location = values[2];
        this.day = values[10];
        this.time = values[3];
        String wmoBase = McIDASUtil.intBitsToString(values[4]);
        int wmoNum = values[5];
        this.wmo = wmoBase + (wmoNum < 10 ? "0" : "") + wmoNum;
        this.wstn = McIDASUtil.intBitsToString(values[6]);
        this.apro = McIDASUtil.intBitsToString(values[7]);
        this.astn = McIDASUtil.intBitsToString(values[8]);
        this.date = new Date(McIDASUtil.mcDayTimeToSecs(this.day, this.time) * 1000L);
    }

    public void addText(String newText) {
        this.text = this.text + newText;
    }

    public void setText(String newText) {
        this.text = newText;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public int getDay() {
        return this.day;
    }

    public int getTime() {
        return this.time;
    }

    public String getWmo() {
        return this.wmo;
    }

    public String getWstn() {
        return this.wstn;
    }

    public String getApro() {
        return this.apro;
    }

    public String getAstn() {
        return this.astn;
    }

    public Date getDate() {
        return this.date;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SOU    nb  location   day    time  WMO     WSTN APRO ASTN\n");
        buf.append("---  ----  -------- ------- ------ ------- ---- ---- ----\n");
        buf.append(this.source);
        buf.append(this.numBytes);
        buf.append(" ");
        buf.append(this.location);
        buf.append(" ");
        buf.append(this.day);
        buf.append(" ");
        buf.append(this.time);
        buf.append(" ");
        buf.append(this.wmo);
        buf.append("  ");
        buf.append(this.wstn);
        buf.append(" ");
        buf.append(this.apro);
        buf.append(" ");
        buf.append(this.astn);
        return buf.toString();
    }
}

