from constants_palette import palette_dict

import sys

write = sys.stdout.write

s = len(palette_dict)

palettes = sys.argv[1]
pal_lex_def = sys.argv[2]
pal_lex_init = sys.argv[3]

print "palettes=", palettes, " pal_lex_def=", pal_lex_def, " pal_lex_init=", pal_lex_init

palettes_file = open(palettes, "w")
pal_lex_def_file = open(pal_lex_def, "w")
pal_lex_init_file = open(pal_lex_init, "w")

palettes_file.write("""
/* This file palettes.h is automatically generated using the convert_palettes.py script.
   This script takes the palettes data in constnts.py and converts it into C array
   definitions, which are then used.
   */
""")

palettes_file.write("int NUMBER_OF_PALETTES=%d;\n" % len(palette_dict))

palettes_file.write("char palette_prefix[%s] = { " % len(palette_dict))

it = iter(palette_dict.keys())
p = it.next()

palettes_file.write("'%c'" % palette_dict[p][0] )
pal_lex_def_file.write("ov_word lex_%s;\n" % p)
pal_lex_init_file.write("LEX_PALETTE(%s,%d);\n" % (p, 0))
pl = 1
for p in it:
    palettes_file.write(", '%c'" % palette_dict[p][0] )
    pal_lex_def_file.write("ov_word lex_%s;\n" % p)
    pal_lex_init_file.write("LEX_PALETTE(%s,%d);\n" % (p, pl))
    pl = pl + 1
palettes_file.write(" };\n")

palettes_file.write("""
/* palette_data : digits, first, last for each palette */
""")

palettes_file.write("int palette_data[%s] = { " % (len(palette_dict)*3))

pl = 0

it = iter(palette_dict.keys())
p = it.next()
pd = palette_dict[p]
palettes_file.write("%d, %d, %d" % (pd[1], pd[2], pd[3]) )
for p in it:
    pd = palette_dict[p]
    palettes_file.write(", %d, %d, %d" % (pd[1], pd[2], pd[3]) )
palettes_file.write(" };\n")
