# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IntentModel(Model):
    """An intent detected from the utterance.

    :param intent: Name of the intent, as defined in LUIS.
    :type intent: str
    :param score: Associated prediction score for the intent (float).
    :type score: float
    """

    _validation = {
        'score': {'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'intent': {'key': 'intent', 'type': 'str'},
        'score': {'key': 'score', 'type': 'float'},
    }

    def __init__(self, *, intent: str=None, score: float=None, **kwargs) -> None:
        super(IntentModel, self).__init__(**kwargs)
        self.intent = intent
        self.score = score
