# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .dataset_storage_format import DatasetStorageFormat


class TextFormat(DatasetStorageFormat):
    """The data stored in text format.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param serializer: Serializer. Type: string (or Expression with resultType
     string).
    :type serializer: object
    :param deserializer: Deserializer. Type: string (or Expression with
     resultType string).
    :type deserializer: object
    :param type: Constant filled by server.
    :type type: str
    :param column_delimiter: The column delimiter. Type: string (or Expression
     with resultType string).
    :type column_delimiter: object
    :param row_delimiter: The row delimiter. Type: string (or Expression with
     resultType string).
    :type row_delimiter: object
    :param escape_char: The escape character. Type: string (or Expression with
     resultType string).
    :type escape_char: object
    :param quote_char: The quote character. Type: string (or Expression with
     resultType string).
    :type quote_char: object
    :param null_value: The null value string. Type: string (or Expression with
     resultType string).
    :type null_value: object
    :param encoding_name: The code page name of the preferred encoding. If
     miss, the default value is ΓÇ£utf-8ΓÇ¥, unless BOM denotes another Unicode
     encoding. Refer to the ΓÇ£NameΓÇ¥ column of the table in the following
     link to set supported values:
     https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string
     (or Expression with resultType string).
    :type encoding_name: object
    :param treat_empty_as_null: Treat empty column values in the text file as
     null. The default value is true. Type: boolean (or Expression with
     resultType boolean).
    :type treat_empty_as_null: object
    :param skip_line_count: The number of lines/rows to be skipped when
     parsing text files. The default value is 0. Type: integer (or Expression
     with resultType integer).
    :type skip_line_count: object
    :param first_row_as_header: When used as input, treat the first row of
     data as headers. When used as output,write the headers into the output as
     the first row of data. The default value is false. Type: boolean (or
     Expression with resultType boolean).
    :type first_row_as_header: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'serializer': {'key': 'serializer', 'type': 'object'},
        'deserializer': {'key': 'deserializer', 'type': 'object'},
        'type': {'key': 'type', 'type': 'str'},
        'column_delimiter': {'key': 'columnDelimiter', 'type': 'object'},
        'row_delimiter': {'key': 'rowDelimiter', 'type': 'object'},
        'escape_char': {'key': 'escapeChar', 'type': 'object'},
        'quote_char': {'key': 'quoteChar', 'type': 'object'},
        'null_value': {'key': 'nullValue', 'type': 'object'},
        'encoding_name': {'key': 'encodingName', 'type': 'object'},
        'treat_empty_as_null': {'key': 'treatEmptyAsNull', 'type': 'object'},
        'skip_line_count': {'key': 'skipLineCount', 'type': 'object'},
        'first_row_as_header': {'key': 'firstRowAsHeader', 'type': 'object'},
    }

    def __init__(self, additional_properties=None, serializer=None, deserializer=None, column_delimiter=None, row_delimiter=None, escape_char=None, quote_char=None, null_value=None, encoding_name=None, treat_empty_as_null=None, skip_line_count=None, first_row_as_header=None):
        super(TextFormat, self).__init__(additional_properties=additional_properties, serializer=serializer, deserializer=deserializer)
        self.column_delimiter = column_delimiter
        self.row_delimiter = row_delimiter
        self.escape_char = escape_char
        self.quote_char = quote_char
        self.null_value = null_value
        self.encoding_name = encoding_name
        self.treat_empty_as_null = treat_empty_as_null
        self.skip_line_count = skip_line_count
        self.first_row_as_header = first_row_as_header
        self.type = 'TextFormat'
