# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MongoDbCollectionSettings(Model):
    """Describes how an individual MongoDB collection should be migrated.

    :param can_delete: Whether the migrator is allowed to drop the target
     collection in the course of performing a migration. The default is true.
    :type can_delete: bool
    :param shard_key:
    :type shard_key: ~azure.mgmt.datamigration.models.MongoDbShardKeySetting
    :param target_rus: The RUs that should be configured on a CosmosDB target,
     or null to use the default. This has no effect on non-CosmosDB targets.
    :type target_rus: int
    """

    _attribute_map = {
        'can_delete': {'key': 'canDelete', 'type': 'bool'},
        'shard_key': {'key': 'shardKey', 'type': 'MongoDbShardKeySetting'},
        'target_rus': {'key': 'targetRUs', 'type': 'int'},
    }

    def __init__(self, *, can_delete: bool=None, shard_key=None, target_rus: int=None, **kwargs) -> None:
        super(MongoDbCollectionSettings, self).__init__(**kwargs)
        self.can_delete = can_delete
        self.shard_key = shard_key
        self.target_rus = target_rus
