/***************************************************************************
    qgsvaluemapwidget.cpp
     --------------------------------------
    Date                 : 5.1.2014
    Copyright            : (C) 2014 Matthias Kuhn
    Email                : matthias dot kuhn at gmx dot ch
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qgsvaluemapwidget.h"

QgsValueMapWidget::QgsValueMapWidget( QgsVectorLayer* vl, int fieldIdx, QWidget* editor, QWidget* parent )
    :  QgsEditorWidgetWrapper( vl, fieldIdx, editor, parent )
{
}


QVariant QgsValueMapWidget::value()
{
  QVariant v;

  if ( mComboBox )
    v = mComboBox->itemData( mComboBox->currentIndex() );

  return v;
}

QWidget* QgsValueMapWidget::createWidget( QWidget* parent )
{
  return new QComboBox( parent );
}

void QgsValueMapWidget::initWidget( QWidget* editor )
{
  mComboBox = qobject_cast<QComboBox*>( editor );

  if ( mComboBox )
  {
    const QgsEditorWidgetConfig cfg = config();
    QgsEditorWidgetConfig::ConstIterator it = cfg.constBegin();

    while ( it != cfg.constEnd() )
    {
      mComboBox->addItem( it.key(), it.value() );
      ++it;
    }
    connect( mComboBox, SIGNAL( currentIndexChanged( int ) ), this, SLOT( valueChanged() ) );
  }
}

void QgsValueMapWidget::setValue( const QVariant& value )
{
  if ( mComboBox )
    mComboBox->setCurrentIndex( mComboBox->findData( value ) );
}
