
/****************************************************************************
**
** Copyright (C) 2011 Christian B. Huebschle & George M. Sheldrick
** All rights reserved.
** Contact: chuebsch@moliso.de
**
** This file is part of the ShelXle
**
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file COPYING included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
**
****************************************************************************/
#ifndef QPEAKVIEW_H
#define QPEAKVIEW_H

#include <QWidget>

QT_BEGIN_NAMESPACE
class QPaintEvent;
class QResizeEvent;
class QSize;
class QWidget;
QT_END_NAMESPACE


class QPeakView : public QWidget
{
    Q_OBJECT
public:
    explicit QPeakView(QWidget *parent = 0);
    QSize sizeHint() const {
      return QSize(35,0);
    }
    double cutoff;
    void setMax(double m){
       // printf("%f %f %f\n",m,min,max);
        max=qMax(m,min+0.001);
    }
    void setMin(double m){
        min=qMin(m,max-0.001);
    }
signals:
    void cutOffChanged(double coff);
    void findQP(double co);

public slots:
    void qpeaksInFocus(double height);
    void unhide();

protected:
  void paintEvent(QPaintEvent *event);
  void	mousePressEvent ( QMouseEvent * event );
  void	mouseMoveEvent ( QMouseEvent * event );
  void	wheelEvent ( QWheelEvent * event );
private:
  void cutOffChange(double coff);
  QColor farbverlauf(double wrt);
  double min,max,oco;
  double focusHeight;
  int fohi;//font height
};

#endif // QPEAKVIEW_H
