/* Tombstone.c generated by valac 0.34.4, the Vala compiler
 * generated from Tombstone.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <time.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;

#define TYPE_TOMBSTONE_SOURCE_COLLECTION (tombstone_source_collection_get_type ())
#define TOMBSTONE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOMBSTONE_SOURCE_COLLECTION, TombstoneSourceCollection))
#define TOMBSTONE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOMBSTONE_SOURCE_COLLECTION, TombstoneSourceCollectionClass))
#define IS_TOMBSTONE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOMBSTONE_SOURCE_COLLECTION))
#define IS_TOMBSTONE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOMBSTONE_SOURCE_COLLECTION))
#define TOMBSTONE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOMBSTONE_SOURCE_COLLECTION, TombstoneSourceCollectionClass))

typedef struct _TombstoneSourceCollection TombstoneSourceCollection;
typedef struct _TombstoneSourceCollectionClass TombstoneSourceCollectionClass;
typedef struct _TombstoneSourceCollectionPrivate TombstoneSourceCollectionPrivate;

#define TYPE_TOMBSTONE (tombstone_get_type ())
#define TOMBSTONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOMBSTONE, Tombstone))
#define TOMBSTONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOMBSTONE, TombstoneClass))
#define IS_TOMBSTONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOMBSTONE))
#define IS_TOMBSTONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOMBSTONE))
#define TOMBSTONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOMBSTONE, TombstoneClass))

typedef struct _Tombstone Tombstone;
typedef struct _TombstoneClass TombstoneClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TOMBSTONE_ID (tombstone_id_get_type ())
typedef struct _TombstoneID TombstoneID;
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DIRECTORY_MONITOR (directory_monitor_get_type ())
#define DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitor))
#define DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))
#define IS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY_MONITOR))
#define IS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY_MONITOR))
#define DIRECTORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))

typedef struct _DirectoryMonitor DirectoryMonitor;
typedef struct _DirectoryMonitorClass DirectoryMonitorClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
typedef struct _TombstoneSourceCollectionAsyncScanData TombstoneSourceCollectionAsyncScanData;

#define TYPE_TOMBSTONED_FILE (tombstoned_file_get_type ())
#define TOMBSTONED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOMBSTONED_FILE, TombstonedFile))
#define TOMBSTONED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOMBSTONED_FILE, TombstonedFileClass))
#define IS_TOMBSTONED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOMBSTONED_FILE))
#define IS_TOMBSTONED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOMBSTONED_FILE))
#define TOMBSTONED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOMBSTONED_FILE, TombstonedFileClass))

typedef struct _TombstonedFile TombstonedFile;
typedef struct _TombstonedFileClass TombstonedFileClass;
typedef struct _TombstonedFilePrivate TombstonedFilePrivate;
typedef struct _ParamSpecTombstonedFile ParamSpecTombstonedFile;
typedef struct _DataObjectPrivate DataObjectPrivate;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;
typedef struct _TombstonePrivate TombstonePrivate;

#define TYPE_TOMBSTONE_ROW (tombstone_row_get_type ())
#define TOMBSTONE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOMBSTONE_ROW, TombstoneRow))
#define TOMBSTONE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOMBSTONE_ROW, TombstoneRowClass))
#define IS_TOMBSTONE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOMBSTONE_ROW))
#define IS_TOMBSTONE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOMBSTONE_ROW))
#define TOMBSTONE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOMBSTONE_ROW, TombstoneRowClass))

typedef struct _TombstoneRow TombstoneRow;
typedef struct _TombstoneRowClass TombstoneRowClass;

#define TOMBSTONE_TYPE_REASON (tombstone_reason_get_type ())
#define _tombstone_row_unref0(var) ((var == NULL) ? NULL : (var = (tombstone_row_unref (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_TOMBSTONE_TABLE (tombstone_table_get_type ())
#define TOMBSTONE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOMBSTONE_TABLE, TombstoneTable))
#define TOMBSTONE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOMBSTONE_TABLE, TombstoneTableClass))
#define IS_TOMBSTONE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOMBSTONE_TABLE))
#define IS_TOMBSTONE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOMBSTONE_TABLE))
#define TOMBSTONE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOMBSTONE_TABLE, TombstoneTableClass))

typedef struct _TombstoneTable TombstoneTable;
typedef struct _TombstoneTableClass TombstoneTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;
typedef struct _BackingFileStatePrivate BackingFileStatePrivate;
#define _tombstoned_file_unref0(var) ((var == NULL) ? NULL : (var = (tombstoned_file_unref (var), NULL)))
#define _backing_file_state_unref0(var) ((var == NULL) ? NULL : (var = (backing_file_state_unref (var), NULL)))
typedef struct _TombstoneRowPrivate TombstoneRowPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _TombstoneSourceCollection {
	DatabaseSourceCollection parent_instance;
	TombstoneSourceCollectionPrivate * priv;
};

struct _TombstoneSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
};

struct _TombstoneSourceCollectionPrivate {
	GeeHashMap* file_map;
};

typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, void* user_data);
struct _TombstoneID {
	gint64 id;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
struct _TombstoneSourceCollectionAsyncScanData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TombstoneSourceCollection* self;
	DirectoryMonitor* monitor;
	GCancellable* cancellable;
	Marker* marker;
	Marker* _tmp0_;
	GeeIterator* _object_it;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeIterator* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	gboolean _tmp6_;
	DataObject* object;
	GeeIterator* _tmp7_;
	gpointer _tmp8_;
	Tombstone* tombstone;
	DataObject* _tmp9_;
	Tombstone* _tmp10_;
	GFile* file;
	Tombstone* _tmp11_;
	GFile* _tmp12_;
	GFileInfo* info;
	DirectoryMonitor* _tmp13_;
	DirectoryMonitor* _tmp14_;
	GFile* _tmp15_;
	GFileInfo* _tmp16_;
	GFileInfo* _tmp17_;
	GFileInfo* _tmp18_;
	GFile* _tmp19_;
	GCancellable* _tmp20_;
	GFileInfo* _tmp21_;
	GFileInfo* _tmp22_;
	GError* err;
	GError* _tmp23_;
	GError* _tmp24_;
	GFile* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GError* _tmp28_;
	const gchar* _tmp29_;
	GFileInfo* _tmp30_;
	Marker* _tmp31_;
	Tombstone* _tmp32_;
	Marker* _tmp33_;
	gint _tmp34_;
	Marker* _tmp35_;
	gint _tmp36_;
	Marker* _tmp37_;
	GError* err2;
	GError* _tmp38_;
	GError * _inner_error_;
};

struct _TombstonedFile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TombstonedFilePrivate * priv;
	GFile* file;
	gint64 filesize;
	gchar* md5;
};

struct _TombstonedFileClass {
	GTypeClass parent_class;
	void (*finalize) (TombstonedFile *self);
};

struct _ParamSpecTombstonedFile {
	GParamSpec parent_instance;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

struct _Tombstone {
	DataSource parent_instance;
	TombstonePrivate * priv;
};

struct _TombstoneClass {
	DataSourceClass parent_class;
};

struct _TombstonePrivate {
	TombstoneRow* row;
	GFile* file;
};

typedef enum  {
	TOMBSTONE_REASON_REMOVED_BY_USER = 0,
	TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE = 1
} TombstoneReason;

struct _BackingFileState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingFileStatePrivate * priv;
	gchar* filepath;
	gint64 filesize;
	time_t modification_time;
	gchar* md5;
};

struct _BackingFileStateClass {
	GTypeClass parent_class;
	void (*finalize) (BackingFileState *self);
};

struct _TombstoneRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TombstoneRowPrivate * priv;
	TombstoneID id;
	gchar* filepath;
	gint64 filesize;
	gchar* md5;
	time_t time_created;
	TombstoneReason reason;
};

struct _TombstoneRowClass {
	GTypeClass parent_class;
	void (*finalize) (TombstoneRow *self);
};


static gpointer tombstone_source_collection_parent_class = NULL;
static gpointer tombstoned_file_parent_class = NULL;
static gpointer tombstone_parent_class = NULL;
extern TombstoneSourceCollection* tombstone_global;
TombstoneSourceCollection* tombstone_global = NULL;

gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
GType marker_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_backlink (GValue* value, gpointer v_object);
void value_take_source_backlink (GValue* value, gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType tombstone_source_collection_get_type (void) G_GNUC_CONST;
GType tombstone_get_type (void) G_GNUC_CONST;
#define TOMBSTONE_SOURCE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TOMBSTONE_SOURCE_COLLECTION, TombstoneSourceCollectionPrivate))
enum  {
	TOMBSTONE_SOURCE_COLLECTION_DUMMY_PROPERTY
};
guint file_hash (GFile* file);
static guint _file_hash_gee_hash_data_func (gconstpointer v, gpointer self);
gboolean file_equal (GFile* a, GFile* b);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
TombstoneSourceCollection* tombstone_source_collection_new (void);
TombstoneSourceCollection* tombstone_source_collection_construct (GType object_type);
static gint64 tombstone_source_collection_get_tombstone_id (DataSource* source);
static gint64 _tombstone_source_collection_get_tombstone_id_get_source_database_key (DataSource* source, gpointer self);
DatabaseSourceCollection* database_source_collection_construct (GType object_type, const gchar* name, GetSourceDatabaseKey source_key_func, void* source_key_func_target);
static gboolean tombstone_source_collection_real_holds_type_of_source (SourceCollection* base, DataSource* source);
GType tombstone_id_get_type (void) G_GNUC_CONST;
TombstoneID* tombstone_id_dup (const TombstoneID* self);
void tombstone_id_free (TombstoneID* self);
void tombstone_get_tombstone_id (Tombstone* self, TombstoneID* result);
static void tombstone_source_collection_real_notify_contents_altered (DataCollection* base, GeeIterable* added, GeeIterable* removed);
GFile* tombstone_get_file (Tombstone* self);
void data_collection_notify_contents_altered (DataCollection* self, GeeIterable* added, GeeIterable* removed);
static void tombstone_source_collection_real_notify_items_altered (DataCollection* base, GeeMap* items);
gboolean alteration_has_subject (Alteration* self, const gchar* subject);
GeeCollection* alteration_get_details (Alteration* self, const gchar* subject);
Tombstone* tombstone_source_collection_locate (TombstoneSourceCollection* self, GFile* file);
gboolean tombstone_source_collection_matches (TombstoneSourceCollection* self, GFile* file);
void tombstone_source_collection_resurrect (TombstoneSourceCollection* self, Tombstone* tombstone);
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
gint source_collection_destroy_marked (SourceCollection* self, Marker* marker, gboolean delete_backing, ProgressMonitor monitor, void* monitor_target, GeeList* not_removed);
Marker* data_collection_mark (DataCollection* self, DataObject* object);
void tombstone_source_collection_resurrect_many (TombstoneSourceCollection* self, GeeCollection* tombstones);
Marker* data_collection_mark_many (DataCollection* self, GeeCollection* objects);
void data_collection_freeze_notifications (DataCollection* self);
void database_table_begin_transaction (void);
GQuark database_error_quark (void);
void database_table_commit_transaction (GError** error);
void app_window_database_error (GError* err);
void data_collection_thaw_notifications (DataCollection* self);
GType directory_monitor_get_type (void) G_GNUC_CONST;
void tombstone_source_collection_launch_scan (TombstoneSourceCollection* self, DirectoryMonitor* monitor, GCancellable* cancellable);
static void tombstone_source_collection_async_scan (TombstoneSourceCollection* self, DirectoryMonitor* monitor, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tombstone_source_collection_async_scan_finish (TombstoneSourceCollection* self, GAsyncResult* _res_);
static void tombstone_source_collection_async_scan_data_free (gpointer _data);
static gboolean tombstone_source_collection_async_scan_co (TombstoneSourceCollectionAsyncScanData* _data_);
Marker* data_collection_start_marking (DataCollection* self);
GeeCollection* data_collection_get_all (DataCollection* self);
GFileInfo* directory_monitor_get_file_info (DirectoryMonitor* self, GFile* file);
static void tombstone_source_collection_async_scan_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void marker_mark (Marker* self, DataObject* object);
static gboolean _tombstone_source_collection_async_scan_co_gsource_func (gpointer self);
gint marker_get_count (Marker* self);
static void tombstone_source_collection_finalize (DataCollection* obj);
gpointer tombstoned_file_ref (gpointer instance);
void tombstoned_file_unref (gpointer instance);
GParamSpec* param_spec_tombstoned_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tombstoned_file (GValue* value, gpointer v_object);
void value_take_tombstoned_file (GValue* value, gpointer v_object);
gpointer value_get_tombstoned_file (const GValue* value);
GType tombstoned_file_get_type (void) G_GNUC_CONST;
enum  {
	TOMBSTONED_FILE_DUMMY_PROPERTY
};
TombstonedFile* tombstoned_file_new (GFile* file, gint64 filesize, const gchar* md5);
TombstonedFile* tombstoned_file_construct (GType object_type, GFile* file, gint64 filesize, const gchar* md5);
static void tombstoned_file_finalize (TombstonedFile* obj);
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_holding_tank (GValue* value, gpointer v_object);
void value_take_source_holding_tank (GValue* value, gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
gpointer source_snapshot_ref (gpointer instance);
void source_snapshot_unref (gpointer instance);
GParamSpec* param_spec_source_snapshot (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_snapshot (GValue* value, gpointer v_object);
void value_take_source_snapshot (GValue* value, gpointer v_object);
gpointer value_get_source_snapshot (const GValue* value);
GType source_snapshot_get_type (void) G_GNUC_CONST;
gpointer tombstone_row_ref (gpointer instance);
void tombstone_row_unref (gpointer instance);
GParamSpec* param_spec_tombstone_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tombstone_row (GValue* value, gpointer v_object);
void value_take_tombstone_row (GValue* value, gpointer v_object);
gpointer value_get_tombstone_row (const GValue* value);
GType tombstone_row_get_type (void) G_GNUC_CONST;
#define TOMBSTONE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TOMBSTONE, TombstonePrivate))
enum  {
	TOMBSTONE_DUMMY_PROPERTY
};
GType tombstone_reason_get_type (void) G_GNUC_CONST;
gint tombstone_reason_serialize (TombstoneReason self);
TombstoneReason tombstone_reason_unserialize (gint value);
static Tombstone* tombstone_new (TombstoneRow* row);
static Tombstone* tombstone_construct (GType object_type, TombstoneRow* row);
#define DATA_OBJECT_INVALID_OBJECT_ID ((gint64) -1)
DataSource* data_source_construct (GType object_type, gint64 object_id);
void tombstone_init (void);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType tombstone_table_get_type (void) G_GNUC_CONST;
TombstoneTable* tombstone_table_get_instance (void);
TombstoneRow** tombstone_table_fetch_all (TombstoneTable* self, int* result_length1, GError** error);
GeeCollection* data_collection_add_many (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
void tombstone_terminate (void);
void tombstone_entomb_many_sources (GeeCollection* sources, TombstoneReason reason, GError** error);
gpointer backing_file_state_ref (gpointer instance);
void backing_file_state_unref (gpointer instance);
GParamSpec* param_spec_backing_file_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_file_state (GValue* value, gpointer v_object);
void value_take_backing_file_state (GValue* value, gpointer v_object);
gpointer value_get_backing_file_state (const GValue* value);
GType backing_file_state_get_type (void) G_GNUC_CONST;
BackingFileState** media_source_get_backing_files_state (MediaSource* self, int* result_length1);
GFile* backing_file_state_get_file (BackingFileState* self);
void tombstone_entomb_many_files (GeeCollection* files, TombstoneReason reason, GError** error);
TombstoneRow* tombstone_table_add (TombstoneTable* self, const gchar* filepath, gint64 filesize, const gchar* md5, TombstoneReason reason, GError** error);
static gchar* tombstone_real_get_typename (DataSource* base);
static gint64 tombstone_real_get_instance_id (DataSource* base);
static gchar* tombstone_real_get_name (DataObject* base);
static gchar* tombstone_real_to_string (DataObject* base);
gchar* data_object_get_name (DataObject* self);
gchar* tombstone_get_md5 (Tombstone* self);
gboolean is_string_empty (const gchar* s);
TombstoneReason tombstone_get_reason (Tombstone* self);
void tombstone_move (Tombstone* self, GFile* file);
void tombstone_table_update_file (TombstoneTable* self, TombstoneID* tombstone_id, const gchar* filepath, GError** error);
void data_object_notify_altered (DataObject* self, Alteration* alteration);
Alteration* alteration_new (const gchar* subject, const gchar* detail);
Alteration* alteration_construct (GType object_type, const gchar* subject, const gchar* detail);
gboolean tombstone_matches (Tombstone* self, GFile* file, gint64 filesize, const gchar* md5);
static void tombstone_real_destroy (DataSource* base);
void tombstone_table_remove (TombstoneTable* self, TombstoneID* tombstone_id, GError** error);
void data_source_destroy (DataSource* self);
static void tombstone_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static guint _file_hash_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = file_hash ((GFile*) v);
#line 8 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 719 "Tombstone.c"
}


static gboolean _file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
#line 8 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 728 "Tombstone.c"
}


static gint64 _tombstone_source_collection_get_tombstone_id_get_source_database_key (DataSource* source, gpointer self) {
	gint64 result;
	result = tombstone_source_collection_get_tombstone_id (source);
#line 12 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 737 "Tombstone.c"
}


TombstoneSourceCollection* tombstone_source_collection_construct (GType object_type) {
	TombstoneSourceCollection* self = NULL;
#line 12 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self = (TombstoneSourceCollection*) database_source_collection_construct (object_type, "Tombstones", _tombstone_source_collection_get_tombstone_id_get_source_database_key, NULL);
#line 11 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return self;
#line 747 "Tombstone.c"
}


TombstoneSourceCollection* tombstone_source_collection_new (void) {
#line 11 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return tombstone_source_collection_construct (TYPE_TOMBSTONE_SOURCE_COLLECTION);
#line 754 "Tombstone.c"
}


static gboolean tombstone_source_collection_real_holds_type_of_source (SourceCollection* base, DataSource* source) {
	TombstoneSourceCollection * self;
	gboolean result = FALSE;
	DataSource* _tmp0_ = NULL;
#line 15 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TOMBSTONE_SOURCE_COLLECTION, TombstoneSourceCollection);
#line 15 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 16 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = source;
#line 16 "/home/jens/Source/shotwell/src/Tombstone.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_TOMBSTONE);
#line 16 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 772 "Tombstone.c"
}


static gint64 tombstone_source_collection_get_tombstone_id (DataSource* source) {
	gint64 result = 0LL;
	DataSource* _tmp0_ = NULL;
	TombstoneID _tmp1_ = {0};
	gint64 _tmp2_ = 0LL;
#line 19 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0LL);
#line 20 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = source;
#line 20 "/home/jens/Source/shotwell/src/Tombstone.vala"
	tombstone_get_tombstone_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_TOMBSTONE, Tombstone), &_tmp1_);
#line 20 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp2_ = _tmp1_.id;
#line 20 "/home/jens/Source/shotwell/src/Tombstone.vala"
	result = _tmp2_;
#line 20 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 793 "Tombstone.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 27 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return self ? g_object_ref (self) : NULL;
#line 800 "Tombstone.c"
}


static void tombstone_source_collection_real_notify_contents_altered (DataCollection* base, GeeIterable* added, GeeIterable* removed) {
	TombstoneSourceCollection * self;
	GeeIterable* _tmp0_ = NULL;
	GeeIterable* _tmp14_ = NULL;
	GeeIterable* _tmp36_ = NULL;
	GeeIterable* _tmp37_ = NULL;
#line 23 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TOMBSTONE_SOURCE_COLLECTION, TombstoneSourceCollection);
#line 23 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_ITERABLE (added));
#line 23 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_ITERABLE (removed));
#line 25 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = added;
#line 25 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (_tmp0_ != NULL) {
#line 820 "Tombstone.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterable* _tmp1_ = NULL;
			GeeIterator* _tmp2_ = NULL;
#line 26 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp1_ = added;
#line 26 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp2_ = gee_iterable_iterator (_tmp1_);
#line 26 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_object_it = _tmp2_;
#line 26 "/home/jens/Source/shotwell/src/Tombstone.vala"
			while (TRUE) {
#line 833 "Tombstone.c"
				GeeIterator* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				DataObject* object = NULL;
				GeeIterator* _tmp5_ = NULL;
				gpointer _tmp6_ = NULL;
				Tombstone* tombstone = NULL;
				DataObject* _tmp7_ = NULL;
				Tombstone* _tmp8_ = NULL;
				GeeHashMap* _tmp9_ = NULL;
				Tombstone* _tmp10_ = NULL;
				GFile* _tmp11_ = NULL;
				GFile* _tmp12_ = NULL;
				Tombstone* _tmp13_ = NULL;
#line 26 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp3_ = _object_it;
#line 26 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp4_ = gee_iterator_next (_tmp3_);
#line 26 "/home/jens/Source/shotwell/src/Tombstone.vala"
				if (!_tmp4_) {
#line 26 "/home/jens/Source/shotwell/src/Tombstone.vala"
					break;
#line 855 "Tombstone.c"
				}
#line 26 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp5_ = _object_it;
#line 26 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 26 "/home/jens/Source/shotwell/src/Tombstone.vala"
				object = (DataObject*) _tmp6_;
#line 27 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp7_ = object;
#line 27 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_TOMBSTONE, Tombstone));
#line 27 "/home/jens/Source/shotwell/src/Tombstone.vala"
				tombstone = _tmp8_;
#line 29 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp9_ = self->priv->file_map;
#line 29 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp10_ = tombstone;
#line 29 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp11_ = tombstone_get_file (_tmp10_);
#line 29 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp12_ = _tmp11_;
#line 29 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp13_ = tombstone;
#line 29 "/home/jens/Source/shotwell/src/Tombstone.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp12_, _tmp13_);
#line 29 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_g_object_unref0 (_tmp12_);
#line 26 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_g_object_unref0 (tombstone);
#line 26 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_g_object_unref0 (object);
#line 887 "Tombstone.c"
			}
#line 26 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (_object_it);
#line 891 "Tombstone.c"
		}
	}
#line 33 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp14_ = removed;
#line 33 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (_tmp14_ != NULL) {
#line 898 "Tombstone.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterable* _tmp15_ = NULL;
			GeeIterator* _tmp16_ = NULL;
#line 34 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp15_ = removed;
#line 34 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp16_ = gee_iterable_iterator (_tmp15_);
#line 34 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_object_it = _tmp16_;
#line 34 "/home/jens/Source/shotwell/src/Tombstone.vala"
			while (TRUE) {
#line 911 "Tombstone.c"
				GeeIterator* _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
				DataObject* object = NULL;
				GeeIterator* _tmp19_ = NULL;
				gpointer _tmp20_ = NULL;
				Tombstone* tombstone = NULL;
				DataObject* _tmp21_ = NULL;
				Tombstone* _tmp22_ = NULL;
				GeeHashMap* _tmp23_ = NULL;
				Tombstone* _tmp24_ = NULL;
				GFile* _tmp25_ = NULL;
				GFile* _tmp26_ = NULL;
				gboolean _tmp27_ = FALSE;
				gboolean _tmp28_ = FALSE;
#line 34 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp17_ = _object_it;
#line 34 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp18_ = gee_iterator_next (_tmp17_);
#line 34 "/home/jens/Source/shotwell/src/Tombstone.vala"
				if (!_tmp18_) {
#line 34 "/home/jens/Source/shotwell/src/Tombstone.vala"
					break;
#line 934 "Tombstone.c"
				}
#line 34 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp19_ = _object_it;
#line 34 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp20_ = gee_iterator_get (_tmp19_);
#line 34 "/home/jens/Source/shotwell/src/Tombstone.vala"
				object = (DataObject*) _tmp20_;
#line 35 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp21_ = object;
#line 35 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_TOMBSTONE, Tombstone));
#line 35 "/home/jens/Source/shotwell/src/Tombstone.vala"
				tombstone = _tmp22_;
#line 38 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp23_ = self->priv->file_map;
#line 38 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp24_ = tombstone;
#line 38 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp25_ = tombstone_get_file (_tmp24_);
#line 38 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp26_ = _tmp25_;
#line 38 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp27_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp26_);
#line 38 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp28_ = _tmp27_;
#line 38 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_g_object_unref0 (_tmp26_);
#line 38 "/home/jens/Source/shotwell/src/Tombstone.vala"
				if (_tmp28_) {
#line 964 "Tombstone.c"
					gboolean is_removed = FALSE;
					GeeHashMap* _tmp29_ = NULL;
					Tombstone* _tmp30_ = NULL;
					GFile* _tmp31_ = NULL;
					GFile* _tmp32_ = NULL;
					gboolean _tmp33_ = FALSE;
					gboolean _tmp34_ = FALSE;
					gboolean _tmp35_ = FALSE;
#line 40 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp29_ = self->priv->file_map;
#line 40 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp30_ = tombstone;
#line 40 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp31_ = tombstone_get_file (_tmp30_);
#line 40 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp32_ = _tmp31_;
#line 40 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp33_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp32_, NULL);
#line 40 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp34_ = _tmp33_;
#line 40 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (_tmp32_);
#line 40 "/home/jens/Source/shotwell/src/Tombstone.vala"
					is_removed = _tmp34_;
#line 41 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp35_ = is_removed;
#line 41 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_vala_assert (_tmp35_, "is_removed");
#line 993 "Tombstone.c"
				}
#line 34 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_g_object_unref0 (tombstone);
#line 34 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_g_object_unref0 (object);
#line 999 "Tombstone.c"
			}
#line 34 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (_object_it);
#line 1003 "Tombstone.c"
		}
	}
#line 49 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp36_ = added;
#line 49 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp37_ = removed;
#line 49 "/home/jens/Source/shotwell/src/Tombstone.vala"
	DATA_COLLECTION_CLASS (tombstone_source_collection_parent_class)->notify_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), TYPE_DATA_COLLECTION, DataCollection), _tmp36_, _tmp37_);
#line 1012 "Tombstone.c"
}


static void tombstone_source_collection_real_notify_items_altered (DataCollection* base, GeeMap* items) {
	TombstoneSourceCollection * self;
#line 52 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TOMBSTONE_SOURCE_COLLECTION, TombstoneSourceCollection);
#line 52 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail (GEE_IS_MAP (items));
#line 1022 "Tombstone.c"
	{
		GeeIterator* _object_it = NULL;
		GeeMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp0_ = items;
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp1_ = gee_map_get_keys (_tmp0_);
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp2_ = _tmp1_;
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp3_ = _tmp2_;
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp5_ = _tmp4_;
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_object_unref0 (_tmp3_);
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_object_it = _tmp5_;
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
		while (TRUE) {
#line 1049 "Tombstone.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			Alteration* alteration = NULL;
			GeeMap* _tmp10_ = NULL;
			DataObject* _tmp11_ = NULL;
			gpointer _tmp12_ = NULL;
			Alteration* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			Tombstone* tombstone = NULL;
			DataObject* _tmp15_ = NULL;
			Tombstone* _tmp16_ = NULL;
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp6_ = _object_it;
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (!_tmp7_) {
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
				break;
#line 1072 "Tombstone.c"
			}
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp8_ = _object_it;
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
			object = (DataObject*) _tmp9_;
#line 54 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp10_ = items;
#line 54 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp11_ = object;
#line 54 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp12_ = gee_map_get (_tmp10_, _tmp11_);
#line 54 "/home/jens/Source/shotwell/src/Tombstone.vala"
			alteration = (Alteration*) _tmp12_;
#line 55 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp13_ = alteration;
#line 55 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp14_ = alteration_has_subject (_tmp13_, "file");
#line 55 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (!_tmp14_) {
#line 56 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_alteration_unref0 (alteration);
#line 56 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_g_object_unref0 (object);
#line 56 "/home/jens/Source/shotwell/src/Tombstone.vala"
				continue;
#line 1100 "Tombstone.c"
			}
#line 58 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp15_ = object;
#line 58 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_TOMBSTONE, Tombstone));
#line 58 "/home/jens/Source/shotwell/src/Tombstone.vala"
			tombstone = _tmp16_;
#line 1108 "Tombstone.c"
			{
				GeeIterator* _detail_it = NULL;
				Alteration* _tmp17_ = NULL;
				GeeCollection* _tmp18_ = NULL;
				GeeCollection* _tmp19_ = NULL;
				GeeIterator* _tmp20_ = NULL;
				GeeIterator* _tmp21_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp17_ = alteration;
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp18_ = alteration_get_details (_tmp17_, "file");
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp19_ = _tmp18_;
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp20_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ITERABLE, GeeIterable));
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp21_ = _tmp20_;
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_g_object_unref0 (_tmp19_);
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_detail_it = _tmp21_;
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
				while (TRUE) {
#line 1132 "Tombstone.c"
					GeeIterator* _tmp22_ = NULL;
					gboolean _tmp23_ = FALSE;
					gchar* detail = NULL;
					GeeIterator* _tmp24_ = NULL;
					gpointer _tmp25_ = NULL;
					GFile* old_file = NULL;
					const gchar* _tmp26_ = NULL;
					GFile* _tmp27_ = NULL;
					gboolean removed = FALSE;
					GeeHashMap* _tmp28_ = NULL;
					GFile* _tmp29_ = NULL;
					gboolean _tmp30_ = FALSE;
					gboolean _tmp31_ = FALSE;
					GeeHashMap* _tmp32_ = NULL;
					Tombstone* _tmp33_ = NULL;
					GFile* _tmp34_ = NULL;
					GFile* _tmp35_ = NULL;
					Tombstone* _tmp36_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp22_ = _detail_it;
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp23_ = gee_iterator_next (_tmp22_);
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
					if (!_tmp23_) {
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
						break;
#line 1159 "Tombstone.c"
					}
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp24_ = _detail_it;
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp25_ = gee_iterator_get (_tmp24_);
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
					detail = (gchar*) _tmp25_;
#line 61 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp26_ = detail;
#line 61 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp27_ = g_file_new_for_path (_tmp26_);
#line 61 "/home/jens/Source/shotwell/src/Tombstone.vala"
					old_file = _tmp27_;
#line 63 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp28_ = self->priv->file_map;
#line 63 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp29_ = old_file;
#line 63 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp30_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp29_, NULL);
#line 63 "/home/jens/Source/shotwell/src/Tombstone.vala"
					removed = _tmp30_;
#line 64 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp31_ = removed;
#line 64 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_vala_assert (_tmp31_, "removed");
#line 66 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp32_ = self->priv->file_map;
#line 66 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp33_ = tombstone;
#line 66 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp34_ = tombstone_get_file (_tmp33_);
#line 66 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp35_ = _tmp34_;
#line 66 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp36_ = tombstone;
#line 66 "/home/jens/Source/shotwell/src/Tombstone.vala"
					gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp35_, _tmp36_);
#line 66 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (_tmp35_);
#line 68 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (old_file);
#line 68 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_free0 (detail);
#line 68 "/home/jens/Source/shotwell/src/Tombstone.vala"
					break;
#line 1205 "Tombstone.c"
				}
#line 60 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_g_object_unref0 (_detail_it);
#line 1209 "Tombstone.c"
			}
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (tombstone);
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_alteration_unref0 (alteration);
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (object);
#line 1217 "Tombstone.c"
		}
#line 53 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_object_unref0 (_object_it);
#line 1221 "Tombstone.c"
	}
}


Tombstone* tombstone_source_collection_locate (TombstoneSourceCollection* self, GFile* file) {
	Tombstone* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
#line 73 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (IS_TOMBSTONE_SOURCE_COLLECTION (self), NULL);
#line 73 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 74 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = self->priv->file_map;
#line 74 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = file;
#line 74 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 74 "/home/jens/Source/shotwell/src/Tombstone.vala"
	result = (Tombstone*) _tmp2_;
#line 74 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 1245 "Tombstone.c"
}


gboolean tombstone_source_collection_matches (TombstoneSourceCollection* self, GFile* file) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 77 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (IS_TOMBSTONE_SOURCE_COLLECTION (self), FALSE);
#line 77 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 78 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = self->priv->file_map;
#line 78 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = file;
#line 78 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp2_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 78 "/home/jens/Source/shotwell/src/Tombstone.vala"
	result = _tmp2_;
#line 78 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 1268 "Tombstone.c"
}


void tombstone_source_collection_resurrect (TombstoneSourceCollection* self, Tombstone* tombstone) {
	Tombstone* _tmp0_ = NULL;
	Marker* _tmp1_ = NULL;
	Marker* _tmp2_ = NULL;
#line 81 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail (IS_TOMBSTONE_SOURCE_COLLECTION (self));
#line 81 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail (IS_TOMBSTONE (tombstone));
#line 82 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = tombstone;
#line 82 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = data_collection_mark (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_OBJECT, DataObject));
#line 82 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp2_ = _tmp1_;
#line 82 "/home/jens/Source/shotwell/src/Tombstone.vala"
	source_collection_destroy_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp2_, FALSE, NULL, NULL, NULL);
#line 82 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (_tmp2_);
#line 1290 "Tombstone.c"
}


void tombstone_source_collection_resurrect_many (TombstoneSourceCollection* self, GeeCollection* tombstones) {
	Marker* marker = NULL;
	GeeCollection* _tmp0_ = NULL;
	Marker* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 85 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail (IS_TOMBSTONE_SOURCE_COLLECTION (self));
#line 85 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail (GEE_IS_COLLECTION (tombstones));
#line 86 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = tombstones;
#line 86 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = data_collection_mark_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp0_);
#line 86 "/home/jens/Source/shotwell/src/Tombstone.vala"
	marker = _tmp1_;
#line 88 "/home/jens/Source/shotwell/src/Tombstone.vala"
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 89 "/home/jens/Source/shotwell/src/Tombstone.vala"
	database_table_begin_transaction ();
#line 91 "/home/jens/Source/shotwell/src/Tombstone.vala"
	source_collection_destroy_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_COLLECTION, SourceCollection), marker, FALSE, NULL, NULL, NULL);
#line 1315 "Tombstone.c"
	{
#line 94 "/home/jens/Source/shotwell/src/Tombstone.vala"
		database_table_commit_transaction (&_inner_error_);
#line 94 "/home/jens/Source/shotwell/src/Tombstone.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 94 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1323 "Tombstone.c"
				goto __catch537_database_error;
			}
#line 94 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (marker);
#line 94 "/home/jens/Source/shotwell/src/Tombstone.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/jens/Source/shotwell/src/Tombstone.vala"
			g_clear_error (&_inner_error_);
#line 94 "/home/jens/Source/shotwell/src/Tombstone.vala"
			return;
#line 1334 "Tombstone.c"
		}
	}
	goto __finally537;
	__catch537_database_error:
	{
		GError* err = NULL;
		GError* _tmp2_ = NULL;
#line 93 "/home/jens/Source/shotwell/src/Tombstone.vala"
		err = _inner_error_;
#line 93 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_inner_error_ = NULL;
#line 96 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp2_ = err;
#line 96 "/home/jens/Source/shotwell/src/Tombstone.vala"
		app_window_database_error (_tmp2_);
#line 93 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_error_free0 (err);
#line 1352 "Tombstone.c"
	}
	__finally537:
#line 93 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 93 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_object_unref0 (marker);
#line 93 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 93 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_clear_error (&_inner_error_);
#line 93 "/home/jens/Source/shotwell/src/Tombstone.vala"
		return;
#line 1365 "Tombstone.c"
	}
#line 99 "/home/jens/Source/shotwell/src/Tombstone.vala"
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 85 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (marker);
#line 1371 "Tombstone.c"
}


void tombstone_source_collection_launch_scan (TombstoneSourceCollection* self, DirectoryMonitor* monitor, GCancellable* cancellable) {
	DirectoryMonitor* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 108 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail (IS_TOMBSTONE_SOURCE_COLLECTION (self));
#line 108 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail ((monitor == NULL) || IS_DIRECTORY_MONITOR (monitor));
#line 108 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable));
#line 109 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = monitor;
#line 109 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = cancellable;
#line 109 "/home/jens/Source/shotwell/src/Tombstone.vala"
	tombstone_source_collection_async_scan (self, _tmp0_, _tmp1_, NULL, NULL);
#line 1390 "Tombstone.c"
}


static void tombstone_source_collection_async_scan_data_free (gpointer _data) {
	TombstoneSourceCollectionAsyncScanData* _data_;
	_data_ = _data;
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (_data_->monitor);
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (_data_->cancellable);
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_collection_unref0 (_data_->self);
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_slice_free (TombstoneSourceCollectionAsyncScanData, _data_);
#line 1405 "Tombstone.c"
}


static gpointer _data_collection_ref0 (gpointer self) {
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return self ? data_collection_ref (self) : NULL;
#line 1412 "Tombstone.c"
}


static void tombstone_source_collection_async_scan (TombstoneSourceCollection* self, DirectoryMonitor* monitor, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TombstoneSourceCollectionAsyncScanData* _data_;
	TombstoneSourceCollection* _tmp0_ = NULL;
	DirectoryMonitor* _tmp1_ = NULL;
	DirectoryMonitor* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_ = g_slice_new0 (TombstoneSourceCollectionAsyncScanData);
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tombstone_source_collection_async_scan);
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tombstone_source_collection_async_scan_data_free);
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = _data_collection_ref0 (self);
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_->self = _tmp0_;
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = monitor;
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (_data_->monitor);
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_->monitor = _tmp2_;
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp3_ = cancellable;
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (_data_->cancellable);
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_->cancellable = _tmp4_;
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	tombstone_source_collection_async_scan_co (_data_);
#line 1451 "Tombstone.c"
}


static void tombstone_source_collection_async_scan_finish (TombstoneSourceCollection* self, GAsyncResult* _res_) {
	TombstoneSourceCollectionAsyncScanData* _data_;
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1459 "Tombstone.c"
}


static void tombstone_source_collection_async_scan_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TombstoneSourceCollectionAsyncScanData* _data_;
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_ = _user_data_;
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_->_source_object_ = source_object;
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_->_res_ = _res_;
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
	tombstone_source_collection_async_scan_co (_data_);
#line 1473 "Tombstone.c"
}


static gboolean _tombstone_source_collection_async_scan_co_gsource_func (gpointer self) {
	gboolean result;
	result = tombstone_source_collection_async_scan_co (self);
#line 145 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 1482 "Tombstone.c"
}


static gboolean tombstone_source_collection_async_scan_co (TombstoneSourceCollectionAsyncScanData* _data_) {
#line 112 "/home/jens/Source/shotwell/src/Tombstone.vala"
	switch (_data_->_state_) {
#line 112 "/home/jens/Source/shotwell/src/Tombstone.vala"
		case 0:
#line 1491 "Tombstone.c"
		goto _state_0;
#line 112 "/home/jens/Source/shotwell/src/Tombstone.vala"
		case 1:
#line 1495 "Tombstone.c"
		goto _state_1;
#line 112 "/home/jens/Source/shotwell/src/Tombstone.vala"
		case 2:
#line 1499 "Tombstone.c"
		goto _state_2;
		default:
#line 112 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_assert_not_reached ();
#line 1504 "Tombstone.c"
	}
	_state_0:
#line 114 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_->_tmp0_ = NULL;
#line 114 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_->_tmp0_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_DATA_COLLECTION, DataCollection));
#line 114 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_->marker = _data_->_tmp0_;
#line 1513 "Tombstone.c"
	{
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_tmp1_ = NULL;
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_tmp1_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_DATA_COLLECTION, DataCollection));
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_tmp2_ = NULL;
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_tmp2_ = _data_->_tmp1_;
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_tmp3_ = NULL;
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_tmp4_ = NULL;
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_tmp4_ = _data_->_tmp3_;
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_object_unref0 (_data_->_tmp2_);
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_object_it = _data_->_tmp4_;
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
		while (TRUE) {
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp5_ = NULL;
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp5_ = _data_->_object_it;
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp6_ = FALSE;
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp6_ = gee_iterator_next (_data_->_tmp5_);
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (!_data_->_tmp6_) {
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
				break;
#line 1549 "Tombstone.c"
			}
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp7_ = NULL;
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp7_ = _data_->_object_it;
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp8_ = NULL;
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp8_ = gee_iterator_get (_data_->_tmp7_);
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->object = (DataObject*) _data_->_tmp8_;
#line 116 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp9_ = NULL;
#line 116 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp9_ = _data_->object;
#line 116 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp10_ = NULL;
#line 116 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, TYPE_TOMBSTONE, Tombstone));
#line 116 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->tombstone = _data_->_tmp10_;
#line 117 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp11_ = NULL;
#line 117 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp11_ = _data_->tombstone;
#line 117 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp12_ = NULL;
#line 117 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp12_ = tombstone_get_file (_data_->_tmp11_);
#line 117 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->file = _data_->_tmp12_;
#line 119 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->info = NULL;
#line 120 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp13_ = NULL;
#line 120 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp13_ = _data_->monitor;
#line 120 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (_data_->_tmp13_ != NULL) {
#line 121 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_data_->_tmp14_ = NULL;
#line 121 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_data_->_tmp14_ = _data_->monitor;
#line 121 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_data_->_tmp15_ = NULL;
#line 121 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_data_->_tmp15_ = _data_->file;
#line 121 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_data_->_tmp16_ = NULL;
#line 121 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_data_->_tmp16_ = directory_monitor_get_file_info (_data_->_tmp14_, _data_->_tmp15_);
#line 121 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_g_object_unref0 (_data_->info);
#line 121 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_data_->info = _data_->_tmp16_;
#line 1605 "Tombstone.c"
			}
#line 125 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp17_ = NULL;
#line 125 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp17_ = _data_->info;
#line 125 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (_data_->_tmp17_ == NULL) {
#line 1613 "Tombstone.c"
				{
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_tmp19_ = NULL;
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_tmp19_ = _data_->file;
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_tmp20_ = NULL;
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_tmp20_ = _data_->cancellable;
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_state_ = 1;
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					g_file_query_info_async (_data_->_tmp19_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, G_PRIORITY_LOW, _data_->_tmp20_, tombstone_source_collection_async_scan_ready, _data_);
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					return FALSE;
#line 1629 "Tombstone.c"
					_state_1:
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_tmp21_ = NULL;
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_tmp21_ = g_file_query_info_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error_);
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_tmp18_ = _data_->_tmp21_;
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1639 "Tombstone.c"
						goto __catch538_g_error;
					}
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_tmp22_ = NULL;
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_tmp22_ = _data_->_tmp18_;
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_tmp18_ = NULL;
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (_data_->info);
#line 127 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->info = _data_->_tmp22_;
#line 126 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (_data_->_tmp18_);
#line 1654 "Tombstone.c"
				}
				goto __finally538;
				__catch538_g_error:
				{
#line 126 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->err = _data_->_inner_error_;
#line 126 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_inner_error_ = NULL;
#line 131 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_tmp23_ = NULL;
#line 131 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_tmp23_ = _data_->err;
#line 131 "/home/jens/Source/shotwell/src/Tombstone.vala"
					if (g_error_matches (_data_->_tmp23_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
#line 132 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_g_error_free0 (_data_->err);
#line 132 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_g_object_unref0 (_data_->info);
#line 132 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_g_object_unref0 (_data_->file);
#line 132 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_g_object_unref0 (_data_->tombstone);
#line 132 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_g_object_unref0 (_data_->object);
#line 132 "/home/jens/Source/shotwell/src/Tombstone.vala"
						break;
#line 1681 "Tombstone.c"
					}
#line 134 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_tmp24_ = NULL;
#line 134 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_data_->_tmp24_ = _data_->err;
#line 134 "/home/jens/Source/shotwell/src/Tombstone.vala"
					if (!g_error_matches (_data_->_tmp24_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
#line 135 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_data_->_tmp25_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_data_->_tmp25_ = _data_->file;
#line 135 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_data_->_tmp26_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_data_->_tmp26_ = g_file_get_path (_data_->_tmp25_);
#line 135 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_data_->_tmp27_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_data_->_tmp27_ = _data_->_tmp26_;
#line 135 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_data_->_tmp28_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_data_->_tmp28_ = _data_->err;
#line 135 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_data_->_tmp29_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_data_->_tmp29_ = _data_->_tmp28_->message;
#line 135 "/home/jens/Source/shotwell/src/Tombstone.vala"
						g_warning ("Tombstone.vala:135: Unable to check for existence of tombstoned file %" \
"s: %s", _data_->_tmp27_, _data_->_tmp29_);
#line 135 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_g_free0 (_data_->_tmp27_);
#line 1713 "Tombstone.c"
					}
#line 126 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_error_free0 (_data_->err);
#line 1717 "Tombstone.c"
				}
				__finally538:
#line 126 "/home/jens/Source/shotwell/src/Tombstone.vala"
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 126 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (_data_->info);
#line 126 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (_data_->file);
#line 126 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (_data_->tombstone);
#line 126 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (_data_->object);
#line 126 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (_data_->_object_it);
#line 126 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (_data_->marker);
#line 126 "/home/jens/Source/shotwell/src/Tombstone.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 126 "/home/jens/Source/shotwell/src/Tombstone.vala"
					g_clear_error (&_data_->_inner_error_);
#line 126 "/home/jens/Source/shotwell/src/Tombstone.vala"
					return FALSE;
#line 1740 "Tombstone.c"
				}
			}
#line 142 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp30_ = NULL;
#line 142 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp30_ = _data_->info;
#line 142 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (_data_->_tmp30_ == NULL) {
#line 143 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_data_->_tmp31_ = NULL;
#line 143 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_data_->_tmp31_ = _data_->marker;
#line 143 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_data_->_tmp32_ = NULL;
#line 143 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_data_->_tmp32_ = _data_->tombstone;
#line 143 "/home/jens/Source/shotwell/src/Tombstone.vala"
				marker_mark (_data_->_tmp31_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp32_, TYPE_DATA_OBJECT, DataObject));
#line 1759 "Tombstone.c"
			}
#line 145 "/home/jens/Source/shotwell/src/Tombstone.vala"
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tombstone_source_collection_async_scan_co_gsource_func, _data_, NULL);
#line 146 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_state_ = 2;
#line 146 "/home/jens/Source/shotwell/src/Tombstone.vala"
			return FALSE;
#line 1767 "Tombstone.c"
			_state_2:
			;
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (_data_->info);
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (_data_->file);
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (_data_->tombstone);
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (_data_->object);
#line 1778 "Tombstone.c"
		}
#line 115 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_object_unref0 (_data_->_object_it);
#line 1782 "Tombstone.c"
	}
#line 149 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_->_tmp33_ = NULL;
#line 149 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_->_tmp33_ = _data_->marker;
#line 149 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_->_tmp34_ = 0;
#line 149 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_->_tmp34_ = marker_get_count (_data_->_tmp33_);
#line 149 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (_data_->_tmp34_ > 0) {
#line 150 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_tmp35_ = NULL;
#line 150 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_tmp35_ = _data_->marker;
#line 150 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_tmp36_ = 0;
#line 150 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_tmp36_ = marker_get_count (_data_->_tmp35_);
#line 150 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_debug ("Tombstone.vala:150: Resurrecting %d tombstones with no backing file", _data_->_tmp36_);
#line 151 "/home/jens/Source/shotwell/src/Tombstone.vala"
		database_table_begin_transaction ();
#line 152 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_tmp37_ = NULL;
#line 152 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_data_->_tmp37_ = _data_->marker;
#line 152 "/home/jens/Source/shotwell/src/Tombstone.vala"
		source_collection_destroy_marked (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_SOURCE_COLLECTION, SourceCollection), _data_->_tmp37_, FALSE, NULL, NULL, NULL);
#line 1812 "Tombstone.c"
		{
#line 154 "/home/jens/Source/shotwell/src/Tombstone.vala"
			database_table_commit_transaction (&_data_->_inner_error_);
#line 154 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 154 "/home/jens/Source/shotwell/src/Tombstone.vala"
				if (_data_->_inner_error_->domain == DATABASE_ERROR) {
#line 1820 "Tombstone.c"
					goto __catch539_database_error;
				}
#line 154 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_g_object_unref0 (_data_->marker);
#line 154 "/home/jens/Source/shotwell/src/Tombstone.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 154 "/home/jens/Source/shotwell/src/Tombstone.vala"
				g_clear_error (&_data_->_inner_error_);
#line 154 "/home/jens/Source/shotwell/src/Tombstone.vala"
				return FALSE;
#line 1831 "Tombstone.c"
			}
		}
		goto __finally539;
		__catch539_database_error:
		{
#line 153 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->err2 = _data_->_inner_error_;
#line 153 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_inner_error_ = NULL;
#line 156 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp38_ = NULL;
#line 156 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_data_->_tmp38_ = _data_->err2;
#line 156 "/home/jens/Source/shotwell/src/Tombstone.vala"
			app_window_database_error (_data_->_tmp38_);
#line 153 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_error_free0 (_data_->err2);
#line 1849 "Tombstone.c"
		}
		__finally539:
#line 153 "/home/jens/Source/shotwell/src/Tombstone.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 153 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (_data_->marker);
#line 153 "/home/jens/Source/shotwell/src/Tombstone.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 153 "/home/jens/Source/shotwell/src/Tombstone.vala"
			g_clear_error (&_data_->_inner_error_);
#line 153 "/home/jens/Source/shotwell/src/Tombstone.vala"
			return FALSE;
#line 1862 "Tombstone.c"
		}
	}
#line 112 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (_data_->marker);
#line 112 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (_data_->_state_ == 0) {
#line 112 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1871 "Tombstone.c"
	} else {
#line 112 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1875 "Tombstone.c"
	}
#line 112 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_object_unref (_data_->_async_result);
#line 112 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return FALSE;
#line 1881 "Tombstone.c"
}


static void tombstone_source_collection_class_init (TombstoneSourceCollectionClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	tombstone_source_collection_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	((DataCollectionClass *) klass)->finalize = tombstone_source_collection_finalize;
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_type_class_add_private (klass, sizeof (TombstoneSourceCollectionPrivate));
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	((SourceCollectionClass *) klass)->holds_type_of_source = tombstone_source_collection_real_holds_type_of_source;
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	((DataCollectionClass *) klass)->notify_contents_altered = tombstone_source_collection_real_notify_contents_altered;
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	((DataCollectionClass *) klass)->notify_items_altered = tombstone_source_collection_real_notify_items_altered;
#line 1898 "Tombstone.c"
}


static void tombstone_source_collection_instance_init (TombstoneSourceCollection * self) {
	GeeHashMap* _tmp0_ = NULL;
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self->priv = TOMBSTONE_SOURCE_COLLECTION_GET_PRIVATE (self);
#line 8 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, TYPE_TOMBSTONE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
#line 8 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self->priv->file_map = _tmp0_;
#line 1910 "Tombstone.c"
}


static void tombstone_source_collection_finalize (DataCollection* obj) {
	TombstoneSourceCollection * self;
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOMBSTONE_SOURCE_COLLECTION, TombstoneSourceCollection);
#line 8 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (self->priv->file_map);
#line 7 "/home/jens/Source/shotwell/src/Tombstone.vala"
	DATA_COLLECTION_CLASS (tombstone_source_collection_parent_class)->finalize (obj);
#line 1922 "Tombstone.c"
}


GType tombstone_source_collection_get_type (void) {
	static volatile gsize tombstone_source_collection_type_id__volatile = 0;
	if (g_once_init_enter (&tombstone_source_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TombstoneSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tombstone_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TombstoneSourceCollection), 0, (GInstanceInitFunc) tombstone_source_collection_instance_init, NULL };
		GType tombstone_source_collection_type_id;
		tombstone_source_collection_type_id = g_type_register_static (TYPE_DATABASE_SOURCE_COLLECTION, "TombstoneSourceCollection", &g_define_type_info, 0);
		g_once_init_leave (&tombstone_source_collection_type_id__volatile, tombstone_source_collection_type_id);
	}
	return tombstone_source_collection_type_id__volatile;
}


TombstonedFile* tombstoned_file_construct (GType object_type, GFile* file, gint64 filesize, const gchar* md5) {
	TombstonedFile* self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 167 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 167 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self = (TombstonedFile*) g_type_create_instance (object_type);
#line 168 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = file;
#line 168 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 168 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (self->file);
#line 168 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self->file = _tmp1_;
#line 169 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp2_ = filesize;
#line 169 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self->filesize = _tmp2_;
#line 170 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp3_ = md5;
#line 170 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 170 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_free0 (self->md5);
#line 170 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self->md5 = _tmp4_;
#line 167 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return self;
#line 1971 "Tombstone.c"
}


TombstonedFile* tombstoned_file_new (GFile* file, gint64 filesize, const gchar* md5) {
#line 167 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return tombstoned_file_construct (TYPE_TOMBSTONED_FILE, file, filesize, md5);
#line 1978 "Tombstone.c"
}


static void value_tombstoned_file_init (GValue* value) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	value->data[0].v_pointer = NULL;
#line 1985 "Tombstone.c"
}


static void value_tombstoned_file_free_value (GValue* value) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (value->data[0].v_pointer) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		tombstoned_file_unref (value->data[0].v_pointer);
#line 1994 "Tombstone.c"
	}
}


static void value_tombstoned_file_copy_value (const GValue* src_value, GValue* dest_value) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (src_value->data[0].v_pointer) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		dest_value->data[0].v_pointer = tombstoned_file_ref (src_value->data[0].v_pointer);
#line 2004 "Tombstone.c"
	} else {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2008 "Tombstone.c"
	}
}


static gpointer value_tombstoned_file_peek_pointer (const GValue* value) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return value->data[0].v_pointer;
#line 2016 "Tombstone.c"
}


static gchar* value_tombstoned_file_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (collect_values[0].v_pointer) {
#line 2023 "Tombstone.c"
		TombstonedFile* object;
		object = collect_values[0].v_pointer;
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		if (object->parent_instance.g_class == NULL) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2030 "Tombstone.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2034 "Tombstone.c"
		}
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		value->data[0].v_pointer = tombstoned_file_ref (object);
#line 2038 "Tombstone.c"
	} else {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		value->data[0].v_pointer = NULL;
#line 2042 "Tombstone.c"
	}
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return NULL;
#line 2046 "Tombstone.c"
}


static gchar* value_tombstoned_file_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TombstonedFile** object_p;
	object_p = collect_values[0].v_pointer;
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (!object_p) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2057 "Tombstone.c"
	}
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (!value->data[0].v_pointer) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		*object_p = NULL;
#line 2063 "Tombstone.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		*object_p = value->data[0].v_pointer;
#line 2067 "Tombstone.c"
	} else {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		*object_p = tombstoned_file_ref (value->data[0].v_pointer);
#line 2071 "Tombstone.c"
	}
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return NULL;
#line 2075 "Tombstone.c"
}


GParamSpec* param_spec_tombstoned_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTombstonedFile* spec;
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TOMBSTONED_FILE), NULL);
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return G_PARAM_SPEC (spec);
#line 2089 "Tombstone.c"
}


gpointer value_get_tombstoned_file (const GValue* value) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOMBSTONED_FILE), NULL);
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return value->data[0].v_pointer;
#line 2098 "Tombstone.c"
}


void value_set_tombstoned_file (GValue* value, gpointer v_object) {
	TombstonedFile* old;
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOMBSTONED_FILE));
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	old = value->data[0].v_pointer;
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (v_object) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TOMBSTONED_FILE));
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		value->data[0].v_pointer = v_object;
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		tombstoned_file_ref (value->data[0].v_pointer);
#line 2118 "Tombstone.c"
	} else {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		value->data[0].v_pointer = NULL;
#line 2122 "Tombstone.c"
	}
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (old) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		tombstoned_file_unref (old);
#line 2128 "Tombstone.c"
	}
}


void value_take_tombstoned_file (GValue* value, gpointer v_object) {
	TombstonedFile* old;
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOMBSTONED_FILE));
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	old = value->data[0].v_pointer;
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (v_object) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TOMBSTONED_FILE));
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		value->data[0].v_pointer = v_object;
#line 2147 "Tombstone.c"
	} else {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		value->data[0].v_pointer = NULL;
#line 2151 "Tombstone.c"
	}
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (old) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		tombstoned_file_unref (old);
#line 2157 "Tombstone.c"
	}
}


static void tombstoned_file_class_init (TombstonedFileClass * klass) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	tombstoned_file_parent_class = g_type_class_peek_parent (klass);
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	((TombstonedFileClass *) klass)->finalize = tombstoned_file_finalize;
#line 2167 "Tombstone.c"
}


static void tombstoned_file_instance_init (TombstonedFile * self) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self->ref_count = 1;
#line 2174 "Tombstone.c"
}


static void tombstoned_file_finalize (TombstonedFile* obj) {
	TombstonedFile * self;
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOMBSTONED_FILE, TombstonedFile);
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_signal_handlers_destroy (self);
#line 163 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (self->file);
#line 165 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_free0 (self->md5);
#line 2188 "Tombstone.c"
}


GType tombstoned_file_get_type (void) {
	static volatile gsize tombstoned_file_type_id__volatile = 0;
	if (g_once_init_enter (&tombstoned_file_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_tombstoned_file_init, value_tombstoned_file_free_value, value_tombstoned_file_copy_value, value_tombstoned_file_peek_pointer, "p", value_tombstoned_file_collect_value, "p", value_tombstoned_file_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TombstonedFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tombstoned_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TombstonedFile), 0, (GInstanceInitFunc) tombstoned_file_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tombstoned_file_type_id;
		tombstoned_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TombstonedFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tombstoned_file_type_id__volatile, tombstoned_file_type_id);
	}
	return tombstoned_file_type_id__volatile;
}


gpointer tombstoned_file_ref (gpointer instance) {
	TombstonedFile* self;
	self = instance;
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_atomic_int_inc (&self->ref_count);
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return instance;
#line 2213 "Tombstone.c"
}


void tombstoned_file_unref (gpointer instance) {
	TombstonedFile* self;
	self = instance;
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		TOMBSTONED_FILE_GET_CLASS (self)->finalize (self);
#line 162 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2226 "Tombstone.c"
	}
}


gint tombstone_reason_serialize (TombstoneReason self) {
	gint result = 0;
#line 181 "/home/jens/Source/shotwell/src/Tombstone.vala"
	result = (gint) self;
#line 181 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 2237 "Tombstone.c"
}


TombstoneReason tombstone_reason_unserialize (gint value) {
	TombstoneReason result = 0;
	gint _tmp0_ = 0;
#line 185 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = value;
#line 185 "/home/jens/Source/shotwell/src/Tombstone.vala"
	switch ((TombstoneReason) _tmp0_) {
#line 185 "/home/jens/Source/shotwell/src/Tombstone.vala"
		case TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE:
#line 2250 "Tombstone.c"
		{
#line 187 "/home/jens/Source/shotwell/src/Tombstone.vala"
			result = TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE;
#line 187 "/home/jens/Source/shotwell/src/Tombstone.vala"
			return result;
#line 2256 "Tombstone.c"
		}
		default:
#line 185 "/home/jens/Source/shotwell/src/Tombstone.vala"
		case TOMBSTONE_REASON_REMOVED_BY_USER:
#line 2261 "Tombstone.c"
		{
#line 192 "/home/jens/Source/shotwell/src/Tombstone.vala"
			result = TOMBSTONE_REASON_REMOVED_BY_USER;
#line 192 "/home/jens/Source/shotwell/src/Tombstone.vala"
			return result;
#line 2267 "Tombstone.c"
		}
	}
}


GType tombstone_reason_get_type (void) {
	static volatile gsize tombstone_reason_type_id__volatile = 0;
	if (g_once_init_enter (&tombstone_reason_type_id__volatile)) {
		static const GEnumValue values[] = {{TOMBSTONE_REASON_REMOVED_BY_USER, "TOMBSTONE_REASON_REMOVED_BY_USER", "removed-by-user"}, {TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE, "TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE", "auto-detected-duplicate"}, {0, NULL, NULL}};
		GType tombstone_reason_type_id;
		tombstone_reason_type_id = g_enum_register_static ("TombstoneReason", values);
		g_once_init_leave (&tombstone_reason_type_id__volatile, tombstone_reason_type_id);
	}
	return tombstone_reason_type_id__volatile;
}


static gpointer _tombstone_row_ref0 (gpointer self) {
#line 203 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return self ? tombstone_row_ref (self) : NULL;
#line 2288 "Tombstone.c"
}


static Tombstone* tombstone_construct (GType object_type, TombstoneRow* row) {
	Tombstone * self = NULL;
	TombstoneRow* _tmp0_ = NULL;
	TombstoneRow* _tmp1_ = NULL;
#line 202 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (IS_TOMBSTONE_ROW (row), NULL);
#line 202 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self = (Tombstone*) data_source_construct (object_type, DATA_OBJECT_INVALID_OBJECT_ID);
#line 203 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = row;
#line 203 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = _tombstone_row_ref0 (_tmp0_);
#line 203 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tombstone_row_unref0 (self->priv->row);
#line 203 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self->priv->row = _tmp1_;
#line 202 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return self;
#line 2310 "Tombstone.c"
}


static Tombstone* tombstone_new (TombstoneRow* row) {
#line 202 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return tombstone_construct (TYPE_TOMBSTONE, row);
#line 2317 "Tombstone.c"
}


void tombstone_init (void) {
	TombstoneSourceCollection* _tmp0_ = NULL;
	TombstoneRow** rows = NULL;
	gint rows_length1 = 0;
	gint _rows_size_ = 0;
	TombstoneRow** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	GError * _inner_error_ = NULL;
#line 207 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = tombstone_source_collection_new ();
#line 207 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_data_collection_unref0 (tombstone_global);
#line 207 "/home/jens/Source/shotwell/src/Tombstone.vala"
	tombstone_global = _tmp0_;
#line 209 "/home/jens/Source/shotwell/src/Tombstone.vala"
	rows = NULL;
#line 209 "/home/jens/Source/shotwell/src/Tombstone.vala"
	rows_length1 = 0;
#line 209 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_rows_size_ = rows_length1;
#line 2341 "Tombstone.c"
	{
		TombstoneRow** _tmp1_ = NULL;
		TombstoneTable* _tmp2_ = NULL;
		TombstoneTable* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		TombstoneRow** _tmp5_ = NULL;
		TombstoneRow** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gint _tmp1__length1 = 0;
		gint __tmp1__size_ = 0;
		TombstoneRow** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp2_ = tombstone_table_get_instance ();
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp3_ = _tmp2_;
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp5_ = tombstone_table_fetch_all (_tmp3_, &_tmp4_, &_inner_error_);
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp6_ = _tmp5_;
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp6__length1 = _tmp4_;
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_database_table_unref0 (_tmp3_);
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp1_ = _tmp6_;
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp1__length1 = _tmp6__length1;
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		__tmp1__size_ = _tmp1__length1;
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 2376 "Tombstone.c"
				goto __catch540_database_error;
			}
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
			rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) tombstone_row_unref), NULL);
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
			g_clear_error (&_inner_error_);
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
			return;
#line 2387 "Tombstone.c"
		}
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp7_ = _tmp1_;
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp7__length1 = _tmp1__length1;
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp1_ = NULL;
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp1__length1 = 0;
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) tombstone_row_unref), NULL);
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		rows = _tmp7_;
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		rows_length1 = _tmp7__length1;
#line 211 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_rows_size_ = rows_length1;
#line 210 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) tombstone_row_unref), NULL);
#line 2407 "Tombstone.c"
	}
	goto __finally540;
	__catch540_database_error:
	{
		GError* err = NULL;
		GError* _tmp8_ = NULL;
#line 210 "/home/jens/Source/shotwell/src/Tombstone.vala"
		err = _inner_error_;
#line 210 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_inner_error_ = NULL;
#line 213 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp8_ = err;
#line 213 "/home/jens/Source/shotwell/src/Tombstone.vala"
		app_window_database_error (_tmp8_);
#line 210 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_error_free0 (err);
#line 2424 "Tombstone.c"
	}
	__finally540:
#line 210 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 210 "/home/jens/Source/shotwell/src/Tombstone.vala"
		rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) tombstone_row_unref), NULL);
#line 210 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 210 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_clear_error (&_inner_error_);
#line 210 "/home/jens/Source/shotwell/src/Tombstone.vala"
		return;
#line 2437 "Tombstone.c"
	}
#line 216 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp9_ = rows;
#line 216 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp9__length1 = rows_length1;
#line 216 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (_tmp9_ != NULL) {
#line 2445 "Tombstone.c"
		GeeArrayList* tombstones = NULL;
		GeeArrayList* _tmp10_ = NULL;
		TombstoneRow** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		TombstoneSourceCollection* _tmp17_ = NULL;
		GeeArrayList* _tmp18_ = NULL;
		GeeCollection* _tmp19_ = NULL;
		GeeCollection* _tmp20_ = NULL;
#line 217 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp10_ = gee_array_list_new (TYPE_TOMBSTONE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 217 "/home/jens/Source/shotwell/src/Tombstone.vala"
		tombstones = _tmp10_;
#line 218 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp11_ = rows;
#line 218 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp11__length1 = rows_length1;
#line 2462 "Tombstone.c"
		{
			TombstoneRow** row_collection = NULL;
			gint row_collection_length1 = 0;
			gint _row_collection_size_ = 0;
			gint row_it = 0;
#line 218 "/home/jens/Source/shotwell/src/Tombstone.vala"
			row_collection = _tmp11_;
#line 218 "/home/jens/Source/shotwell/src/Tombstone.vala"
			row_collection_length1 = _tmp11__length1;
#line 218 "/home/jens/Source/shotwell/src/Tombstone.vala"
			for (row_it = 0; row_it < _tmp11__length1; row_it = row_it + 1) {
#line 2474 "Tombstone.c"
				TombstoneRow* _tmp12_ = NULL;
				TombstoneRow* row = NULL;
#line 218 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp12_ = _tombstone_row_ref0 (row_collection[row_it]);
#line 218 "/home/jens/Source/shotwell/src/Tombstone.vala"
				row = _tmp12_;
#line 2481 "Tombstone.c"
				{
					GeeArrayList* _tmp13_ = NULL;
					TombstoneRow* _tmp14_ = NULL;
					Tombstone* _tmp15_ = NULL;
					Tombstone* _tmp16_ = NULL;
#line 219 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp13_ = tombstones;
#line 219 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp14_ = row;
#line 219 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp15_ = tombstone_new (_tmp14_);
#line 219 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp16_ = _tmp15_;
#line 219 "/home/jens/Source/shotwell/src/Tombstone.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp16_);
#line 219 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (_tmp16_);
#line 218 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tombstone_row_unref0 (row);
#line 2501 "Tombstone.c"
				}
			}
		}
#line 221 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp17_ = tombstone_global;
#line 221 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp18_ = tombstones;
#line 221 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp19_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
#line 221 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp20_ = _tmp19_;
#line 221 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_object_unref0 (_tmp20_);
#line 216 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_object_unref0 (tombstones);
#line 2517 "Tombstone.c"
	}
#line 206 "/home/jens/Source/shotwell/src/Tombstone.vala"
	rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) tombstone_row_unref), NULL);
#line 2521 "Tombstone.c"
}


void tombstone_terminate (void) {
}


static gpointer _backing_file_state_ref0 (gpointer self) {
#line 232 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return self ? backing_file_state_ref (self) : NULL;
#line 2532 "Tombstone.c"
}


void tombstone_entomb_many_sources (GeeCollection* sources, TombstoneReason reason, GError** error) {
	GeeCollection* files = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeCollection* _tmp21_ = NULL;
	TombstoneReason _tmp22_ = 0;
	GError * _inner_error_ = NULL;
#line 228 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 230 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = gee_array_list_new (TYPE_TOMBSTONED_FILE, (GBoxedCopyFunc) tombstoned_file_ref, tombstoned_file_unref, NULL, NULL, NULL);
#line 230 "/home/jens/Source/shotwell/src/Tombstone.vala"
	files = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
#line 2548 "Tombstone.c"
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
#line 231 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp1_ = sources;
#line 231 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 231 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_source_it = _tmp2_;
#line 231 "/home/jens/Source/shotwell/src/Tombstone.vala"
		while (TRUE) {
#line 2561 "Tombstone.c"
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			MediaSource* source = NULL;
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			MediaSource* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			BackingFileState** _tmp9_ = NULL;
#line 231 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp3_ = _source_it;
#line 231 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 231 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (!_tmp4_) {
#line 231 "/home/jens/Source/shotwell/src/Tombstone.vala"
				break;
#line 2578 "Tombstone.c"
			}
#line 231 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp5_ = _source_it;
#line 231 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 231 "/home/jens/Source/shotwell/src/Tombstone.vala"
			source = (MediaSource*) _tmp6_;
#line 232 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp7_ = source;
#line 232 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp9_ = media_source_get_backing_files_state (_tmp7_, &_tmp8_);
#line 2590 "Tombstone.c"
			{
				BackingFileState** state_collection = NULL;
				gint state_collection_length1 = 0;
				gint _state_collection_size_ = 0;
				gint state_it = 0;
#line 232 "/home/jens/Source/shotwell/src/Tombstone.vala"
				state_collection = _tmp9_;
#line 232 "/home/jens/Source/shotwell/src/Tombstone.vala"
				state_collection_length1 = _tmp8_;
#line 232 "/home/jens/Source/shotwell/src/Tombstone.vala"
				for (state_it = 0; state_it < _tmp8_; state_it = state_it + 1) {
#line 2602 "Tombstone.c"
					BackingFileState* _tmp10_ = NULL;
					BackingFileState* state = NULL;
#line 232 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tmp10_ = _backing_file_state_ref0 (state_collection[state_it]);
#line 232 "/home/jens/Source/shotwell/src/Tombstone.vala"
					state = _tmp10_;
#line 2609 "Tombstone.c"
					{
						GeeCollection* _tmp11_ = NULL;
						BackingFileState* _tmp12_ = NULL;
						GFile* _tmp13_ = NULL;
						GFile* _tmp14_ = NULL;
						BackingFileState* _tmp15_ = NULL;
						gint64 _tmp16_ = 0LL;
						BackingFileState* _tmp17_ = NULL;
						const gchar* _tmp18_ = NULL;
						TombstonedFile* _tmp19_ = NULL;
						TombstonedFile* _tmp20_ = NULL;
#line 233 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_tmp11_ = files;
#line 233 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_tmp12_ = state;
#line 233 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_tmp13_ = backing_file_state_get_file (_tmp12_);
#line 233 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_tmp14_ = _tmp13_;
#line 233 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_tmp15_ = state;
#line 233 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_tmp16_ = _tmp15_->filesize;
#line 233 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_tmp17_ = state;
#line 233 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_tmp18_ = _tmp17_->md5;
#line 233 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_tmp19_ = tombstoned_file_new (_tmp14_, _tmp16_, _tmp18_);
#line 233 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_tmp20_ = _tmp19_;
#line 233 "/home/jens/Source/shotwell/src/Tombstone.vala"
						gee_collection_add (_tmp11_, _tmp20_);
#line 233 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_tombstoned_file_unref0 (_tmp20_);
#line 233 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_g_object_unref0 (_tmp14_);
#line 232 "/home/jens/Source/shotwell/src/Tombstone.vala"
						_backing_file_state_unref0 (state);
#line 2649 "Tombstone.c"
					}
				}
#line 232 "/home/jens/Source/shotwell/src/Tombstone.vala"
				state_collection = (_vala_array_free (state_collection, state_collection_length1, (GDestroyNotify) backing_file_state_unref), NULL);
#line 2654 "Tombstone.c"
			}
#line 231 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (source);
#line 2658 "Tombstone.c"
		}
#line 231 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_object_unref0 (_source_it);
#line 2662 "Tombstone.c"
	}
#line 236 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp21_ = files;
#line 236 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp22_ = reason;
#line 236 "/home/jens/Source/shotwell/src/Tombstone.vala"
	tombstone_entomb_many_files (_tmp21_, _tmp22_, &_inner_error_);
#line 236 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 236 "/home/jens/Source/shotwell/src/Tombstone.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 236 "/home/jens/Source/shotwell/src/Tombstone.vala"
			g_propagate_error (error, _inner_error_);
#line 236 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (files);
#line 236 "/home/jens/Source/shotwell/src/Tombstone.vala"
			return;
#line 2680 "Tombstone.c"
		} else {
#line 236 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (files);
#line 236 "/home/jens/Source/shotwell/src/Tombstone.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 236 "/home/jens/Source/shotwell/src/Tombstone.vala"
			g_clear_error (&_inner_error_);
#line 236 "/home/jens/Source/shotwell/src/Tombstone.vala"
			return;
#line 2690 "Tombstone.c"
		}
	}
#line 228 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (files);
#line 2695 "Tombstone.c"
}


void tombstone_entomb_many_files (GeeCollection* files, TombstoneReason reason, GError** error) {
	Marker* to_destroy = NULL;
	TombstoneSourceCollection* _tmp0_ = NULL;
	Marker* _tmp1_ = NULL;
	TombstoneSourceCollection* _tmp15_ = NULL;
	Marker* _tmp16_ = NULL;
	GeeArrayList* tombstones = NULL;
	GeeArrayList* _tmp17_ = NULL;
	TombstoneSourceCollection* _tmp41_ = NULL;
	GeeArrayList* _tmp42_ = NULL;
	GeeCollection* _tmp43_ = NULL;
	GeeCollection* _tmp44_ = NULL;
	GError * _inner_error_ = NULL;
#line 239 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail (GEE_IS_COLLECTION (files));
#line 242 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = tombstone_global;
#line 242 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
#line 242 "/home/jens/Source/shotwell/src/Tombstone.vala"
	to_destroy = _tmp1_;
#line 2720 "Tombstone.c"
	{
		GeeIterator* _file_it = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
#line 243 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp2_ = files;
#line 243 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 243 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_file_it = _tmp3_;
#line 243 "/home/jens/Source/shotwell/src/Tombstone.vala"
		while (TRUE) {
#line 2733 "Tombstone.c"
			GeeIterator* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			TombstonedFile* file = NULL;
			GeeIterator* _tmp6_ = NULL;
			gpointer _tmp7_ = NULL;
			Tombstone* tombstone = NULL;
			TombstoneSourceCollection* _tmp8_ = NULL;
			TombstonedFile* _tmp9_ = NULL;
			GFile* _tmp10_ = NULL;
			Tombstone* _tmp11_ = NULL;
			Tombstone* _tmp12_ = NULL;
#line 243 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp4_ = _file_it;
#line 243 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 243 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (!_tmp5_) {
#line 243 "/home/jens/Source/shotwell/src/Tombstone.vala"
				break;
#line 2753 "Tombstone.c"
			}
#line 243 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp6_ = _file_it;
#line 243 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 243 "/home/jens/Source/shotwell/src/Tombstone.vala"
			file = (TombstonedFile*) _tmp7_;
#line 244 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp8_ = tombstone_global;
#line 244 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp9_ = file;
#line 244 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp10_ = _tmp9_->file;
#line 244 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp11_ = tombstone_source_collection_locate (_tmp8_, _tmp10_);
#line 244 "/home/jens/Source/shotwell/src/Tombstone.vala"
			tombstone = _tmp11_;
#line 245 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp12_ = tombstone;
#line 245 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (_tmp12_ != NULL) {
#line 2775 "Tombstone.c"
				Marker* _tmp13_ = NULL;
				Tombstone* _tmp14_ = NULL;
#line 246 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp13_ = to_destroy;
#line 246 "/home/jens/Source/shotwell/src/Tombstone.vala"
				_tmp14_ = tombstone;
#line 246 "/home/jens/Source/shotwell/src/Tombstone.vala"
				marker_mark (_tmp13_, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_OBJECT, DataObject));
#line 2784 "Tombstone.c"
			}
#line 243 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (tombstone);
#line 243 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tombstoned_file_unref0 (file);
#line 2790 "Tombstone.c"
		}
#line 243 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_object_unref0 (_file_it);
#line 2794 "Tombstone.c"
	}
#line 249 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp15_ = tombstone_global;
#line 249 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp16_ = to_destroy;
#line 249 "/home/jens/Source/shotwell/src/Tombstone.vala"
	source_collection_destroy_marked (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp16_, FALSE, NULL, NULL, NULL);
#line 251 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp17_ = gee_array_list_new (TYPE_TOMBSTONE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 251 "/home/jens/Source/shotwell/src/Tombstone.vala"
	tombstones = _tmp17_;
#line 2806 "Tombstone.c"
	{
		GeeIterator* _file_it = NULL;
		GeeCollection* _tmp18_ = NULL;
		GeeIterator* _tmp19_ = NULL;
#line 252 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp18_ = files;
#line 252 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp19_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ITERABLE, GeeIterable));
#line 252 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_file_it = _tmp19_;
#line 252 "/home/jens/Source/shotwell/src/Tombstone.vala"
		while (TRUE) {
#line 2819 "Tombstone.c"
			GeeIterator* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
			TombstonedFile* file = NULL;
			GeeIterator* _tmp22_ = NULL;
			gpointer _tmp23_ = NULL;
			TombstoneRow* _tmp24_ = NULL;
			TombstoneTable* _tmp25_ = NULL;
			TombstoneTable* _tmp26_ = NULL;
			TombstonedFile* _tmp27_ = NULL;
			GFile* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			TombstonedFile* _tmp31_ = NULL;
			gint64 _tmp32_ = 0LL;
			TombstonedFile* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			TombstoneReason _tmp35_ = 0;
			TombstoneRow* _tmp36_ = NULL;
			TombstoneRow* _tmp37_ = NULL;
			GeeArrayList* _tmp38_ = NULL;
			Tombstone* _tmp39_ = NULL;
			Tombstone* _tmp40_ = NULL;
#line 252 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp20_ = _file_it;
#line 252 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp21_ = gee_iterator_next (_tmp20_);
#line 252 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (!_tmp21_) {
#line 252 "/home/jens/Source/shotwell/src/Tombstone.vala"
				break;
#line 2850 "Tombstone.c"
			}
#line 252 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp22_ = _file_it;
#line 252 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp23_ = gee_iterator_get (_tmp22_);
#line 252 "/home/jens/Source/shotwell/src/Tombstone.vala"
			file = (TombstonedFile*) _tmp23_;
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp25_ = tombstone_table_get_instance ();
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp26_ = _tmp25_;
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp27_ = file;
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp28_ = _tmp27_->file;
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp29_ = g_file_get_path (_tmp28_);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp30_ = _tmp29_;
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp31_ = file;
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp32_ = _tmp31_->filesize;
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp33_ = file;
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp34_ = _tmp33_->md5;
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp35_ = reason;
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp36_ = tombstone_table_add (_tmp26_, _tmp30_, _tmp32_, _tmp34_, _tmp35_, &_inner_error_);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp37_ = _tmp36_;
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_free0 (_tmp30_);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_database_table_unref0 (_tmp26_);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp24_ = _tmp37_;
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
					g_propagate_error (error, _inner_error_);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tombstoned_file_unref0 (file);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (_file_it);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (tombstones);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (to_destroy);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
					return;
#line 2906 "Tombstone.c"
				} else {
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_tombstoned_file_unref0 (file);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (_file_it);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (tombstones);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
					_g_object_unref0 (to_destroy);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
					g_clear_error (&_inner_error_);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
					return;
#line 2922 "Tombstone.c"
				}
			}
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp38_ = tombstones;
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp39_ = tombstone_new (_tmp24_);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tmp40_ = _tmp39_;
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp40_);
#line 253 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_g_object_unref0 (_tmp40_);
#line 252 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tombstone_row_unref0 (_tmp24_);
#line 252 "/home/jens/Source/shotwell/src/Tombstone.vala"
			_tombstoned_file_unref0 (file);
#line 2939 "Tombstone.c"
		}
#line 252 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_object_unref0 (_file_it);
#line 2943 "Tombstone.c"
	}
#line 257 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp41_ = tombstone_global;
#line 257 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp42_ = tombstones;
#line 257 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp43_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
#line 257 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp44_ = _tmp43_;
#line 257 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (_tmp44_);
#line 239 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (tombstones);
#line 239 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (to_destroy);
#line 2959 "Tombstone.c"
}


static gchar* tombstone_real_get_typename (DataSource* base) {
	Tombstone * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 260 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TOMBSTONE, Tombstone);
#line 261 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = g_strdup ("tombstone");
#line 261 "/home/jens/Source/shotwell/src/Tombstone.vala"
	result = _tmp0_;
#line 261 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 2975 "Tombstone.c"
}


static gint64 tombstone_real_get_instance_id (DataSource* base) {
	Tombstone * self;
	gint64 result = 0LL;
	TombstoneID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
#line 264 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TOMBSTONE, Tombstone);
#line 265 "/home/jens/Source/shotwell/src/Tombstone.vala"
	tombstone_get_tombstone_id (self, &_tmp0_);
#line 265 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = _tmp0_.id;
#line 265 "/home/jens/Source/shotwell/src/Tombstone.vala"
	result = _tmp1_;
#line 265 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 2994 "Tombstone.c"
}


static gchar* tombstone_real_get_name (DataObject* base) {
	Tombstone * self;
	gchar* result = NULL;
	TombstoneRow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 268 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TOMBSTONE, Tombstone);
#line 269 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = self->priv->row;
#line 269 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = _tmp0_->filepath;
#line 269 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 269 "/home/jens/Source/shotwell/src/Tombstone.vala"
	result = _tmp2_;
#line 269 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 3016 "Tombstone.c"
}


static gchar* tombstone_real_to_string (DataObject* base) {
	Tombstone * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 272 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TOMBSTONE, Tombstone);
#line 273 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 273 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = _tmp0_;
#line 273 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp2_ = g_strdup_printf ("Tombstone %s", _tmp1_);
#line 273 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp3_ = _tmp2_;
#line 273 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_free0 (_tmp1_);
#line 273 "/home/jens/Source/shotwell/src/Tombstone.vala"
	result = _tmp3_;
#line 273 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 3043 "Tombstone.c"
}


void tombstone_get_tombstone_id (Tombstone* self, TombstoneID* result) {
	TombstoneRow* _tmp0_ = NULL;
	TombstoneID _tmp1_ = {0};
#line 276 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail (IS_TOMBSTONE (self));
#line 277 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = self->priv->row;
#line 277 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = _tmp0_->id;
#line 277 "/home/jens/Source/shotwell/src/Tombstone.vala"
	*result = _tmp1_;
#line 277 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return;
#line 3060 "Tombstone.c"
}


GFile* tombstone_get_file (Tombstone* self) {
	GFile* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
#line 280 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (IS_TOMBSTONE (self), NULL);
#line 281 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = self->priv->file;
#line 281 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (_tmp0_ == NULL) {
#line 3075 "Tombstone.c"
		TombstoneRow* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
#line 282 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp1_ = self->priv->row;
#line 282 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp2_ = _tmp1_->filepath;
#line 282 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp3_ = g_file_new_for_path (_tmp2_);
#line 282 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_object_unref0 (self->priv->file);
#line 282 "/home/jens/Source/shotwell/src/Tombstone.vala"
		self->priv->file = _tmp3_;
#line 3089 "Tombstone.c"
	}
#line 284 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp4_ = self->priv->file;
#line 284 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 284 "/home/jens/Source/shotwell/src/Tombstone.vala"
	result = _tmp5_;
#line 284 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 3099 "Tombstone.c"
}


gchar* tombstone_get_md5 (Tombstone* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	TombstoneRow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp6_ = NULL;
#line 287 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (IS_TOMBSTONE (self), NULL);
#line 288 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = self->priv->row;
#line 288 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp2_ = _tmp1_->md5;
#line 288 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp3_ = is_string_empty (_tmp2_);
#line 288 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (_tmp3_) {
#line 288 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp0_ = NULL;
#line 3122 "Tombstone.c"
	} else {
		TombstoneRow* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 288 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp4_ = self->priv->row;
#line 288 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp5_ = _tmp4_->md5;
#line 288 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp0_ = _tmp5_;
#line 3132 "Tombstone.c"
	}
#line 288 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp6_ = g_strdup (_tmp0_);
#line 288 "/home/jens/Source/shotwell/src/Tombstone.vala"
	result = _tmp6_;
#line 288 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 3140 "Tombstone.c"
}


TombstoneReason tombstone_get_reason (Tombstone* self) {
	TombstoneReason result = 0;
	TombstoneRow* _tmp0_ = NULL;
	TombstoneReason _tmp1_ = 0;
#line 291 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (IS_TOMBSTONE (self), 0);
#line 292 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = self->priv->row;
#line 292 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = _tmp0_->reason;
#line 292 "/home/jens/Source/shotwell/src/Tombstone.vala"
	result = _tmp1_;
#line 292 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 3158 "Tombstone.c"
}


void tombstone_move (Tombstone* self, GFile* file) {
	gchar* old_filepath = NULL;
	TombstoneRow* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	TombstoneRow* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GFile* _tmp14_ = NULL;
	GFile* _tmp15_ = NULL;
	Alteration* _tmp16_ = NULL;
	Alteration* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
#line 295 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail (IS_TOMBSTONE (self));
#line 295 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 3179 "Tombstone.c"
	{
		TombstoneTable* _tmp0_ = NULL;
		TombstoneTable* _tmp1_ = NULL;
		TombstoneRow* _tmp2_ = NULL;
		TombstoneID _tmp3_ = {0};
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp0_ = tombstone_table_get_instance ();
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp1_ = _tmp0_;
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp2_ = self->priv->row;
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp3_ = _tmp2_->id;
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp4_ = file;
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp5_ = g_file_get_path (_tmp4_);
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp6_ = _tmp5_;
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
		tombstone_table_update_file (_tmp1_, &_tmp3_, _tmp6_, &_inner_error_);
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_free0 (_tmp6_);
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_database_table_unref0 (_tmp1_);
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 3212 "Tombstone.c"
				goto __catch541_database_error;
			}
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
			g_clear_error (&_inner_error_);
#line 297 "/home/jens/Source/shotwell/src/Tombstone.vala"
			return;
#line 3221 "Tombstone.c"
		}
	}
	goto __finally541;
	__catch541_database_error:
	{
		GError* err = NULL;
		GError* _tmp7_ = NULL;
#line 296 "/home/jens/Source/shotwell/src/Tombstone.vala"
		err = _inner_error_;
#line 296 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_inner_error_ = NULL;
#line 299 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp7_ = err;
#line 299 "/home/jens/Source/shotwell/src/Tombstone.vala"
		app_window_database_error (_tmp7_);
#line 296 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_error_free0 (err);
#line 3239 "Tombstone.c"
	}
	__finally541:
#line 296 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 296 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 296 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_clear_error (&_inner_error_);
#line 296 "/home/jens/Source/shotwell/src/Tombstone.vala"
		return;
#line 3250 "Tombstone.c"
	}
#line 302 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp8_ = self->priv->row;
#line 302 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp9_ = _tmp8_->filepath;
#line 302 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp10_ = g_strdup (_tmp9_);
#line 302 "/home/jens/Source/shotwell/src/Tombstone.vala"
	old_filepath = _tmp10_;
#line 303 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp11_ = self->priv->row;
#line 303 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp12_ = file;
#line 303 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp13_ = g_file_get_path (_tmp12_);
#line 303 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_free0 (_tmp11_->filepath);
#line 303 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp11_->filepath = _tmp13_;
#line 304 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp14_ = file;
#line 304 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp15_ = _g_object_ref0 (_tmp14_);
#line 304 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (self->priv->file);
#line 304 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self->priv->file = _tmp15_;
#line 306 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp16_ = alteration_new ("file", old_filepath);
#line 306 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp17_ = _tmp16_;
#line 306 "/home/jens/Source/shotwell/src/Tombstone.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp17_);
#line 306 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_alteration_unref0 (_tmp17_);
#line 295 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_free0 (old_filepath);
#line 3288 "Tombstone.c"
}


gboolean tombstone_matches (Tombstone* self, GFile* file, gint64 filesize, const gchar* md5) {
	gboolean result = FALSE;
	TombstoneRow* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	const gchar* _tmp3_ = NULL;
	TombstoneRow* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* this_md5 = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gchar* other_md5 = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GFile* _tmp17_ = NULL;
	GFile* _tmp18_ = NULL;
	GFile* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
#line 309 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (IS_TOMBSTONE (self), FALSE);
#line 309 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 310 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp0_ = self->priv->row;
#line 310 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp1_ = _tmp0_->filesize;
#line 310 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp2_ = filesize;
#line 310 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (_tmp1_ != _tmp2_) {
#line 311 "/home/jens/Source/shotwell/src/Tombstone.vala"
		result = FALSE;
#line 311 "/home/jens/Source/shotwell/src/Tombstone.vala"
		return result;
#line 3331 "Tombstone.c"
	}
#line 314 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp4_ = self->priv->row;
#line 314 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp5_ = _tmp4_->md5;
#line 314 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp6_ = is_string_empty (_tmp5_);
#line 314 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (_tmp6_) {
#line 314 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp3_ = NULL;
#line 3343 "Tombstone.c"
	} else {
		TombstoneRow* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 314 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp7_ = self->priv->row;
#line 314 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp8_ = _tmp7_->md5;
#line 314 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp3_ = _tmp8_;
#line 3353 "Tombstone.c"
	}
#line 314 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp9_ = g_strdup (_tmp3_);
#line 314 "/home/jens/Source/shotwell/src/Tombstone.vala"
	this_md5 = _tmp9_;
#line 315 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp11_ = md5;
#line 315 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp12_ = is_string_empty (_tmp11_);
#line 315 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (_tmp12_) {
#line 315 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp10_ = NULL;
#line 3367 "Tombstone.c"
	} else {
		const gchar* _tmp13_ = NULL;
#line 315 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp13_ = md5;
#line 315 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp10_ = _tmp13_;
#line 3374 "Tombstone.c"
	}
#line 315 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp14_ = g_strdup (_tmp10_);
#line 315 "/home/jens/Source/shotwell/src/Tombstone.vala"
	other_md5 = _tmp14_;
#line 317 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp15_ = this_md5;
#line 317 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp16_ = other_md5;
#line 317 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (g_strcmp0 (_tmp15_, _tmp16_) != 0) {
#line 318 "/home/jens/Source/shotwell/src/Tombstone.vala"
		result = FALSE;
#line 318 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_free0 (other_md5);
#line 318 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_free0 (this_md5);
#line 318 "/home/jens/Source/shotwell/src/Tombstone.vala"
		return result;
#line 3394 "Tombstone.c"
	}
#line 320 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp17_ = tombstone_get_file (self);
#line 320 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp18_ = _tmp17_;
#line 320 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp19_ = file;
#line 320 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp20_ = g_file_equal (_tmp18_, _tmp19_);
#line 320 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tmp21_ = !_tmp20_;
#line 320 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (_tmp18_);
#line 320 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (_tmp21_) {
#line 321 "/home/jens/Source/shotwell/src/Tombstone.vala"
		result = FALSE;
#line 321 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_free0 (other_md5);
#line 321 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_free0 (this_md5);
#line 321 "/home/jens/Source/shotwell/src/Tombstone.vala"
		return result;
#line 3418 "Tombstone.c"
	}
#line 323 "/home/jens/Source/shotwell/src/Tombstone.vala"
	result = TRUE;
#line 323 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_free0 (other_md5);
#line 323 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_free0 (this_md5);
#line 323 "/home/jens/Source/shotwell/src/Tombstone.vala"
	return result;
#line 3428 "Tombstone.c"
}


static void tombstone_real_destroy (DataSource* base) {
	Tombstone * self;
	GError * _inner_error_ = NULL;
#line 326 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TOMBSTONE, Tombstone);
#line 3437 "Tombstone.c"
	{
		TombstoneTable* _tmp0_ = NULL;
		TombstoneTable* _tmp1_ = NULL;
		TombstoneRow* _tmp2_ = NULL;
		TombstoneID _tmp3_ = {0};
#line 328 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp0_ = tombstone_table_get_instance ();
#line 328 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp1_ = _tmp0_;
#line 328 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp2_ = self->priv->row;
#line 328 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp3_ = _tmp2_->id;
#line 328 "/home/jens/Source/shotwell/src/Tombstone.vala"
		tombstone_table_remove (_tmp1_, &_tmp3_, &_inner_error_);
#line 328 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_database_table_unref0 (_tmp1_);
#line 328 "/home/jens/Source/shotwell/src/Tombstone.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 328 "/home/jens/Source/shotwell/src/Tombstone.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 3459 "Tombstone.c"
				goto __catch542_database_error;
			}
#line 328 "/home/jens/Source/shotwell/src/Tombstone.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 328 "/home/jens/Source/shotwell/src/Tombstone.vala"
			g_clear_error (&_inner_error_);
#line 328 "/home/jens/Source/shotwell/src/Tombstone.vala"
			return;
#line 3468 "Tombstone.c"
		}
	}
	goto __finally542;
	__catch542_database_error:
	{
		GError* err = NULL;
		GError* _tmp4_ = NULL;
#line 327 "/home/jens/Source/shotwell/src/Tombstone.vala"
		err = _inner_error_;
#line 327 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_inner_error_ = NULL;
#line 330 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_tmp4_ = err;
#line 330 "/home/jens/Source/shotwell/src/Tombstone.vala"
		app_window_database_error (_tmp4_);
#line 327 "/home/jens/Source/shotwell/src/Tombstone.vala"
		_g_error_free0 (err);
#line 3486 "Tombstone.c"
	}
	__finally542:
#line 327 "/home/jens/Source/shotwell/src/Tombstone.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 327 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 327 "/home/jens/Source/shotwell/src/Tombstone.vala"
		g_clear_error (&_inner_error_);
#line 327 "/home/jens/Source/shotwell/src/Tombstone.vala"
		return;
#line 3497 "Tombstone.c"
	}
#line 333 "/home/jens/Source/shotwell/src/Tombstone.vala"
	DATA_SOURCE_CLASS (tombstone_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource));
#line 3501 "Tombstone.c"
}


static void tombstone_class_init (TombstoneClass * klass) {
#line 174 "/home/jens/Source/shotwell/src/Tombstone.vala"
	tombstone_parent_class = g_type_class_peek_parent (klass);
#line 174 "/home/jens/Source/shotwell/src/Tombstone.vala"
	g_type_class_add_private (klass, sizeof (TombstonePrivate));
#line 174 "/home/jens/Source/shotwell/src/Tombstone.vala"
	((DataSourceClass *) klass)->get_typename = tombstone_real_get_typename;
#line 174 "/home/jens/Source/shotwell/src/Tombstone.vala"
	((DataSourceClass *) klass)->get_instance_id = tombstone_real_get_instance_id;
#line 174 "/home/jens/Source/shotwell/src/Tombstone.vala"
	((DataObjectClass *) klass)->get_name = tombstone_real_get_name;
#line 174 "/home/jens/Source/shotwell/src/Tombstone.vala"
	((DataObjectClass *) klass)->to_string = tombstone_real_to_string;
#line 174 "/home/jens/Source/shotwell/src/Tombstone.vala"
	((DataSourceClass *) klass)->destroy = tombstone_real_destroy;
#line 174 "/home/jens/Source/shotwell/src/Tombstone.vala"
	G_OBJECT_CLASS (klass)->finalize = tombstone_finalize;
#line 3522 "Tombstone.c"
}


static void tombstone_instance_init (Tombstone * self) {
#line 174 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self->priv = TOMBSTONE_GET_PRIVATE (self);
#line 200 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self->priv->file = NULL;
#line 3531 "Tombstone.c"
}


static void tombstone_finalize (GObject* obj) {
	Tombstone * self;
#line 174 "/home/jens/Source/shotwell/src/Tombstone.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOMBSTONE, Tombstone);
#line 199 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_tombstone_row_unref0 (self->priv->row);
#line 200 "/home/jens/Source/shotwell/src/Tombstone.vala"
	_g_object_unref0 (self->priv->file);
#line 174 "/home/jens/Source/shotwell/src/Tombstone.vala"
	G_OBJECT_CLASS (tombstone_parent_class)->finalize (obj);
#line 3545 "Tombstone.c"
}


GType tombstone_get_type (void) {
	static volatile gsize tombstone_type_id__volatile = 0;
	if (g_once_init_enter (&tombstone_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TombstoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tombstone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tombstone), 0, (GInstanceInitFunc) tombstone_instance_init, NULL };
		GType tombstone_type_id;
		tombstone_type_id = g_type_register_static (TYPE_DATA_SOURCE, "Tombstone", &g_define_type_info, 0);
		g_once_init_leave (&tombstone_type_id__volatile, tombstone_type_id);
	}
	return tombstone_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



