# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: relaxng flow/logic

=end
module SiSU_Relaxng
  require_relative 'sysenv'                             # sysenv.rb
  class RelaxNG
    def gpl3_or_later
      @gpl3_or_later =<<RELAXNG
=begin

 * Name: SiSU generated relaxng

 * Description: generated relaxng for SiSU
   (SiSU is a framework for document structuring, publishing and search)

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2012 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright: (C) 1997 - 2012 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>
   <http://www.jus.uio.no/sisu/gpl.fsf>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

=end
RELAXNG
    end
    def rnc_name
      def output_sax
        'sisu_sax.rnc'
      end
      def output_dom
        'sisu_dom.rnc'
      end
      def output_xhtml
        'sisu_xhtml.rnc'
      end
      def input_sax
        'sisu_sax.rnc'
      end
      def input_dom
        'sisu_dom.rnc'
      end
      def input_node
        'sisu_node.rnc'
      end
      self
    end
    def rng_name
      def output_sax
        'sisu_sax.rng'
      end
      def output_dom
        'sisu_dom.rng'
      end
      def output_xhtml
        'sisu_xhtml.rng'
      end
      def input_sax
        'sisu_sax.rng'
      end
      def input_dom
        'sisu_dom.rng'
      end
      def input_node
        'sisu_node.rng'
      end
      self
    end
    def xsd_name
      def output_sax
        'sisu_sax.xsd'
      end
      def output_dom
        'sisu_dom.xsd'
      end
      def output_xhtml
        'sisu_xhtml.xsd'
      end
      def input_sax
        'sisu_sax.xsd'
      end
      def input_dom
        'sisu_dom.xsd'
      end
      def input_node
        'sisu_node.xsd'
      end
      self
    end
    def rnc_sisu_object_input
      @relaxng =<<RELAXNG
#%% sisu object model: input
#{gpl3_or_later}
#%% definitions
# dublin core:
element-semantic =
  element semantic {
  # dublin core:
  element title { text }
  & element creator { text }?
  & element subject { text }?
  & element description { text }?
  & element publisher { text }?
  & element contributor { text }?
  & element date { text }?
  & element date.created { text }?
  & element date.issued { text }?
  & element date.available { text }?
  & element date.valid { text }?
  & element date.modified { text }?
  & element type { text }?
  & element format { text }?
  & element identifier { text }?
  & element source { text }?
  & element relation { text }?
  & element coverage { text }?
  & element rights { text }?
  & element keywords { text }?
  # extended semantic metadata:
  & attribute subtitle { text }?
  & attribute illustrator { text }?
  & attribute translator { text }?
  & attribute prepared_by { text }?
  & attribute digitized_by { text }?
  & attribute language { text }?
  & attribute language.original { text }?
  & attribute classify.pg { text }?
  & attribute classify.isbn { text }?
  & attribute classify.dewey { text }?
  & attribute classify.loc { text }?
  & attribute prefix.a { text }?
  & attribute prefix.b { text }?
  & attribute suffix { text }?
  & attribute comments { text }?
  & attribute abstract { text }?
  # & attribute information { text }?
  & attribute contact { text }?
  & attribute links { text }?
  }
element-processing =
  element processing {
  attribute structure { text }?
  & attribute level { text }?
  & attribute markup { text }?
  & attribute bold { text }?
  & attribute italics { text }?
  & attribute papersize { text }?
  & attribute vocabulary { text }?
  & element date_scheme { text }?
  & element date.issued.scheme { text }?
  & element date.available.scheme { text }?
  & element date.valid.scheme { text }?
  & element date.modified.scheme { text }?
  }?
element-head =
  element head {
    # processing instructions, and semantic data, distinguish?:
    element metadata {
      element title { text },
      element file { text },
      element generator { text },
      element-semantic,
      element-processing
    }+
  }
# body text/contents
# includes <b> <i> <u> <del> <ins> <indent1> <bullet> etc.
element-txt =
  element txt {
    text*
    & element b { text }*
    & element i { text }*
    & element u { text }*
    & element ins { text }*
    & element del { text }*
  }
element-endnote =
  element endnote {
    element number { text },
    element note { element-txt }+
  }+
element-para =
  element para {
    # attribute paragraph_format { text },
    element-txt+
    & element-endnote?
  }
element-external_space =
  element external_space {
    # ignored by sisu, provide program needs
    element program {
      # e.g. kdissert
      element name { text },
      element xpos { text },
      element ypos { text },
      element font { text },
      element outline_color { text },
      element text_color { text },
      element comment { text }
    }*
  }*,
#%% structure
  element document {
    # document head:
    element-head,
    # document body:
    element body {
      # object, a unit of text, usually a paragraph with any associated endnotes
      element node {
        element structure {
          # structure document using either node:heading levels or node:heading relationships:
          # (i) sisu default uses node:heading levels (1-6 or A-C,1-3) to build document structure
          element level { text }?,
          # (ii) sisu alternatively could use node:heading relationship information to build document structure
          element node.id { text },
          element node.parent { text },
          element node.child { text }*
        },
        element node.objects {
          element object.heading {
            # nametag used only in headings, especially important for segmented html
            element nametag { text },
            element-para
          },
          element object.para {
            element-para
          }*
        }+,
        element-external_space
      }+
    }
  }
RELAXNG
    end
    def rnc_sisu_object_dal
      @relaxng =<<RELAXNG
#%% sisu object model: dal
#{gpl3_or_later}
#%% definitions
# dublin core:
element-semantic =
  element semantic {
  # dublin core:
  element title { text }
  & element creator { text }?
  & element subject { text }?
  & element description { text }?
  & element publisher { text }?
  & element contributor { text }?
  & element date { text }?
  & element date.created { text }?
  & element date.issued { text }?
  & element date.available { text }?
  & element date.valid { text }?
  & element date.modified { text }?
  & element type { text }?
  & element format { text }?
  & element identifier { text }?
  & element source { text }?
  & element relation { text }?
  & element coverage { text }?
  & element rights { text }?
  & element keywords { text }?
  # extended semantic metadata:
  & attribute subtitle { text }?
  & attribute illustrator { text }?
  & attribute translator { text }?
  & attribute prepared_by { text }?
  & attribute digitized_by { text }?
  & attribute language { text }?
  & attribute language.original { text }?
  & attribute classify.pg { text }?
  & attribute classify.isbn { text }?
  & attribute classify.dewey { text }?
  & attribute classify.loc { text }?
  & attribute prefix.a { text }?
  & attribute prefix.b { text }?
  & attribute suffix { text }?
  & attribute comments { text }?
  & attribute abstract { text }?
  # & attribute information { text }?
  & attribute contact { text }?
  & attribute links { text }?
  }
element-processing =
  element processing {
  attribute structure { text }?
  & attribute level { text }?
  & attribute markup { text }?
  & attribute bold { text }?
  & attribute italics { text }?
  & attribute papersize { text }?
  & attribute vocabulary { text }?
  & element date_scheme { text }?
  & element date.issued.scheme { text }?
  & element date.available.scheme { text }?
  & element date.valid.scheme { text }?
  & element date.modified.scheme { text }?
  }?
element-head =
  element head {
    # processing instructions, and semantic data, distinguish?:
    element metadata {
      element title { text },
      element file { text },
      element generator { text },
      element-semantic,
      element-processing
    }+
  }
# body text/contents
# includes <b> <i> <u> <del> <ins> <indent1> <bullet> etc.
element-txt =
  element txt {
    text*
    & element b { text }*
    & element i { text }*
    & element u { text }*
    & element ins { text }*
    & element del { text }*
  }
element-checksum.endnote = element checksum.clean { text }
element-endnote =
  element endnote {
    element number { text },
    element note { element-txt }+,
    element-checksum.endnote
  }+
element-checksum.para =
  element checksum.para {
    element checksum.clean { text },
    element checksum.marked { text }
  }
element-para =
  element para {
    # attribute paragraph_format { text },
    element-txt+
    & element-endnote?
  }
element-object =
  element object {
    element-para,
    element-checksum.para
  }
# object citation number, unique sequential number for objects:
element-ocn = element ocn { text }
element-object_structure_summary =
  element-ocn,
  # type: heading level value 1 -6, or normal text
  element type { text },
  # type number: sequential number for designated type
  element type_number { text },
  # type category: sequential number for designated category, e.g. sequentially counting all headers
  element category_number { text }
element-external_space =
  element external_space {
    # ignored by sisu, provide program needs
    element program {
      # e.g. kdissert
      element name { text },
      element xpos { text },
      element ypos { text },
      element font { text },
      element outline_color { text },
      element text_color { text },
      element comment { text }
    }*
  }*,
#%% structure
  element document {
    # document head:
    element-head,
    # document body:
    element body {
      # object, a unit of text, usually a paragraph with any associated endnotes
      element node {
        element structure {
          # structure document using either node:heading levels or node:heading relationships:
          # (i) sisu default uses node:heading levels (1-6 or A-C,1-3) to build document structure
          element level { text }?,
          # (ii) sisu alternatively could use node:heading relationship information to build document structure
          element node.id { text },
          element node.parent { text },
          element node.child { text }*
        },
        element node.objects {
          element object.heading {
            element-object_structure_summary,
            # nametag used only in headings, especially important for segmented html
            element nametag { text },
            element-object
          },
          element object.para {
            element-object_structure_summary,
            element-object
          }*
        }+,
        element-external_space
      }+
    }
  }
RELAXNG
    end
    def rnc_model_output_sax
      @relaxng =<<RELAXNG
#% sax output model, part of SiSU and distributed under the same license
default namespace = ""
namespace xlink = "http://www.w3.org/1999/xlink"
start =
  element document {
    element head {
      (br
       | meta
       | element creator {
           attribute class { xsd:NCName },
           (text
            | element link {
                attribute xlink:href { xsd:anyURI },
                attribute xlink:type { xsd:NCName },
                xsd:anyURI
              })+
         }
       | element date {
           attribute class { xsd:NCName },
           xsd:NMTOKEN
         }
       | element date_available {
           attribute class { xsd:NCName },
           xsd:NMTOKEN
         }
       | element date_created {
           attribute class { xsd:NCName },
           xsd:NMTOKEN
         }
       | element date_issued {
           attribute class { xsd:NCName },
           xsd:NMTOKEN
         }
       | element date_modified {
           attribute class { xsd:NCName },
           xsd:NMTOKEN
         }
       | element date_valid {
           attribute class { xsd:NCName },
           xsd:NMTOKEN
         }
       | element keywords {
           attribute class { xsd:NCName },
           text
         }
       | element language {
           attribute class { xsd:NCName },
           xsd:NCName
         }
       | element meta { xsd:NMTOKEN }
       | element rights {
           attribute class { xsd:NCName },
           (text | link)+
         }
       | element source {
           attribute class { xsd:NCName },
           text
         }
       | element structure {
           attribute class { xsd:NCName },
           text
         }
       | element subject {
           attribute class { xsd:NCName },
           text
         }
       | element title {
           attribute class { xsd:NCName },
           text
         }
       | element type {
           attribute class { xsd:NCName },
           text
         }
       | element source_control {
           (br
            | meta
            | element sc {
                attribute class { xsd:NCName },
                text
              })+
         })+
    },
    element body {
      element object {
        attribute id { text },
        element ocn {
          text
        },
        element text {
          attribute class { xsd:NCName },
          (text
           | b
           | br
           | del
           | en
           | i
           | link
           | sub
           | sup
           | u
           | element image {
               attribute alt { text }?,
               attribute height { xsd:integer }?,
               attribute width { xsd:integer }?,
               attribute xlink:actuate { xsd:NCName },
               attribute xlink:href { text },
               attribute xlink:show { xsd:NCName },
               attribute xlink:type { xsd:NCName }
             })+
        }?,
        element table {
          attribute align { xsd:NCName },
          attribute bgcolor { xsd:NCName },
          attribute border { xsd:integer },
          attribute cellpadding { xsd:integer },
          attribute summary { text },
          attribute width { text },
          element tr {
            element td {
              attribute valign { xsd:NCName },
              attribute width { text },
              (text | b | i)+
            }+
          }+
        }?,
        element endnote {
          attribute notenumber { xsd:integer }?,
          attribute symbol { text }?,
          (element number { xsd:integer }
           | element symbol { text }),
          element note {
            (text
             | b
             | br
             | del
             | i
             | link
             | sup
             | u
             | element em { xsd:NCName }
             | element sub { xsd:NCName })+
          }
        }*
      }+
    }
  }
meta = element meta { text }
br = element br { empty }
b = element b { (text | en | i | link | sup)+ }
i = element i { (text | b | br | sup)+ }
en = element en { text }
sub = element sub { xsd:NCName }
sup = element sup { xsd:NCName }
link =
  element link {
    attribute xlink:href { xsd:anyURI },
    attribute xlink:type { xsd:NCName },
    (xsd:anyURI | text | b | i | sup)+
  }
u = element u { (text | b | i)+ }
del = element del { (text | b | i | link)+ }
RELAXNG
    end
    def rnc_model_output_dom
      @relaxng =<<RELAXNG
#% dom output model, part of SiSU and distributed under the same license
default namespace = ""
namespace xlink = "http://www.w3.org/1999/xlink"
start =
  element document {
    element head {
      element header {
        meta,
        (element creator { text }
         | element date { xsd:NMTOKEN }
         | element date_available { xsd:NMTOKEN }
         | element date_created { xsd:NMTOKEN }
         | element date_issued { xsd:NMTOKEN }
         | element date_modified { xsd:NMTOKEN }
         | element date_valid { xsd:NMTOKEN }
         | element keywords { text }
         | element language { xsd:NCName }
         | element rights { (text | link)+ }
         | element source { text }
         | element structure { text }
         | element subject { text }
         | element title { text }
         | element type { text }
         | element source_control {
             (br
              | meta
              | element sc {
                  attribute class { xsd:NCName },
                  text
                })+
           })
      }+
    },
    element body {
      element heading1 {
        heading,
        contents1*,
        element heading2 {
          heading,
          contents1*,
          element heading3 {
            heading,
            element contents1 {
              heading,
              content,
              element contents2 {
                heading,
                content,
                element contents3 { heading, content }*
              }*
            }+
          }*
        }*
      }+
    }
  }
meta = element meta { text }
br = element br { empty }
heading = element heading { object }
contents1 =
  element contents1 {
    heading,
    content,
    element contents2 {
      heading,
      content,
      element contents3 { heading, content }*
    }*
  }
content = element content { object* }
object =
  element object {
    attribute id { xsd:integer },
    element ocn { text },
    element nametag { text }?,
    (element table {
       attribute align { xsd:NCName },
       attribute bgcolor { xsd:NCName },
       attribute border { xsd:integer },
       attribute cellpadding { xsd:integer },
       attribute summary { text },
       attribute width { text },
       element tr {
         element td {
           attribute valign { xsd:NCName },
           attribute width { text },
           (text | b | i)+
         }+
       }+
     }
     | element text {
         attribute class { xsd:NCName }?,
         (text
          | b
          | del
          | endnote
          | i
          | link
          | element br { empty }
          | element endnote {
              element number { xsd:integer },
              element note { (text | i | link)+ }
            }
          | element image {
              attribute height { xsd:integer },
              attribute width { xsd:integer },
              attribute xlink:actuate { xsd:NCName },
              attribute xlink:href { text },
              attribute xlink:show { xsd:NCName },
              attribute xlink:type { xsd:NCName }
            }
          | element sub { text })+
       })
  }
i = element i { text }
b = element i { text }
u = element u { (text | b | i)+ }
sub = element sub { xsd:NCName }
sup = element sup { xsd:NCName }
del = element del { (text | b | i | link)+ }
link =
  element link {
    attribute xlink:href { xsd:anyURI },
    attribute xlink:type { xsd:NCName },
    xsd:anyURI
  }
endnote =
  element endnote {
    (element number { xsd:integer }
     | element symbol { text }),
    element note {
      (text
       | b
       | br
       | del
       | i
       | link
       | sub
       | sup
       | u
       | element em { xsd:NCName }
       | element sub { xsd:NCName })+
    }
  }
RELAXNG
    end
    def rnc_model_output_xhtml #not done
      @relaxng =<<RELAXNG
#% xhtml output model, part of SiSU and distributed under the same license
default namespace = ""
namespace xlink = "http://www.w3.org/1999/xlink"
start =
  element document {
    element head {
      (br
       | element creator {
           attribute class { xsd:NCName },
           (text
            | element link {
                attribute xlink:href { xsd:anyURI },
                attribute xlink:type { xsd:NCName },
                xsd:anyURI
              })+
         }
       | element date {
           attribute class { xsd:NCName },
           xsd:NMTOKEN
         }
       | element date_available {
           attribute class { xsd:NCName },
           xsd:NMTOKEN
         }
       | element date_created {
           attribute class { xsd:NCName },
           xsd:NMTOKEN
         }
       | element date_issued {
           attribute class { xsd:NCName },
           xsd:NMTOKEN
         }
       | element date_modified {
           attribute class { xsd:NCName },
           xsd:NMTOKEN
         }
       | element date_valid {
           attribute class { xsd:NCName },
           xsd:NMTOKEN
         }
       | element language {
           attribute class { xsd:NCName },
           xsd:NCName
         }
       | element keywords {
           attribute class { xsd:NCName },
           text
         }
       | element meta {
           attribute content { text }?,
           attribute http-equiv { xsd:NCName }?,
           text
         }
       | element rights {
           attribute class { xsd:NCName },
           (text | link)+
         }
       | element source {
           attribute class { xsd:NCName },
           text
         }
       | element structure {
           attribute class { xsd:NCName },
           text
         }
       | element subject {
           attribute class { xsd:NCName },
           text
         }
       | element title {
           attribute class { xsd:NCName },
           text
         }
       | element type {
           attribute class { xsd:NCName },
           xsd:NCName
         })+
    },
    element body {
      element object {
        attribute id { xsd:integer },
        (element endnote {
           attribute notenumber { xsd:integer }?,
           attribute symbol { text }?,
           (text
            | b
            | br
            | del
            | i
            | link
            | sup
            | u
            | element em { xsd:NCName }
            | element sub { xsd:NCName })+
         }
         | element ocn { text }
         | element text {
             attribute class { xsd:NCName },
             (text
              | b
              | br
              | del
              | en
              | i
              | link
              | sup
              | u
              | element image {
                  attribute alt { text }?,
                  attribute height { xsd:integer }?,
                  attribute width { xsd:integer }?,
                  attribute xlink:actuate { xsd:NCName },
                  attribute xlink:href { text },
                  attribute xlink:show { xsd:NCName },
                  attribute xlink:type { xsd:NCName }
                }
              | element sub { text })+
           })+,
        element table {
          attribute align { xsd:NCName },
          attribute bgcolor { xsd:NCName },
          attribute border { xsd:integer },
          attribute cellpadding { xsd:integer },
          attribute summary { text },
          attribute width { text },
          element tr {
            element td {
              attribute valign { xsd:NCName },
              attribute width { text },
              (text | b | i)+
            }+
          }+
        }?
      }+
    }
  }
br = element br { empty }
en = element en { text }
sup = element sup { xsd:NCName }
i = element i { (text | b | br | sup)+ }
link =
  element link {
    attribute xlink:href { xsd:anyURI },
    attribute xlink:type { xsd:NCName },
    (text | b | i | sup)+
  }
b = element b { (text | en | i | link | sup)+ }
u = element u { (text | b | i)+ }
del = element del { (text | b | i | link)+ }
RELAXNG
    end
    def rnc_model_input_sax
      @relaxng =<<RELAXNG
#% sax input model, part of SiSU and distributed under the same license
default namespace = ""
start =
  element document {
    element head {
      element header {
        attribute class { xsd:NCName },
        (element creator { text }
         | element date { xsd:NMTOKEN }
         | element date.available { xsd:NMTOKEN }
         | element date.created { xsd:NMTOKEN }
         | element date.issued { xsd:NMTOKEN }
         | element date.modified { xsd:NMTOKEN }
         | element date.valid { xsd:NMTOKEN }
         | element italicize { text }
         | element language { xsd:NCName }
         | element links { text }
         | element markup { text }
         | element rights { text }
         | element skin { xsd:NCName }
         | element subject { text }
         | element title { text }
         | element type { xsd:NCName }
         | element vocabulary { xsd:NCName })
      }+
    },
    element body {
      element object {
        element text {
          attribute class { xsd:NCName },
          (text
           | b
           | i
           | element endnote {
               attribute symbol { xsd:NCName },
               (text
                | i
                | element br { empty })+
             }
           | element u { i }
           | element image.path { text })+
        }?
      }+
    }
  }
i = element i { text }
b = element b { text }
RELAXNG
    end
    def rnc_model_input_dom
      @relaxng =<<RELAXNG
#% dom input model, part of SiSU and distributed under the same license
default namespace = ""
start =
  element document {
    element head {
      element header {
        attribute class { xsd:NCName },
        (element creator { text }
         | element date { xsd:NMTOKEN }
         | element date.available { xsd:NMTOKEN }
         | element date.created { xsd:NMTOKEN }
         | element date.issued { xsd:NMTOKEN }
         | element date.modified { xsd:NMTOKEN }
         | element date.valid { xsd:NMTOKEN }
         | element italicize { text }
         | element language { xsd:NCName }
         | element links { text }
         | element markup { text }
         | element rights { text }
         | element skin { xsd:NCName }
         | element subject { text }
         | element title { text }
         | element type { xsd:NCName }
         | element vocabulary { xsd:NCName })
      }+
    },
    element body {
      element heading1 {
        heading,
        element heading2 {
          heading,
          contents1+,
          element heading3 { heading, contents1+ }+
        }
      }
    }
  }
heading = element heading { object }
contents1 =
  element contents1 {
    heading,
    content,
    element contents2 {
      heading,
      content,
      element contents3 { heading, content }*
    }*
  }
object =
  element object {
    element text {
      (text
       | italic
       | element bold { xsd:NMTOKEN }
       | element endnote {
           element symbol { text }?,
           element note {
             (text
              | italic
              | element br { empty })+
           }
         }
       | element underscore { italic }
       | element image.path { text }
       | element italic { text })+
    }
  }
italic = element italic { text }
content = element content { object+ }
RELAXNG
    end
    def rnc_model_input_node
      @relaxng =<<RELAXNG
#% node input model, part of SiSU and distributed under the same license
default namespace = ""
start =
  element document {
    element head {
      element header {
        attribute class { xsd:NCName },
        (element creator { text }
         | element date { xsd:NMTOKEN }
         | element date.available { xsd:NMTOKEN }
         | element date.created { xsd:NMTOKEN }
         | element date.issued { xsd:NMTOKEN }
         | element date.modified { xsd:NMTOKEN }
         | element date.valid { xsd:NMTOKEN }
         | element italicize { (text | i)+ }
         | element language { xsd:NCName }
         | element links { text }
         | element markup { text }
         | element rights { text }
         | element skin { xsd:NCName }
         | element subject { text }
         | element title { text }
         | element type { xsd:NCName }
         | element vocabulary { xsd:NCName })
      }+
    },
    element body {
      element object {
        (element text {
           attribute class { xsd:NCName },
           (text
            | b
            | i
            | element br { empty }
            | element endnote {
                attribute symbol { xsd:NCName },
                (text | i)+
              }
            | element image.path { text }
            | element sub { text })+
         }
         | (element ocn { empty },
            element table {
              attribute align { xsd:NCName },
              attribute bgcolor { xsd:NCName },
              attribute border { xsd:integer },
              attribute cellpadding { xsd:integer },
              attribute summary { text },
              attribute width { text },
              element tr {
                element td {
                  attribute valign { xsd:NCName },
                  attribute width { text },
                  (text | b)+
                }+
              }+
            })),
        element node {
          element id { xsd:integer },
          element parent { xsd:integer },
          element offspring { text }?
        }
      }+
    }
  }
b = element b { text }
i = element i { text }
RELAXNG
    end
  end
end
__END__
needs updating
