/***************************************************************************
    smb4kpreviewitem  -   A container for previews of a remote share
                             -------------------
    begin                : Mo Mai 28 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// KDE includes
#include <QHostAddress>

// application specific includes
#include <smb4kpreviewitem.h>

Smb4KPreviewItem::Smb4KPreviewItem( Smb4KShare *share, const QString &path )
: m_share( *share )
{
  setPath( path );
}


Smb4KPreviewItem::~Smb4KPreviewItem()
{
}


void Smb4KPreviewItem::setPath( const QString &path )
{
  if ( path.trimmed().isEmpty() )
  {
    m_path = "/";
  }
  else
  {
    m_path = path+(!path.endsWith( "/" ) ? "/" : QString());
  }

  m_location = m_share.unc()+m_path;

  clearContents();
}


void Smb4KPreviewItem::addContents( const ContentsItem &item )
{
  m_contents.append( item );
}


void Smb4KPreviewItem::clearContents()
{
  m_contents.clear();
}


bool Smb4KPreviewItem::isRootDirectory()
{
  if ( QString::compare( m_path.trimmed(), "/" ) == 0 )
  {
    return true;
  }
  else
  {
    // Do nothing
  }

  return false;
}


