/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import enums.MotionRestriction;
import interfaces.HandleListener;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import shapes.Point2DExt;

public class Handle
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8791712547811891550L;
    private Point2DExt location;
    private String name;
    private HandleListener listener;
    private MotionRestriction restriction;

    public Handle(Point2D.Double location, String name, MotionRestriction restriction) {
        this.location = new Point2DExt(location);
        this.name = name;
        this.restriction = restriction;
    }

    public Handle(Handle source) {
        this.location = new Point2DExt(source.location);
        this.name = source.name;
        this.restriction = source.restriction;
    }

    public void setHandleListener(HandleListener listener) {
        this.listener = listener;
    }

    public String getName() {
        return this.name;
    }

    public Point2D.Double getLocation() {
        return this.location;
    }

    public void setLocationAndNotify(Point2D.Double location) {
        this.setLocation(location);
        if (this.listener != null) {
            this.listener.handleLocationChanged(this);
        }
    }

    public void setUnrestrictedLocation(Point2D.Double location) {
        this.location.x = location.x;
        this.location.y = location.y;
    }

    private void setLocation(Point2D.Double location) {
        switch (this.restriction) {
            case Horizontal: {
                this.location.x = location.x;
                break;
            }
            case Vertical: {
                this.location.y = location.y;
                break;
            }
            case None: {
                this.location.x = location.x;
                this.location.y = location.y;
            }
        }
    }

    public void Draw(Graphics2D g) {
        AffineTransform currentTransform = g.getTransform();
        Point2D t = currentTransform.transform(this.location, null);
        g.setTransform(new AffineTransform());
        Rectangle2D.Double e = new Rectangle2D.Double();
        e.setFrameFromCenter(t.getX(), t.getY(), t.getX() + 2.0, t.getY() + 2.0);
        g.setColor(Color.WHITE);
        g.fill(e);
        g.setColor(Color.BLACK);
        g.draw(e);
        g.setTransform(currentTransform);
    }

    public boolean hit(Point p, AffineTransform tx) {
        Point2D t = tx.transform(this.location, null);
        Rectangle2D.Double e = new Rectangle2D.Double();
        e.setFrameFromCenter(t.getX(), t.getY(), t.getX() + 5.0, t.getY() + 5.0);
        return e.contains(p);
    }
}

